/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.transformation.GridBasedTransformation;
import org.cts.op.transformation.grid.GridShift;
import org.cts.op.transformation.grid.GridShiftFile;
import org.cts.op.transformation.grids.GridUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTv2GridShiftTransformation
extends AbstractCoordinateOperation
implements GridBasedTransformation {
    static final Logger LOGGER = LoggerFactory.getLogger(NTv2GridShiftTransformation.class);
    private static final Identifier opId = new Identifier("EPSG", "9615", "NTv2 Geographic Offset", "NTv2");
    public static final int SPEED = 0;
    public static final int LOW_MEMORY = 1;
    private int mode = 1;
    private final URL grid_file;
    private final GridShiftFile gsf;
    private NTv2GridShiftTransformation inverse;

    public static NTv2GridShiftTransformation createNTv2GridShiftTransformation(String ntv2_gridName) throws NullPointerException, IOException {
        URL urlGRID = GridUtils.class.getResource(ntv2_gridName);
        if (urlGRID == null) {
            urlGRID = GridUtils.findGrid(ntv2_gridName).toURI().toURL();
        }
        return new NTv2GridShiftTransformation(urlGRID);
    }

    public NTv2GridShiftTransformation(URL ntv2_gridFile, double precision) {
        super(opId);
        this.grid_file = ntv2_gridFile;
        this.gsf = new GridShiftFile();
        this.precision = Math.max(1.0E-9, precision);
    }

    public NTv2GridShiftTransformation(URL ntv2_gridFile) {
        super(opId);
        this.grid_file = ntv2_gridFile;
        if (ntv2_gridFile == null) {
            LOGGER.warn("No NTv2 Grid file specified.");
        }
        this.gsf = new GridShiftFile();
        this.precision = 0.1;
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 2) {
            throw new CoordinateDimensionException(coord, 2);
        }
        GridShift gs = new GridShift();
        gs.setLatDegrees(coord[0] * 180.0 / Math.PI);
        gs.setLonPositiveEastDegrees(coord[1] * 180.0 / Math.PI);
        try {
            boolean withinGrid;
            if (this.gsf == null || !this.gsf.isLoaded()) {
                this.loadGridShiftFile();
            }
            if (withinGrid = this.gsf.gridShiftForward(gs)) {
                coord[0] = gs.getShiftedLatDegrees() * Math.PI / 180.0;
                coord[1] = gs.getShiftedLonPositiveEastDegrees() * Math.PI / 180.0;
            }
        }
        catch (IOException ioe) {
            throw new CoordinateDimensionException(ioe.getMessage());
        }
        return coord;
    }

    @Override
    public CoordinateOperation inverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        try {
            if (this.gsf == null || !this.gsf.isLoaded()) {
                this.loadGridShiftFile();
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Could not load GridShiftFile " + String.valueOf(this.grid_file));
        }
        this.inverse = new NTv2GridShiftTransformation(this.grid_file, this.precision){

            @Override
            public double[] transform(double[] coord) throws IllegalCoordinateException {
                if (coord.length < 2) {
                    throw new CoordinateDimensionException(coord, 2);
                }
                GridShift gs = new GridShift();
                gs.setLatDegrees(coord[0] * 180.0 / Math.PI);
                gs.setLonPositiveEastDegrees(coord[1] * 180.0 / Math.PI);
                try {
                    boolean withinGrid = NTv2GridShiftTransformation.this.gsf.gridShiftReverse(gs);
                    if (withinGrid) {
                        coord[0] = gs.getShiftedLatDegrees() * Math.PI / 180.0;
                        coord[1] = gs.getShiftedLonPositiveEastDegrees() * Math.PI / 180.0;
                    }
                }
                catch (IOException ioe) {
                    throw new CoordinateDimensionException(ioe.getMessage());
                }
                return coord;
            }

            @Override
            public CoordinateOperation inverse() {
                return NTv2GridShiftTransformation.this;
            }
        };
        return this.inverse;
    }

    public void loadGridShiftFile() throws IOException {
        block16: {
            if (this.grid_file != null) {
                if (this.mode == 0) {
                    if (this.grid_file.getProtocol().equals("file")) {
                        InputStream is = null;
                        try {
                            is = this.grid_file.openConnection().getInputStream();
                            if (is == null) {
                                LOGGER.warn("This grid doesn't exist or cannot be read.");
                                break block16;
                            }
                            this.gsf.loadGridShiftFile(is, false);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            LOGGER.error("This grid doesn't exist or cannot be read.", (Throwable)e);
                        }
                    } else {
                        BufferedInputStream is = new BufferedInputStream(this.grid_file.openConnection().getInputStream());
                        this.gsf.loadGridShiftFile(is, false);
                    }
                } else if (this.mode == 1) {
                    if (this.grid_file.getProtocol().equals("file")) {
                        InputStream is = null;
                        try {
                            is = this.grid_file.openConnection().getInputStream();
                            if (is == null) {
                                LOGGER.warn("This grid doesn't exist or cannot be read.");
                                break block16;
                            }
                            this.gsf.loadGridShiftFile(is, false);
                        }
                        catch (IOException e) {
                            LOGGER.error("This grid doesn't exist or cannot be read.", (Throwable)e);
                        }
                    } else {
                        LOGGER.warn("This grid cannot be accessed.");
                    }
                } else {
                    LOGGER.warn("This mode is not supported. The grid won't be used.");
                }
            } else {
                LOGGER.warn("The location of the grid is null. Any grid will be used.");
            }
        }
    }

    public boolean isLoaded() {
        return this.gsf.isLoaded();
    }

    public void unload() throws IOException {
        this.gsf.unload();
    }

    public boolean setMode(int mode) throws IOException {
        if ((mode == 0 || mode == 1) && this.mode != mode) {
            this.mode = mode;
            this.unload();
            this.loadGridShiftFile();
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "NTv2 Geographic Offset (" + String.valueOf(this.grid_file) + ")";
    }

    public String getFromDatum() {
        return this.gsf.getFromEllipsoid().trim().toLowerCase();
    }

    public String getToDatum() {
        return this.gsf.getToEllipsoid().trim().toLowerCase();
    }
}

