/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.HashMap;
import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.datum.Ellipsoid;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;
import org.cts.units.Unit;

public class LambertConicConformal1SP
extends Projection {
    public static final Identifier LCC1SP = new Identifier("EPSG", "9801", "Lambert Conic Conformal (1SP)", "Lambert tangent");
    public static final LambertConicConformal1SP LAMBERT1 = LambertConicConformal1SP.createLCC1SP(Ellipsoid.CLARKE1880IGN, 55.0, 0.99987734, 0.0, Unit.GRAD, 600000.0, 200000.0, Unit.METER);
    public static final LambertConicConformal1SP LAMBERT2 = LambertConicConformal1SP.createLCC1SP(Ellipsoid.CLARKE1880IGN, 52.0, 0.99987742, 0.0, Unit.GRAD, 600000.0, 200000.0, Unit.METER);
    public static final LambertConicConformal1SP LAMBERT3 = LambertConicConformal1SP.createLCC1SP(Ellipsoid.CLARKE1880IGN, 49.0, 0.9998775, 0.0, Unit.GRAD, 600000.0, 200000.0, Unit.METER);
    public static final LambertConicConformal1SP LAMBERT4 = LambertConicConformal1SP.createLCC1SP(Ellipsoid.CLARKE1880IGN, 47.8, 0.99994471, 0.0, Unit.GRAD, 234.358, 185861.369, Unit.METER);
    public static final LambertConicConformal1SP LAMBERT2E = LambertConicConformal1SP.createLCC1SP(Ellipsoid.CLARKE1880IGN, 52.0, 0.99987742, 0.0, Unit.GRAD, 600000.0, 2200000.0, Unit.METER);
    public static final LambertConicConformal1SP LAMBERT93 = LambertConicConformal1SP.createLCC1SP(Ellipsoid.GRS80, 46.5, 0.9990510286374, 3.0, Unit.DEGREE, 700000.0, 6600000.0, Unit.METER);
    protected final double lon0;
    protected final double n;
    protected final double C;
    protected final double xs;
    protected final double ys;

    public LambertConicConformal1SP(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(LCC1SP, ellipsoid, parameters);
        double lat0 = this.getLatitudeOfOrigin();
        this.lon0 = this.getCentralMeridian();
        double k0 = this.getScaleFactor();
        double x0 = this.getFalseEasting();
        double y0 = this.getFalseNorthing();
        double latIso0 = ellipsoid.isometricLatitude(lat0);
        double N0 = ellipsoid.transverseRadiusOfCurvature(lat0);
        this.n = Math.sin(lat0);
        this.C = k0 * N0 * Math.exp(this.n * latIso0) / Math.tan(lat0);
        this.xs = x0;
        this.ys = y0 + k0 * N0 / Math.tan(lat0);
    }

    public static LambertConicConformal1SP createLCC1SP(Ellipsoid ellipsoid, double latitude_of_origin, double scale_factor, double central_meridian, double false_easting, double false_northing) {
        return LambertConicConformal1SP.createLCC1SP(ellipsoid, latitude_of_origin, scale_factor, central_meridian, Unit.DEGREE, false_easting, false_northing, Unit.METER);
    }

    public static LambertConicConformal1SP createLCC1SP(Ellipsoid ellipsoid, double latitude_of_origin, double scale_factor, double central_meridian, Unit angleUnit, double false_easting, double false_northing, Unit planimetricUnit) {
        HashMap<String, Measure> params = new HashMap<String, Measure>();
        params.put("latitude of origin", new Measure(latitude_of_origin, angleUnit));
        params.put("scale factor", new Measure(scale_factor, Unit.UNIT));
        params.put("central meridian", new Measure(central_meridian, angleUnit));
        params.put("false easting", new Measure(false_easting, planimetricUnit));
        params.put("false northing", new Measure(false_northing, planimetricUnit));
        return new LambertConicConformal1SP(ellipsoid, params);
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 2) {
            throw new CoordinateDimensionException(coord, 2);
        }
        if (Double.isNaN(coord[0]) || Double.isNaN(coord[1])) {
            throw new IllegalCoordinateException("Input coordinates can't ne NaN : ", coord);
        }
        double latIso = this.ellipsoid.isometricLatitude(coord[0]);
        double x = this.xs + this.C * Math.exp(-this.n * latIso) * Math.sin(this.n * (coord[1] - this.lon0));
        double y = this.ys - this.C * Math.exp(-this.n * latIso) * Math.cos(this.n * (coord[1] - this.lon0));
        coord[0] = x;
        coord[1] = y;
        return coord;
    }

    @Override
    public Projection inverse() {
        return new LambertConicConformal1SP(this.ellipsoid, this.parameters){

            @Override
            public double[] transform(double[] coord) {
                double lat;
                double x = coord[0];
                double y = coord[1];
                double R = Math.sqrt((x - this.xs) * (x - this.xs) + (y - this.ys) * (y - this.ys));
                double g = Math.atan((x - this.xs) / (this.ys - y));
                double lon = this.lon0 + g / this.n;
                double latIso = -1.0 / this.n * Math.log(Math.abs(R / this.C));
                coord[0] = lat = this.ellipsoid.latitude(latIso);
                coord[1] = lon;
                return coord;
            }

            @Override
            public Projection inverse() {
                return LambertConicConformal1SP.this;
            }

            @Override
            public boolean isDirect() {
                return false;
            }

            @Override
            public String toString() {
                return LambertConicConformal1SP.this.toString() + " inverse";
            }
        };
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CONICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public String toString() {
        return "Lambert Conic Conformal (1SP) [lat0=" + String.valueOf(this.parameters.get("latitude of origin")) + ";lon0=" + String.valueOf(this.parameters.get("central meridian")) + ";k=" + String.valueOf(this.parameters.get("scale factor")) + ";x0=" + String.valueOf(this.parameters.get("false easting")) + ";y0=" + String.valueOf(this.parameters.get("false northing")) + "]";
    }
}

