/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cts.Identifier;
import org.cts.crs.GeodeticCRS;
import org.cts.datum.Ellipsoid;
import org.cts.datum.GeodeticDatum;
import org.cts.datum.PrimeMeridian;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.CoordinateOperationNotFoundException;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.Geocentric2Geographic;
import org.cts.op.Geographic2Geocentric;
import org.cts.op.LongitudeRotation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.transformation.GeocentricTransformation;
import org.cts.op.transformation.GeocentricTransformationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoordinateOperationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinateOperationFactory.class);

    public static Set<CoordinateOperation> createCoordinateOperations(GeodeticCRS source, GeodeticCRS target) throws CoordinateOperationException {
        if (source == null) {
            throw new IllegalArgumentException("The source CRS must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("The target CRS must not be null");
        }
        HashSet<CoordinateOperation> opList = new HashSet<CoordinateOperation>();
        GeodeticDatum sourceDatum = source.getDatum();
        if (sourceDatum == null) {
            LOG.warn(source.getName() + " has no Geodetic Datum");
            throw new IllegalArgumentException("The source datum must not be null");
        }
        GeodeticDatum targetDatum = target.getDatum();
        if (targetDatum == null) {
            LOG.warn(target.getName() + " has no Geodetic Datum");
            throw new IllegalArgumentException("The target datum must not be null");
        }
        if (sourceDatum.equals(targetDatum)) {
            CoordinateOperationFactory.addCoordinateOperations(source, target, opList);
        } else {
            CoordinateOperationFactory.addCoordinateOperations(sourceDatum, source, targetDatum, target, opList);
        }
        if (opList.isEmpty()) {
            LOG.warn("No transformation found from " + source.getCode() + " to " + target.getCode());
            throw new IllegalArgumentException("No transformation found from " + source.getCode() + " to " + target.getCode());
        }
        return opList;
    }

    private static void addCoordinateOperations(GeodeticCRS source, GeodeticCRS target, Set<CoordinateOperation> opList) throws CoordinateOperationException {
        try {
            opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, source.getCode() + " to " + target.getCode()), source.toGeographicCoordinateConverter(), target.fromGeographicCoordinateConverter()));
        }
        catch (NonInvertibleOperationException e) {
            LOG.warn("Operation from " + source.getCode() + " to " + target.getCode() + " could not be created");
            LOG.error("CoordinateOperationFactory", (Throwable)e);
        }
    }

    private static void addCoordinateOperations(GeodeticDatum sourceDatum, GeodeticCRS source, GeodeticDatum targetDatum, GeodeticCRS target, Set<CoordinateOperation> opList) throws CoordinateOperationException {
        HashSet<CoordinateOperation> datumTransformations = new HashSet<CoordinateOperation>(2);
        if (source.getCoordinateSystem().getDimension() == 3 || target.getCoordinateSystem().getDimension() == 3) {
            CoordinateOperation mostPrecise3DTransform = CoordinateOperationFactory.getMostPrecise3DTransformation(sourceDatum.getGeocentricTransformations(targetDatum));
            if (mostPrecise3DTransform != null) {
                datumTransformations.add(mostPrecise3DTransform);
            }
            if (sourceDatum.getToWGS84() != null && sourceDatum.getToWGS84().isIdentity() && sourceDatum.getPrimeMeridian().equals(PrimeMeridian.GREENWICH) && (sourceDatum.getEllipsoid().equals(Ellipsoid.GRS80) || sourceDatum.getEllipsoid().equals(Ellipsoid.WGS84))) {
                datumTransformations.addAll(GeodeticDatum.WGS84.getGeocentricTransformations(targetDatum));
            }
            if (targetDatum.getToWGS84() != null && targetDatum.getToWGS84().isIdentity() && targetDatum.getPrimeMeridian().equals(PrimeMeridian.GREENWICH) && (targetDatum.getEllipsoid().equals(Ellipsoid.GRS80) || targetDatum.getEllipsoid().equals(Ellipsoid.WGS84))) {
                datumTransformations.addAll(sourceDatum.getGeocentricTransformations(GeodeticDatum.WGS84));
            }
            if (!datumTransformations.isEmpty()) {
                for (CoordinateOperation datumTransformation : datumTransformations) {
                    try {
                        GeocentricTransformationSequence newSequence = new GeocentricTransformationSequence(new Identifier(CoordinateOperation.class, source.getCode() + " to " + target.getCode() + " through " + datumTransformation.getName()), source.toGeographicCoordinateConverter(), new LongitudeRotation(source.getDatum().getPrimeMeridian().getLongitudeFromGreenwichInRadians()), new Geographic2Geocentric(source.getDatum().getEllipsoid()), datumTransformation, new Geocentric2Geographic(target.getDatum().getEllipsoid()), new LongitudeRotation(target.getDatum().getPrimeMeridian().getLongitudeFromGreenwichInRadians()).inverse(), target.fromGeographicCoordinateConverter());
                        opList.add(newSequence);
                    }
                    catch (NonInvertibleOperationException e) {
                        LOG.warn("Operation from " + source.getCode() + " to " + target.getCode() + " through " + datumTransformation.getName() + " could not be created");
                        LOG.error("CoordinateOperationFactory", (Throwable)e);
                    }
                }
                if (opList.isEmpty()) {
                    throw new CoordinateOperationNotFoundException(sourceDatum, targetDatum);
                }
            } else {
                LOG.warn("Cannot create a CoordinateOperation from :\n" + String.valueOf(source) + "\nto :\n" + String.valueOf(target));
            }
        } else {
            sourceDatum.getGeocentricTransformations(targetDatum);
            datumTransformations.addAll(sourceDatum.getGeographicTransformations(targetDatum));
            if (sourceDatum.getToWGS84() != null && sourceDatum.getToWGS84().isIdentity() && sourceDatum.getPrimeMeridian().equals(PrimeMeridian.GREENWICH) && (sourceDatum.getEllipsoid().equals(Ellipsoid.GRS80) || sourceDatum.getEllipsoid().equals(Ellipsoid.WGS84))) {
                datumTransformations.addAll(GeodeticDatum.WGS84.getGeographicTransformations(targetDatum));
            }
            if (targetDatum.getToWGS84() != null && targetDatum.getToWGS84().isIdentity() && targetDatum.getPrimeMeridian().equals(PrimeMeridian.GREENWICH) && (targetDatum.getEllipsoid().equals(Ellipsoid.GRS80) || targetDatum.getEllipsoid().equals(Ellipsoid.WGS84))) {
                datumTransformations.addAll(sourceDatum.getGeographicTransformations(GeodeticDatum.WGS84));
            }
            if (!datumTransformations.isEmpty()) {
                for (CoordinateOperation datumTf : datumTransformations) {
                    try {
                        opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class, source.getCode() + " to " + target.getCode() + " through " + datumTf.getName()), source.toGeographicCoordinateConverter(), datumTf, target.fromGeographicCoordinateConverter()));
                    }
                    catch (NonInvertibleOperationException e) {
                        LOG.warn("Operation from " + source.getCode() + " to " + target.getCode() + " through " + datumTf.getName() + " could not be created");
                        LOG.error("CoordinateOperationFactory", (Throwable)e);
                    }
                }
            } else {
                LOG.warn("Cannot create a CoordinateOperation from :\n" + String.valueOf(source) + "\nto :\n" + String.valueOf(target));
            }
        }
    }

    public static Set<CoordinateOperation> includeFilter(Collection<? extends CoordinateOperation> ops, Class clazz) {
        HashSet<CoordinateOperation> list = new HashSet<CoordinateOperation>();
        for (CoordinateOperation coordinateOperation : ops) {
            if (clazz.isAssignableFrom(coordinateOperation.getClass())) {
                list.add(coordinateOperation);
                continue;
            }
            if (!(coordinateOperation instanceof CoordinateOperationSequence)) continue;
            boolean includeOp = false;
            for (CoordinateOperation subOp : ((CoordinateOperationSequence)coordinateOperation).getSequence()) {
                if (!clazz.isAssignableFrom(subOp.getClass())) continue;
                includeOp = true;
                break;
            }
            if (!includeOp) continue;
            list.add(coordinateOperation);
        }
        return list;
    }

    public static Set<CoordinateOperation> excludeFilter(Collection<? extends CoordinateOperation> ops, Class clazz) {
        HashSet<CoordinateOperation> list = new HashSet<CoordinateOperation>();
        for (CoordinateOperation coordinateOperation : ops) {
            if (clazz.isAssignableFrom(coordinateOperation.getClass()) || !(coordinateOperation instanceof CoordinateOperationSequence)) continue;
            boolean excludedOp = false;
            for (CoordinateOperation subOp : ((CoordinateOperationSequence)coordinateOperation).getSequence()) {
                if (!clazz.isAssignableFrom(subOp.getClass())) continue;
                excludedOp = true;
                break;
            }
            if (excludedOp) continue;
            list.add(coordinateOperation);
        }
        return list;
    }

    public static CoordinateOperation getMostPrecise(Collection<? extends CoordinateOperation> ops) {
        CoordinateOperation preciseOp = null;
        double currentPrecision = Double.MAX_VALUE;
        for (CoordinateOperation coordinateOperation : ops) {
            if (!(coordinateOperation.getPrecision() < currentPrecision)) continue;
            preciseOp = coordinateOperation;
            currentPrecision = coordinateOperation.getPrecision();
        }
        return preciseOp;
    }

    public static CoordinateOperation getMostPrecise3DTransformation(Collection<? extends CoordinateOperation> ops) {
        CoordinateOperation preciseOp = null;
        double currentPrecision = Double.MAX_VALUE;
        for (CoordinateOperation coordinateOperation : ops) {
            if (!(coordinateOperation.getPrecision() < currentPrecision) || !(coordinateOperation instanceof GeocentricTransformation)) continue;
            preciseOp = coordinateOperation;
            currentPrecision = coordinateOperation.getPrecision();
        }
        return preciseOp;
    }
}

