/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.voronoi;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Arrays;
import org.tinfour.voronoi.BoundedVoronoiRenderingType;
import org.tinfour.voronoi.BoundedVoronoiVertexSymbol;
import org.tinfour.voronoi.IBoundedVoronoiStyler;
import org.tinfour.voronoi.IBoundedVoronoiVertexSymbol;
import org.tinfour.voronoi.ThiessenPolygon;

public class BoundedVoronoiStylerDefault
implements IBoundedVoronoiStyler {
    private static final Color[] defaultPalette = new Color[]{Color.YELLOW, Color.MAGENTA, Color.ORANGE, Color.LIGHT_GRAY, Color.PINK, Color.GREEN.brighter(), Color.RED, Color.BLUE};
    private static final Stroke thinStroke = new BasicStroke(1.0f);
    boolean[] typeEnabled = new boolean[BoundedVoronoiRenderingType.values().length];
    boolean vertexLabelingEnabled = true;
    boolean vertexSymbolEnabled = true;
    double vertexSymbolSize = 9.0;
    Font vertexLabelingFont = new Font("Dialog", 1, 12);
    boolean areaFillEnabled = true;
    boolean lineDrawEnabled = true;
    Color[] palette = defaultPalette;
    Color lineColor = Color.black;
    Color vertexColor = Color.black;
    Stroke lineStroke = thinStroke;
    Stroke borderStroke = new BasicStroke(2.0f);

    public BoundedVoronoiStylerDefault() {
        Arrays.fill(this.typeEnabled, true);
    }

    @Override
    public boolean isFeatureTypeEnabled(BoundedVoronoiRenderingType type) {
        if (type == null) {
            return false;
        }
        return this.typeEnabled[type.ordinal()];
    }

    @Override
    public boolean isRenderingEnabled(ThiessenPolygon polygon, BoundedVoronoiRenderingType type) {
        if (polygon == null || type == null) {
            return false;
        }
        return this.typeEnabled[type.ordinal()];
    }

    @Override
    public void initializeRendering(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(this.lineColor);
    }

    @Override
    public void applyStylingForAreaFill(Graphics2D g, ThiessenPolygon polygon) {
        int index = polygon.getVertex().getAuxiliaryIndex() % this.palette.length;
        g.setColor(this.palette[index]);
        g.setStroke(thinStroke);
    }

    @Override
    public void applyStylingForLineDrawing(Graphics2D g, ThiessenPolygon polygon) {
        g.setColor(this.lineColor);
        g.setStroke(this.lineStroke);
    }

    public void setLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null argument not supported");
        }
        this.lineColor = color;
    }

    public void setLineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null argument not supported");
        }
        this.lineStroke = stroke;
    }

    public void setAreaFillColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null argument not supported");
        }
        this.palette = new Color[1];
        this.palette[0] = color;
    }

    public void setAreaFillPalette(Color[] paletteSpecification) {
        if (paletteSpecification == null) {
            throw new IllegalArgumentException("Null argument not supported");
        }
        if (paletteSpecification.length == 0) {
            throw new IllegalArgumentException("Zero-length array not supported");
        }
        this.palette = new Color[paletteSpecification.length];
        System.arraycopy(paletteSpecification, 0, this.palette, 0, paletteSpecification.length);
    }

    public void setVertexColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null argument not supported");
        }
        this.vertexColor = color;
    }

    public void setVertexLabelingFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null argument not supported");
        }
        this.vertexLabelingFont = font;
    }

    public void setVertexLabelingEnabled(boolean enabled) {
        this.vertexLabelingEnabled = enabled;
    }

    public void setVertexSymbolSize(double vertexSymbolSize) {
        if (vertexSymbolSize <= 0.0) {
            throw new IllegalArgumentException("Negative and zero sizes not supported");
        }
        this.vertexSymbolSize = vertexSymbolSize;
    }

    public void setVertexSymbolEnabled(boolean enabled) {
        this.vertexSymbolEnabled = enabled;
        this.typeEnabled[BoundedVoronoiRenderingType.Vertex.ordinal()] = enabled;
    }

    @Override
    public IBoundedVoronoiVertexSymbol getVertexSymbol(ThiessenPolygon polygon) {
        if (this.isRenderingEnabled(polygon, BoundedVoronoiRenderingType.Vertex)) {
            BoundedVoronoiVertexSymbol symbol = new BoundedVoronoiVertexSymbol(this.vertexSymbolSize);
            symbol.setColor(this.vertexColor);
            if (this.vertexLabelingEnabled) {
                symbol.setFont(this.vertexLabelingFont);
                symbol.setLabel(Integer.toString(polygon.getVertex().getIndex()));
            }
            return symbol;
        }
        return null;
    }

    @Override
    public void setAreaFillEnabled(boolean enabled) {
        this.typeEnabled[BoundedVoronoiRenderingType.Area.ordinal()] = enabled;
    }

    public boolean isAreaFillEnabled() {
        return this.typeEnabled[BoundedVoronoiRenderingType.Area.ordinal()];
    }
}

