/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.util.List;
import org.tinfour.common.Vertex;

public class BarycentricCoordinates {
    private double barycentricCoordinateDeviation;

    public double[] getBarycentricCoordinates(List<Vertex> polygon, double x, double y) {
        int nVertices = polygon.size();
        if (nVertices < 3) {
            return null;
        }
        Vertex v0 = polygon.get(nVertices - 1);
        Vertex v1 = polygon.get(0);
        if (v0 == null || v1 == null) {
            return null;
        }
        if (v0.equals(v1)) {
            if (--nVertices < 3) {
                return null;
            }
            v0 = polygon.get(nVertices - 1);
        }
        double[] weights = new double[nVertices];
        double wSum = 0.0;
        double x0 = v0.getX() - x;
        double y0 = v0.getY() - y;
        double x1 = v1.getX() - x;
        double y1 = v1.getY() - y;
        double r0 = Math.sqrt(x0 * x0 + y0 * y0);
        double r1 = Math.sqrt(x1 * x1 + y1 * y1);
        double t1 = (r0 * r1 - (x0 * x1 + y0 * y1)) / (x0 * y1 - x1 * y0);
        for (int iEdge = 0; iEdge < nVertices; ++iEdge) {
            int index = (iEdge + 1) % nVertices;
            v1 = polygon.get(index);
            if (v1 == null) {
                return null;
            }
            double t0 = t1;
            x0 = x1;
            y0 = y1;
            r0 = r1;
            x1 = v1.getX() - x;
            y1 = v1.getY() - y;
            r1 = Math.sqrt(x1 * x1 + y1 * y1);
            t1 = (r0 * r1 - (x0 * x1 + y0 * y1)) / (x0 * y1 - x1 * y0);
            double w = (t0 + t1) / r0;
            wSum += w;
            weights[iEdge] = w;
        }
        for (int i = 0; i < nVertices; ++i) {
            weights[i] = weights[i] / wSum;
        }
        double xSum = 0.0;
        double ySum = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            Vertex v = polygon.get(i);
            xSum += weights[i] * (v.getX() - x);
            ySum += weights[i] * (v.getY() - y);
        }
        this.barycentricCoordinateDeviation = Math.sqrt(xSum * xSum + ySum * ySum);
        return weights;
    }

    public double getBarycentricCoordinateDeviation() {
        return this.barycentricCoordinateDeviation;
    }
}

