/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.standard;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIntegrityCheck;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.common.VertexMergerGroup;

public class IntegrityCheck
implements IIntegrityCheck {
    private final IIncrementalTin tin;
    private final Thresholds thresholds;
    private final GeometricOperations geoOp;
    private final List<IQuadEdge> edges;
    private String message;
    private int nDelaunayViolations;
    private double sumDelaunayViolations;
    private double maxDelaunayViolation;
    private int nDelaunayViolationsConstrained;
    private double sumDelaunayViolationsConstrained;
    private double maxDelaunayViolationConstrained;

    IntegrityCheck(IIncrementalTin tin) {
        this.tin = tin;
        this.thresholds = tin.getThresholds();
        this.geoOp = new GeometricOperations(this.thresholds);
        this.edges = tin.getEdges();
        this.message = null;
    }

    @Override
    public boolean inspect() {
        if (this.edges.isEmpty()) {
            this.message = "TIN was not successfully bootstrapped";
            return false;
        }
        boolean test = this.inspectLinks();
        if (!test) {
            return false;
        }
        test = this.inspectPerimeterLinks();
        if (!test) {
            return false;
        }
        return this.inspectTriangleGeometry();
    }

    public boolean inspectLinks() {
        for (IQuadEdge e : this.edges) {
            IQuadEdge s;
            if (e == (s = e.getForward())) {
                this.message = "Edge has forward reference to itself " + e;
                return false;
            }
            if (s == null) {
                this.message = "Edge has no forward reference " + e;
                return false;
            }
            s = s.getForward();
            if ((s = s.getForward()) != e) {
                this.message = "Incomplete forward circuit starting with edge " + e;
                return false;
            }
            s = e.getReverse();
            if (e == s) {
                this.message = "Edge has reverse reference to itself " + e;
                return false;
            }
            s = s.getReverse();
            if ((s = s.getReverse()) != e) {
                this.message = "Incomplete reverse circuit starting with edge " + e;
                return false;
            }
            IQuadEdge dual = e.getDual();
            if (dual == e) {
                this.message = "Edge has dual reference to itself " + dual;
                return false;
            }
            if (dual.getDual() != e) {
                this.message = "Dual is not reflective for edge " + dual;
                return false;
            }
            s = dual.getForward();
            if (dual == s) {
                this.message = "Edge has forward reference to itself " + dual;
                return false;
            }
            s = s.getForward();
            if ((s = s.getForward()) != dual) {
                this.message = "Incomplete forward circuit starting with edge " + dual;
                return false;
            }
            s = dual.getReverse();
            if (dual == s) {
                this.message = "Edge has reverse reference to itself " + dual;
                return false;
            }
            s = s.getReverse();
            if ((s = s.getReverse()) == dual) continue;
            this.message = "Incomplete reverse circuit starting with edge " + dual;
            return false;
        }
        return true;
    }

    public boolean inspectPerimeterLinks() {
        IQuadEdge s0;
        if (this.edges.isEmpty()) {
            this.message = "TIN was not successfully bootstrapped";
            return false;
        }
        int nGhostEdges = 0;
        IQuadEdge p = null;
        for (IQuadEdge e : this.edges) {
            if (e.getB() == null) {
                p = e;
                ++nGhostEdges;
                continue;
            }
            if (e.getA() != null) continue;
            this.message = "Edge starts with null vertex " + e;
            return false;
        }
        IQuadEdge s = p.getDual();
        s = s0 = s.getForward();
        int n = 0;
        do {
            if (++n > this.edges.size()) {
                this.message = "Infinite loop building perimeter ";
                return false;
            }
            s = s.getForward();
            s = s.getDual();
        } while ((s = s.getForward()) != s0);
        if (n != nGhostEdges) {
            this.message = "Perimeter edge count," + n + ", does not match number of ghost edges, " + nGhostEdges;
            return false;
        }
        List<IQuadEdge> pList = this.tin.getPerimeter();
        double aSum = 0.0;
        for (IQuadEdge e : pList) {
            double x0 = e.getA().getX();
            double y0 = e.getA().getY();
            double x1 = e.getB().getX();
            double y1 = e.getB().getY();
            aSum += x0 * y1 - x1 * y0;
        }
        if ((aSum /= 2.0) <= 0.0) {
            this.message = "Negative perimeter area " + aSum;
            return false;
        }
        return true;
    }

    public boolean inspectTriangleGeometry() {
        for (IQuadEdge e : this.edges) {
            if (e.getA() == null || e.getB() == null) continue;
            if (e.getForward().getB() != null && !this.checkAreaAndInCircle(e)) {
                return false;
            }
            IQuadEdge d = e.getDual();
            if (d.getForward().getB() == null || this.checkAreaAndInCircle(d)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAreaAndInCircle(IQuadEdge e) {
        Vertex c;
        Vertex b;
        Vertex a = e.getA();
        double area = this.geoOp.area(a, b = e.getB(), c = e.getForward().getB());
        if (area < 0.0) {
            this.message = "Triangle with negative area " + area + ", vertices: " + a.getIndex() + ", " + b.getIndex() + ", " + c.getIndex() + " starting at edge " + e;
            return false;
        }
        if (area == 0.0) {
            this.message = "Triangle with zero area  " + area + " starting at edge " + e + ", vertices: " + a.getIndex() + ", " + b.getIndex() + ", " + c.getIndex();
            this.geoOp.area(a, b, c);
            return false;
        }
        Vertex d = e.getDual().getForward().getB();
        if (d == null) {
            return true;
        }
        if (!e.getBaseReference().equals(e)) {
            return true;
        }
        double h = this.geoOp.inCircle(a, b, c, d);
        if (h > 0.0) {
            if (e.isConstrained()) {
                if (h > this.thresholds.getDelaunayThreshold()) {
                    ++this.nDelaunayViolationsConstrained;
                    this.sumDelaunayViolationsConstrained += h;
                    if (h > this.maxDelaunayViolationConstrained) {
                        this.maxDelaunayViolationConstrained = h;
                    }
                }
            } else {
                ++this.nDelaunayViolations;
                this.sumDelaunayViolations += h;
                if (h > this.maxDelaunayViolation) {
                    this.maxDelaunayViolation = h;
                }
                if (h > this.thresholds.getDelaunayThreshold()) {
                    this.message = "InCircle failure h=" + h + ", starting at edge " + e + ": (" + a.getIndex() + ", " + b.getIndex() + ", " + c.getIndex() + ", " + d.getIndex() + ")";
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            return "No Error Detected";
        }
        return this.message;
    }

    public boolean isCheckOkay() {
        return this.message == null;
    }

    @Override
    public void printSummary(PrintStream ps) {
        Formatter fmt = new Formatter(ps);
        fmt.format("Integrity Check Results:%n   %s%n", this.getMessage());
        if (this.nDelaunayViolations == 0) {
            fmt.format("   No Delaunay violations detected%n", new Object[0]);
        } else {
            fmt.format("   Detected acceptable Delaunay violations within tolerance: %8.4e%n", this.thresholds.getDelaunayThreshold());
            fmt.format("      N Violations:  %8d%n", this.nDelaunayViolations);
            fmt.format("      Avg Violation: %8.4e%n", this.sumDelaunayViolations / (double)this.nDelaunayViolations);
            fmt.format("      Max Violation: %8.4e%n", this.maxDelaunayViolation);
        }
        if (this.nDelaunayViolationsConstrained > 0) {
            fmt.format("   Counted %d violations at constrained edges%n", this.nDelaunayViolationsConstrained);
            fmt.format("      Avg Violation: %8.4e%n", this.sumDelaunayViolationsConstrained / (double)this.nDelaunayViolationsConstrained);
            fmt.format("      Max Violation: %8.4e%n", this.maxDelaunayViolationConstrained);
        }
        fmt.flush();
    }

    @Override
    public boolean testGetVerticesAgainstInputList(List<Vertex> inputList) {
        if (!this.tin.getConstraints().isEmpty()) {
            this.message = "Cannot compare input list after constraints are added";
            return false;
        }
        ArrayList<Vertex> inList = new ArrayList<Vertex>(inputList.size());
        inList.addAll(inputList);
        List<Vertex> outputList = this.tin.getVertices();
        ArrayList<Vertex> outList = new ArrayList<Vertex>(inputList.size());
        for (Vertex v : outputList) {
            if (v instanceof VertexMergerGroup) {
                Vertex[] s;
                VertexMergerGroup group = (VertexMergerGroup)v;
                for (Vertex sv : s = group.getVertices()) {
                    outList.add(sv);
                }
                continue;
            }
            outList.add(v);
        }
        Comparator<Vertex> vComp = new Comparator<Vertex>(){

            @Override
            public int compare(Vertex t, Vertex t1) {
                return Integer.compare(t.getIndex(), t1.getIndex());
            }
        };
        inList.sort(vComp);
        outList.sort(vComp);
        int n = inList.size();
        if (outList.size() < n) {
            n = outList.size();
        }
        for (int i = 0; i < n; ++i) {
            Vertex vIn = (Vertex)inList.get(i);
            Vertex vOut = (Vertex)outList.get(i);
            if (vIn.getIndex() == vOut.getIndex()) continue;
            this.message = "Vertex mismatch at index " + vIn.getIndex() + ", " + vOut.getIndex();
            return false;
        }
        if (inList.size() != outList.size()) {
            this.message = "Vertex list sizes not equal " + inList.size() + ", " + outList.size();
            return false;
        }
        return true;
    }

    @Override
    public int getConstrainedViolationCount() {
        return this.nDelaunayViolationsConstrained;
    }

    @Override
    public double getConstrainedViolationMaximum() {
        return this.maxDelaunayViolationConstrained;
    }

    @Override
    public double getContrainedViolationAverage() {
        if (this.nDelaunayViolationsConstrained == 0) {
            return 0.0;
        }
        return this.sumDelaunayViolationsConstrained / (double)this.nDelaunayViolationsConstrained;
    }
}

