/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.standard;

import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.NearestEdgeResult;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;
import org.tinfour.edge.QuadEdge;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.standard.StochasticLawsonsWalk;

class IncrementalTinNavigator
implements IIncrementalTinNavigator {
    QuadEdge neighborEdge;
    final StochasticLawsonsWalk walker;
    final IncrementalTin tin;

    IncrementalTinNavigator(IncrementalTin tin) {
        this.tin = tin;
        this.walker = new StochasticLawsonsWalk(tin.getThresholds());
    }

    @Override
    public IQuadEdge getNeighborEdge(double x, double y) {
        if (!this.tin.isBootstrapped()) {
            return null;
        }
        if (this.neighborEdge == null) {
            this.neighborEdge = this.tin.getStartingEdge();
        }
        this.neighborEdge = this.walker.findAnEdgeFromEnclosingTriangle(this.neighborEdge, x, y);
        return this.neighborEdge;
    }

    @Override
    public NearestEdgeResult getNearestEdge(double x, double y) {
        IQuadEdge a = this.getNeighborEdge(x, y);
        return this.getNearestEdge(a, x, y);
    }

    private double edgeDistance(Vertex A, Vertex B, double x, double y) {
        double vM;
        double vY;
        double dX = x - A.getX();
        double dY = y - A.getY();
        double vX = B.getX() - A.getX();
        double t = (dX * vX + dY * (vY = B.getY() - A.getY())) / (vM = Math.sqrt(vX * vX + vY * vY));
        if (t < 0.0) {
            return Math.sqrt(dX * dX + dY * dY);
        }
        if (t > vM) {
            double bX = x - B.getX();
            double bY = y - B.getY();
            return Math.sqrt(bX * bX + bY * bY);
        }
        double pX = -vY;
        double pY = vX;
        return Math.abs(dX * pX + dY * pY) / vM;
    }

    public NearestEdgeResult getNearestEdge(IQuadEdge a, double x, double y) {
        if (a == null) {
            return null;
        }
        IQuadEdge b = a.getForward();
        IQuadEdge c = a.getReverse();
        Vertex A = a.getA();
        Vertex B = b.getA();
        Vertex C = c.getA();
        double pMin = this.edgeDistance(A, B, x, y);
        IQuadEdge e = a;
        if (C == null) {
            return new NearestEdgeResult(e, pMin, x, y, false);
        }
        double test = this.edgeDistance(B, C, x, y);
        if (test < pMin) {
            pMin = test;
            e = b;
        }
        if ((test = this.edgeDistance(C, A, x, y)) < pMin) {
            pMin = test;
            e = c;
        }
        return new NearestEdgeResult(e, pMin, x, y, true);
    }

    @Override
    public Vertex getNearestVertex(double x, double y) {
        NearestEdgeResult n = this.getNearestEdge(x, y);
        if (n == null) {
            return null;
        }
        return n.getNearestVertex();
    }

    @Override
    public SimpleTriangle getContainingTriangle(double x, double y) {
        IQuadEdge a = this.getNeighborEdge(x, y);
        if (a == null) {
            return null;
        }
        IQuadEdge b = a.getForward();
        IQuadEdge c = a.getReverse();
        return new SimpleTriangle(this.tin, a, b, c);
    }

    @Override
    public boolean isPointInsideTin(double x, double y) {
        IQuadEdge e = this.getNeighborEdge(x, y);
        if (e == null) {
            return false;
        }
        return e.getForward().getB() != null;
    }

    @Override
    public void resetForChangeToTin() {
        this.neighborEdge = null;
        this.walker.reset();
    }
}

