/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.semivirtual;

import org.tinfour.common.GeometricOperations;
import org.tinfour.common.Vertex;
import org.tinfour.semivirtual.SemiVirtualEdge;

class SemiVirtualDevillersEar {
    int index;
    SemiVirtualDevillersEar prior;
    SemiVirtualDevillersEar next;
    SemiVirtualEdge c;
    SemiVirtualEdge p;
    SemiVirtualEdge n;
    Vertex v0;
    Vertex v1;
    Vertex v2;
    boolean degenerate;
    double score;

    SemiVirtualDevillersEar(int index, SemiVirtualDevillersEar priorEar, SemiVirtualEdge current, SemiVirtualEdge prior) {
        this.index = index;
        this.prior = priorEar;
        if (priorEar != null) {
            priorEar.next = this;
        }
        this.c = current;
        this.n = this.c.getForward();
        this.p = prior;
        this.v0 = this.c.getA();
        this.v1 = this.c.getB();
        this.v2 = this.n.getB();
    }

    void setReferences(SemiVirtualDevillersEar priorEar, SemiVirtualEdge current, SemiVirtualEdge prior) {
        this.prior = priorEar;
        if (priorEar != null) {
            priorEar.next = this;
        }
        this.c = current;
        this.n = this.c.getForward();
        this.p = prior;
        this.v0 = this.c.getA();
        this.v1 = this.c.getB();
        this.v2 = this.n.getB();
    }

    void computeScore(GeometricOperations geoOp, Vertex vRemove) {
        this.degenerate = false;
        if (this.v0 == null || this.v1 == null || this.v2 == null) {
            this.score = Double.POSITIVE_INFINITY;
            return;
        }
        double ax = this.v0.x;
        double ay = this.v0.y;
        double bx = this.v1.x;
        double by = this.v1.y;
        double cx = this.v2.x;
        double cy = this.v2.y;
        double orientation = geoOp.orientation(ax, ay, bx, by, cx, cy);
        if (orientation <= 0.0) {
            this.degenerate = true;
            this.score = Double.POSITIVE_INFINITY;
            return;
        }
        double dx = vRemove.x;
        double dy = vRemove.y;
        double inCircle = geoOp.inCircle(ax, ay, bx, by, cx, cy, dx, dy);
        this.score = inCircle / orientation;
    }

    void dispose() {
        this.index = -1;
        this.v0 = null;
        this.v1 = null;
        this.v2 = null;
        this.c = null;
        this.p = null;
        this.n = null;
        this.prior = null;
        this.next = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(48);
        sb.append("ear v[]=");
        sb.append((String)(this.v0 == null ? "null," : this.v0.getIndex() + ","));
        sb.append((String)(this.v1 == null ? "null," : this.v1.getIndex() + ","));
        sb.append((String)(this.v2 == null ? "null," : this.v2.getIndex() + " "));
        sb.append("     ");
        sb.append("index=").append(Integer.toString(this.index));
        sb.append(",  score=");
        sb.append(Double.toString(this.score));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof SemiVirtualDevillersEar) {
            return o == this;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.index;
        return hash;
    }
}

