/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import java.util.List;
import org.tinfour.contour.Contour;
import org.tinfour.contour.ContourBuilderForTin;
import org.tinfour.contour.ContourRegion;
import org.tinfour.contour.ContourRegionMember;

public class ContourIntegrityCheck {
    private final ContourBuilderForTin builder;
    String message = "No inspection was performed";

    public ContourIntegrityCheck(ContourBuilderForTin builder) {
        if (builder == null) {
            throw new IllegalArgumentException("A null reference for the builder is not supported");
        }
        this.builder = builder;
    }

    public boolean inspect() {
        List<ContourRegion> regions = this.builder.getRegions();
        if (!regions.isEmpty()) {
            if (!this.checkRegionAreas(regions)) {
                return false;
            }
            if (!this.checkContourTraversal(regions)) {
                return false;
            }
        }
        this.message = "Inspection passed";
        return true;
    }

    public String getMessage() {
        return this.message;
    }

    private boolean checkRegionAreas(List<ContourRegion> regions) {
        double[] xy = this.builder.getEnvelope();
        double envelopeArea = 0.0;
        double xOffset = xy[0];
        double yOffset = xy[1];
        double x0 = 0.0;
        double y0 = 0.0;
        for (int i = 2; i < xy.length - 2; i += 2) {
            double x1 = xy[i] - xOffset;
            double y1 = xy[i + 1] - yOffset;
            envelopeArea += x0 * y1 - x1 * y0;
            x0 = x1;
            y0 = y1;
        }
        envelopeArea /= 2.0;
        double aSum = 0.0;
        double adjustedSum = 0.0;
        for (ContourRegion r : regions) {
            ContourRegion.ContourRegionType rt = r.getContourRegionType();
            if (rt == ContourRegion.ContourRegionType.Perimeter) {
                aSum += r.getArea();
            }
            adjustedSum += r.getAdjustedArea();
        }
        double areaDiff = aSum - envelopeArea;
        if (Math.abs(areaDiff) > envelopeArea * 1.0E-6) {
            this.message = "The area of the primary contour regions does not match the area of the enclosing envelope";
            return false;
        }
        areaDiff = adjustedSum - envelopeArea;
        if (Math.abs(areaDiff) > envelopeArea * 1.0E-6) {
            this.message = "The sum of the adjusted areas for all contour regions does not match the area of the enclosing envelope";
            return false;
        }
        return true;
    }

    private boolean checkContourTraversal(List<ContourRegion> regions) {
        for (ContourRegion r : regions) {
            ContourRegion.ContourRegionType rt = r.getContourRegionType();
            if (rt != ContourRegion.ContourRegionType.Perimeter) continue;
            for (ContourRegionMember member : r.memberList) {
                Contour contour = member.contour;
                if (contour.getContourType() != Contour.ContourType.Interior || contour.traversedBackward || !contour.traversedForward) continue;
                this.message = "Interior contour not traversed in both directions, contour ID " + contour.getContourId();
                return false;
            }
        }
        return true;
    }
}

