/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.graalvm;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import org.h2.value.ValueGeometry;
import org.h2gis.graalvm.ColumnWrapper;

public class ResultSetWrapper {
    private final List<ColumnWrapper> columns = new ArrayList<ColumnWrapper>();
    private int rowCount = 0;

    public List<ColumnWrapper> getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void addColumn(ColumnWrapper column) {
        this.columns.add(column);
    }

    public void addColumn(String name, int type, String typeName) {
        this.columns.add(new ColumnWrapper(name, type, typeName));
    }

    public ColumnWrapper getColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            return null;
        }
        return this.columns.get(columnIndex);
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public static ResultSetWrapper from(ResultSet rs) {
        try {
            ResultSetWrapper wrapper = new ResultSetWrapper();
            ResultSetMetaData rsm = rs.getMetaData();
            int colCount = rsm.getColumnCount();
            ResultSetWrapper.createColumns(wrapper, rsm, colCount);
            int rowCounter = 0;
            while (rs.next()) {
                for (int i = 1; i <= colCount; ++i) {
                    if (wrapper.columns.get(i - 1).getTypeName().startsWith("geometry")) {
                        Object obj = rs.getObject(i);
                        wrapper.columns.get(i - 1).addValue(ValueGeometry.getFromGeometry((Object)obj).getBytes());
                        continue;
                    }
                    wrapper.columns.get(i - 1).addValue(rs.getObject(i));
                }
                ++rowCounter;
            }
            wrapper.setRowCount(rowCounter);
            return wrapper;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createColumns(ResultSetWrapper wrapper, ResultSetMetaData rsm, int colCount) throws Exception {
        for (int i = 1; i <= colCount; ++i) {
            ColumnWrapper column = new ColumnWrapper(rsm.getColumnLabel(i), rsm.getColumnType(i), rsm.getColumnTypeName(i).toLowerCase());
            wrapper.addColumn(column);
        }
    }

    public static ResultSetWrapper fromOne(ResultSet rs) {
        try {
            ResultSetWrapper wrapper = new ResultSetWrapper();
            ResultSetMetaData rsm = rs.getMetaData();
            int colCount = rsm.getColumnCount();
            ResultSetWrapper.createColumns(wrapper, rsm, colCount);
            int rowCounter = 0;
            if (rs.next()) {
                for (int i = 1; i <= colCount; ++i) {
                    wrapper.columns.get(i - 1).addValue(rs.getObject(i));
                }
                ++rowCounter;
            }
            wrapper.setRowCount(rowCounter);
            return wrapper;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() throws Exception {
        int metadataSize = 8 + 8 * this.columns.size();
        ArrayList<byte[]> columnBuffers = new ArrayList<byte[]>();
        for (ColumnWrapper col : this.columns) {
            columnBuffers.add(col.serialize());
        }
        ByteBuffer meta = ByteBuffer.allocate(metadataSize).order(ByteOrder.LITTLE_ENDIAN);
        meta.putInt(this.columns.size());
        meta.putInt(this.rowCount);
        int currentOffset = metadataSize;
        for (byte[] buf : columnBuffers) {
            meta.putLong(currentOffset);
            currentOffset += buf.length;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(meta.array());
        for (byte[] colBuf : columnBuffers) {
            out.write(colBuf);
        }
        return out.toByteArray();
    }
}

