/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.graalvm;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class ColumnWrapper {
    private final String name;
    private final int typeCode;
    private final String typeName;
    private final List<Object> values;

    public ColumnWrapper(String name, int typeCode, String typeName) {
        this.name = name;
        this.typeName = typeName.toLowerCase();
        this.values = new ArrayList<Object>();
        switch (typeCode) {
            case -6: 
            case 4: 
            case 5: {
                this.typeCode = 1;
                break;
            }
            case -5: {
                this.typeCode = 2;
                break;
            }
            case 6: 
            case 7: {
                this.typeCode = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                this.typeCode = 4;
                break;
            }
            case -7: 
            case 16: {
                this.typeCode = 5;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.typeCode = 6;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.typeCode = 7;
                break;
            }
            default: {
                this.typeCode = typeName.startsWith("geometry") ? 8 : 99;
            }
        }
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public void setValueAt(int index, Object value) {
        while (index >= this.values.size()) {
            this.values.add(null);
        }
        this.values.set(index, value);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.typeCode;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteBuffer bb4 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer bb8 = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        byte[] nameBytes = this.name.getBytes(StandardCharsets.UTF_8);
        out.write(bb4.putInt(nameBytes.length).array());
        bb4.clear();
        out.write(nameBytes);
        out.write(bb4.putInt(this.typeCode).array());
        bb4.clear();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        for (Object val : this.values) {
            switch (this.typeCode) {
                case 1: {
                    data.write(bb4.putInt(val == null ? 0 : ((Number)val).intValue()).array());
                    bb4.clear();
                    break;
                }
                case 2: {
                    data.write(bb8.putLong(val == null ? 0L : ((Number)val).longValue()).array());
                    bb8.clear();
                    break;
                }
                case 3: {
                    data.write(bb4.putFloat(val == null ? 0.0f : ((Number)val).floatValue()).array());
                    bb4.clear();
                    break;
                }
                case 4: {
                    data.write(bb8.putDouble(val == null ? 0.0 : ((Number)val).doubleValue()).array());
                    bb8.clear();
                    break;
                }
                case 5: {
                    data.write(val != null && (Boolean)val != false ? 1 : 0);
                    break;
                }
                case 6: 
                case 7: 
                case 99: {
                    byte[] str = val == null ? new byte[]{} : val.toString().getBytes(StandardCharsets.UTF_8);
                    data.write(bb4.putInt(str.length).array());
                    bb4.clear();
                    data.write(str);
                    break;
                }
                case 8: {
                    byte[] geom = val == null ? new byte[]{} : (byte[])val;
                    data.write(bb4.putInt(geom.length).array());
                    bb4.clear();
                    data.write(geom);
                }
            }
        }
        byte[] valuesBytes = data.toByteArray();
        out.write(bb4.putInt(valuesBytes.length).array());
        bb4.clear();
        out.write(valuesBytes);
        return out.toByteArray();
    }
}

