/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.others;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.convert.ST_Holes;
import org.h2gis.functions.spatial.convert.ST_ToMultiLine;
import org.h2gis.functions.spatial.topology.ST_Polygonize;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;

public class ST_Clip
extends DeterministicScalarFunction {
    public ST_Clip() {
        this.addProperty("remarks", "Clip a [Multi]Polygon or [Multi]LineString with [Multi]Polygon or [Multi]LineString geometry.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geomToClip, Geometry geomForClip) throws SQLException, ParseException {
        if (geomToClip == null) {
            return null;
        }
        if (geomToClip.isEmpty()) {
            return geomToClip;
        }
        if (geomForClip == null || geomForClip.isEmpty()) {
            return geomToClip;
        }
        if (geomToClip.getSRID() != geomForClip.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        if (geomToClip instanceof Polygon || geomToClip instanceof MultiPolygon) {
            MultiLineString geomForClipReduced = ST_ToMultiLine.execute(geomForClip);
            if (geomForClipReduced.isEmpty()) {
                throw new SQLException("Only support [Multi]Polygon or [Multi]LineString as input geometry for clipping");
            }
            if (geomToClip.intersects((Geometry)geomForClipReduced)) {
                GeometryFactory factory = geomToClip.getFactory();
                Geometry geomNoded = factory.createGeometryCollection(new Geometry[]{ST_ToMultiLine.execute(geomToClip), geomForClipReduced}).union();
                Geometry pols = ST_Polygonize.execute(geomNoded);
                Geometry holes = OverlayNGRobust.overlay((Geometry)ST_Holes.execute(geomToClip), (Geometry)ST_Holes.execute(geomForClip), (int)2);
                ArrayList<Geometry> selected = new ArrayList<Geometry>();
                int nb = pols.getNumGeometries();
                PreparedGeometry pg_holes = new PreparedGeometryFactory().create(holes);
                PreparedGeometry pg_geomToClip = new PreparedGeometryFactory().create(geomToClip);
                for (int i = 0; i < nb; ++i) {
                    Geometry g = pols.getGeometryN(i);
                    Point pt = g.getInteriorPoint();
                    if (pg_holes.intersects((Geometry)pt) || !pg_geomToClip.intersects((Geometry)pt)) continue;
                    selected.add(g);
                }
                Geometry geom = factory.buildGeometry(selected);
                geom.setSRID(geomToClip.getSRID());
                return geom;
            }
        } else if (geomToClip instanceof LineString || geomToClip instanceof MultiLineString) {
            MultiLineString geomForClipReduced = ST_ToMultiLine.execute(geomForClip);
            if (geomForClipReduced.isEmpty()) {
                throw new SQLException("Only support [Multi]Polygon or [Multi]LineString as input geometry for clipping");
            }
            if (geomToClip.intersects((Geometry)geomForClipReduced)) {
                GeometryFactory factory = geomToClip.getFactory();
                MultiLineString geom = ST_ToMultiLine.execute((Geometry)factory.createGeometryCollection(new Geometry[]{OverlayNGRobust.overlay((Geometry)geomToClip, (Geometry)geomForClipReduced, (int)1), OverlayNGRobust.overlay((Geometry)geomToClip, (Geometry)geomForClipReduced, (int)3)}));
                geom.setSRID(geomToClip.getSRID());
                return geom;
            }
        } else {
            throw new SQLException("Only support [Multi]Polygon or [Multi]LineString as input geometry to clip");
        }
        return geomToClip;
    }
}

