/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.mesh;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.mesh.DelaunayData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;

public class ST_ConstrainedDelaunay
extends DeterministicScalarFunction {
    public ST_ConstrainedDelaunay() {
        this.addProperty("remarks", "Returns polygons that represent a Constrained Delaunay Triangulation from a geometry.\nOutput is a COLLECTION of polygons, for flag=0 (default flag) or a MULTILINESTRING for flag=1.\nIf the input geometry does not contain any lines or polygons, a delaunay triangulation will be computed. The minPointSpacing is the merge distance between provided points, by default this value is 1e-12\n");
    }

    public String getJavaStaticMethod() {
        return "createCDT";
    }

    public static GeometryCollection createCDT(Geometry geometry) throws SQLException {
        return ST_ConstrainedDelaunay.createCDT(geometry, 0);
    }

    public static GeometryCollection createCDT(Geometry geometry, int flag) throws SQLException {
        return ST_ConstrainedDelaunay.createCDT(geometry, flag, DelaunayData.DEFAULT_EPSILON);
    }

    public static GeometryCollection createCDT(Geometry geometry, int flag, double minPointSpacing) throws SQLException {
        if (geometry != null) {
            DelaunayData delaunayData = new DelaunayData();
            delaunayData.setEpsilon(Math.max(0.0, minPointSpacing));
            delaunayData.put(OverlayNGRobust.union((Geometry)geometry), DelaunayData.MODE.CONSTRAINED);
            delaunayData.triangulate();
            if (flag == 0) {
                return delaunayData.getTrianglesAsMultiPolygon();
            }
            if (flag == 1) {
                return delaunayData.getTrianglesSides();
            }
            throw new SQLException("Only flag 0 or 1 is supported.");
        }
        return null;
    }
}

