/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.mesh;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.h2gis.functions.spatial.mesh.Triangle;
import org.h2gis.utilities.GeometryMetaData;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.utils.TriangleCollector;

public class DelaunayData {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelaunayData.class);
    private GeometryFactory gf;
    private boolean isInput2D;
    public static double DEFAULT_EPSILON = 1.0E-12;
    private double epsilon = DEFAULT_EPSILON;
    Quadtree ptsIndex = new Quadtree();
    List<IConstraint> constraints = new ArrayList<IConstraint>();
    List<Integer> constraintIndex = new ArrayList<Integer>();
    private List<Coordinate> vertices = new ArrayList<Coordinate>();
    private List<Triangle> triangles = new ArrayList<Triangle>();
    private MODE mode = MODE.DELAUNAY;

    public void put(Geometry geom, MODE mode) throws IllegalArgumentException {
        this.mode = mode;
        this.gf = geom.getFactory();
        if (mode == MODE.TESSELLATION && !(geom instanceof Polygon) && !(geom instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Only Polygon(s) are accepted for tessellation");
        }
        int dim = GeometryMetaData.getMetaData((Geometry)geom).dimension;
        this.isInput2D = dim == 2;
        this.addGeometry(geom, 1);
    }

    private Vertex addCoordinate(Coordinate coordinate, int index) {
        Envelope env = new Envelope(coordinate);
        env.expandBy(this.epsilon);
        List result = this.ptsIndex.query(env);
        Vertex found = null;
        for (Object vertex : result) {
            if (!(vertex instanceof Vertex) || !(((Vertex)vertex).getDistance(coordinate.x, coordinate.y) < this.epsilon)) continue;
            found = (Vertex)vertex;
            break;
        }
        if (found == null) {
            found = new Vertex(coordinate.x, coordinate.y, Double.isNaN(coordinate.z) ? 0.0 : coordinate.z, index);
            this.ptsIndex.insert(new Envelope(coordinate), (Object)found);
        }
        return found;
    }

    public void addPolygon(Polygon newPoly, int attribute) {
        Coordinate[] coordinates = newPoly.getExteriorRing().getCoordinates();
        if (!Orientation.isCCW((Coordinate[])coordinates)) {
            CoordinateArrays.reverse((Coordinate[])coordinates);
        }
        if (coordinates.length >= 4) {
            this.fillVerticesList(attribute, coordinates);
        }
        int holeCount = newPoly.getNumInteriorRing();
        for (int holeIndex = 0; holeIndex < holeCount; ++holeIndex) {
            LinearRing holeLine = newPoly.getInteriorRingN(holeIndex);
            Coordinate[] hCoordinates = holeLine.getCoordinates();
            if (Orientation.isCCW((Coordinate[])hCoordinates)) {
                CoordinateArrays.reverse((Coordinate[])hCoordinates);
            }
            this.fillVerticesList(attribute, hCoordinates);
        }
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    private void fillVerticesList(int attribute, Coordinate[] hCoordinates) {
        if (hCoordinates.length > 1 && hCoordinates[0].equals2D(hCoordinates[hCoordinates.length - 1])) {
            ArrayList<Vertex> vertexList = new ArrayList<Vertex>(hCoordinates.length - 1);
            for (int vId = 0; vId < hCoordinates.length - 1; ++vId) {
                vertexList.add(this.addCoordinate(hCoordinates[vId], attribute));
            }
            PolygonConstraint polygonConstraint = new PolygonConstraint(vertexList);
            polygonConstraint.complete();
            if (polygonConstraint.isValid()) {
                this.constraints.add((IConstraint)polygonConstraint);
                this.constraintIndex.add(attribute);
            }
        } else {
            ArrayList<Vertex> vertexList = new ArrayList<Vertex>(hCoordinates.length);
            for (Coordinate hCoordinate : hCoordinates) {
                vertexList.add(this.addCoordinate(hCoordinate, attribute));
            }
            LinearConstraint linearConstraint = new LinearConstraint(vertexList);
            linearConstraint.complete();
            if (linearConstraint.isValid()) {
                this.constraints.add((IConstraint)linearConstraint);
                this.constraintIndex.add(attribute);
            }
        }
    }

    private void addLineString(LineString geom, int attribute) {
        this.fillVerticesList(attribute, geom.getCoordinates());
    }

    private void addGeometry(Geometry geom, int attribute) {
        if (geom instanceof GeometryCollection) {
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry subGeom = geom.getGeometryN(j);
                this.addGeometry(subGeom, attribute);
            }
        } else if (geom instanceof Polygon && !geom.isEmpty()) {
            this.addPolygon((Polygon)geom, attribute);
        } else if (geom instanceof LineString && !geom.isEmpty()) {
            this.addLineString((LineString)geom, attribute);
        } else if (geom instanceof Point) {
            this.addCoordinate(geom.getCoordinate(), attribute);
        }
    }

    private List<SimpleTriangle> computeTriangles(IncrementalTin incrementalTin) {
        ArrayList<SimpleTriangle> triangles = new ArrayList<SimpleTriangle>(incrementalTin.countTriangles().getCount());
        Triangle.TriangleBuilder triangleBuilder = new Triangle.TriangleBuilder(triangles);
        TriangleCollector.visitSimpleTriangles((IIncrementalTin)incrementalTin, (Consumer)triangleBuilder);
        return triangles;
    }

    private static Coordinate toCoordinate(Vertex v, boolean isInput2D) {
        if (isInput2D) {
            return new Coordinate(v.getX(), v.getY());
        }
        return new Coordinate(v.getX(), v.getY(), v.getZ());
    }

    public void triangulate() {
        this.triangles.clear();
        this.vertices.clear();
        List meshPoints = this.ptsIndex.queryAll();
        List<Object> simpleTriangles = new ArrayList();
        IncrementalTin tin = new IncrementalTin(this.epsilon);
        tin.add(meshPoints, null);
        tin.addConstraints(this.constraints, false);
        simpleTriangles = this.computeTriangles(tin);
        List verts = tin.getVertices();
        this.vertices = new ArrayList<Coordinate>(verts.size());
        HashMap<Vertex, Integer> vertIndex = new HashMap<Vertex, Integer>();
        for (Vertex vertex : verts) {
            vertIndex.put(vertex, this.vertices.size());
            this.vertices.add(DelaunayData.toCoordinate(vertex, this.isInput2D));
        }
        for (SimpleTriangle simpleTriangle : simpleTriangles) {
            int triangleAttribute = 0;
            if (simpleTriangle.getContainingRegion() != null && simpleTriangle.getContainingRegion().getConstraintIndex() < this.constraintIndex.size()) {
                triangleAttribute = this.constraintIndex.get(simpleTriangle.getContainingRegion().getConstraintIndex());
            }
            if (this.mode == MODE.TESSELLATION && triangleAttribute != true) continue;
            this.triangles.add(new Triangle((Integer)vertIndex.get(simpleTriangle.getVertexA()), (Integer)vertIndex.get(simpleTriangle.getVertexB()), (Integer)vertIndex.get(simpleTriangle.getVertexC()), triangleAttribute));
        }
    }

    public MultiPolygon getTrianglesAsMultiPolygon() {
        if (!this.triangles.isEmpty()) {
            Polygon[] polygons = new Polygon[this.triangles.size()];
            for (int idTriangle = 0; idTriangle < polygons.length; ++idTriangle) {
                Triangle triangle = this.triangles.get(idTriangle);
                polygons[idTriangle] = this.gf.createPolygon(new Coordinate[]{this.vertices.get(triangle.getA()), this.vertices.get(triangle.getB()), this.vertices.get(triangle.getC()), this.vertices.get(triangle.getA())});
            }
            return this.gf.createMultiPolygon(polygons);
        }
        return this.gf.createMultiPolygon(new Polygon[0]);
    }

    public double get3DArea() {
        double cumulatedArea = 0.0;
        for (Triangle triangle : this.triangles) {
            cumulatedArea += DelaunayData.computeTriangleArea3D(this.vertices.get(triangle.getA()), this.vertices.get(triangle.getB()), this.vertices.get(triangle.getC()));
        }
        return cumulatedArea;
    }

    public static double computeTriangleArea3D(Coordinate p1, Coordinate p2, Coordinate p3) {
        double vz;
        double ux = p2.getX() - p1.getX();
        double uy = p2.getY() - p1.getY();
        double uz = Double.isNaN(p1.z) || Double.isNaN(p2.z) ? 0.0 : p2.getZ() - p1.getZ();
        double vx = p3.getX() - p1.getX();
        double vy = p3.getY() - p1.getY();
        double d = vz = Double.isNaN(p1.z) || Double.isNaN(p3.z) ? 0.0 : p3.getZ() - p1.getZ();
        if (Double.isNaN(uz) || Double.isNaN(vz)) {
            uz = 1.0;
            vz = 1.0;
        }
        double crossx = uy * vz - uz * vy;
        double crossy = uz * vx - ux * vz;
        double crossz = ux * vy - uy * vx;
        double absSq = crossx * crossx + crossy * crossy + crossz * crossz;
        return Math.sqrt(absSq) / 2.0;
    }

    private void addSegment(Set<LineSegment> segmentHashMap, Coordinate a, Coordinate b) {
        LineSegment lineSegment = new LineSegment(a, b);
        lineSegment.normalize();
        segmentHashMap.add(lineSegment);
    }

    public MultiLineString getTrianglesSides() {
        HashSet<LineSegment> segmentHashMap = new HashSet<LineSegment>(this.triangles.size());
        for (Triangle triangle : this.triangles) {
            this.addSegment(segmentHashMap, this.vertices.get(triangle.getA()), this.vertices.get(triangle.getB()));
            this.addSegment(segmentHashMap, this.vertices.get(triangle.getB()), this.vertices.get(triangle.getC()));
            this.addSegment(segmentHashMap, this.vertices.get(triangle.getC()), this.vertices.get(triangle.getA()));
        }
        LineString[] lineStrings = new LineString[segmentHashMap.size()];
        int i = 0;
        for (LineSegment lineSegment : segmentHashMap) {
            lineStrings[i++] = lineSegment.toGeometry(this.gf);
        }
        return this.gf.createMultiLineString(lineStrings);
    }

    public static enum MODE {
        DELAUNAY,
        CONSTRAINED,
        TESSELLATION;

    }
}

