/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.generalize;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.simplify.VWSimplifier;

public class ST_SimplifyVW
extends DeterministicScalarFunction {
    public ST_SimplifyVW() {
        this.addProperty("remarks", "Returns a simplified version of the given geometry using the Visvalingam-Whyatt algorithm.");
    }

    public String getJavaStaticMethod() {
        return "simplifyvw";
    }

    public static Geometry simplifyvw(Geometry geom, double distanceTolerance) throws SQLException {
        if (geom == null) {
            return null;
        }
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Area must be non-negative");
        }
        VWSimplifier simp = new VWSimplifier(geom);
        simp.setDistanceTolerance(Math.sqrt(distanceTolerance));
        return simp.getResultGeometry();
    }
}

