/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

public class ST_CollectionExtract
extends DeterministicScalarFunction {
    public ST_CollectionExtract() {
        this.addProperty("remarks", "Given a (multi)geometry, returns a (multi)geometry consisting only of elements of the specified dimension.\nDimension numbers are 1 == POINT, 2 == LINESTRING, 3 == POLYGON");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Geometry execute(Geometry geometry, int dimension1, int dimension2) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (dimension1 < 1 || dimension1 > 3 && dimension2 < 1 || dimension2 > 3) {
            throw new IllegalArgumentException("Dimension out of range (1..3)");
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        ST_CollectionExtract.getGeometryByDimensions(geometries, geometry, dimension1, dimension2);
        return geometry.getFactory().buildGeometry(geometries);
    }

    public static Geometry execute(Geometry geometry, int dimension) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (dimension < 1 || dimension > 3) {
            throw new IllegalArgumentException("Dimension out of range (1..3)");
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        ST_CollectionExtract.getGeometryByDimensions(geometries, geometry, dimension, dimension);
        return geometry.getFactory().buildGeometry(geometries);
    }

    private static void getGeometryByDimensions(ArrayList<Geometry> geometries, Geometry geometry, int dimension1, int dimension2) {
        int size = geometry.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            Geometry subGeom = geometry.getGeometryN(i);
            int dim = subGeom.getDimension() + 1;
            if (subGeom instanceof GeometryCollection) {
                ST_CollectionExtract.getGeometryByDimensions(geometries, subGeom, dimension1, dimension2);
                continue;
            }
            if (dim != dimension1 && dim != dimension2) continue;
            geometries.add(subGeom);
        }
    }
}

