/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;

public class ST_AddPoint
extends DeterministicScalarFunction {
    public static final double PRECISION = 1.0E-5;

    public ST_AddPoint() {
        this.addProperty("remarks", "Adds a point to a geometry. \nAn index to set the position of the point (0-based index).");
    }

    public String getJavaStaticMethod() {
        return "addPoint";
    }

    public static Geometry addPoint(Geometry geometry, Point point) throws SQLException {
        if (geometry == null || point == null) {
            return null;
        }
        if (point.isEmpty()) {
            return geometry;
        }
        if (geometry.isEmpty()) {
            return geometry;
        }
        if (geometry.getSRID() != point.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        int position = geometry.getNumPoints() + 1;
        GeometryFactory factory = geometry.getFactory();
        if (geometry instanceof LineString) {
            return ST_AddPoint.insertVertexInLineString((LineString)geometry, point, position, factory);
        }
        throw new SQLException("First argument must be a LINESTRING");
    }

    public static Geometry addPoint(Geometry geometry, Point point, int position) throws SQLException {
        if (geometry == null || point == null) {
            return null;
        }
        if (geometry.isEmpty() || point.isEmpty()) {
            return geometry;
        }
        if (geometry.getSRID() != point.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        if (position < 0) {
            throw new SQLException("Point index must start at 0");
        }
        int numGeom = geometry.getNumPoints();
        if (position > numGeom) {
            throw new SQLException("The point index is out of range (0.." + numGeom + "): found " + position);
        }
        GeometryFactory factory = geometry.getFactory();
        if (geometry instanceof LineString) {
            return ST_AddPoint.insertVertexInLineString((LineString)geometry, point, position, factory);
        }
        throw new SQLException("First argument must be a LINESTRING");
    }

    private static Geometry insertVertexInMultipoint(MultiPoint g, Point vertexPoint, int position, GeometryFactory factory) throws SQLException {
        ArrayList<Point> geoms = new ArrayList<Point>();
        boolean added = false;
        int size = g.getNumGeometries();
        for (int i = 0; i < size; ++i) {
            if (i == position) {
                geoms.add(vertexPoint);
                added = true;
                continue;
            }
            geoms.add((Point)g.getGeometryN(i));
        }
        if (!added) {
            geoms.add(vertexPoint);
        }
        return factory.createMultiPoint(geoms.toArray(new Point[0]));
    }

    private static LineString insertVertexInLineString(LineString lineString, Point vertexPoint, GeometryFactory factory) throws SQLException {
        CoordinateSequence coordSeq = lineString.getCoordinateSequence();
        return factory.createLineString(ST_AddPoint.addCoordinate(coordSeq, vertexPoint.getCoordinate(), coordSeq.size() + 1));
    }

    private static LineString insertVertexInLineString(LineString lineString, Point vertexPoint, int position, GeometryFactory factory) throws SQLException {
        return factory.createLineString(ST_AddPoint.addCoordinate(lineString.getCoordinateSequence(), vertexPoint.getCoordinate(), position));
    }

    public static Coordinate[] addCoordinate(CoordinateSequence coorseq, Coordinate point, int position) {
        if (position <= coorseq.size()) {
            CoordinateXY coord = new CoordinateXY(point);
            if (coorseq.hasZ() && coorseq.hasM()) {
                coord = new CoordinateXYZM(point);
            } else if (coorseq.hasZ()) {
                coord = new Coordinate(point.getX(), point.getY(), Double.isNaN(point.getZ()) ? 0.0 : point.getZ());
            } else if (coorseq.hasM()) {
                coord = new CoordinateXYM(point.getX(), point.getY(), Double.isNaN(point.getM()) ? 0.0 : point.getM());
            }
            Coordinate[] coordinates = coorseq.toCoordinateArray();
            coordinates[position] = coord;
            return coordinates;
        }
        Coordinate[] coordinates = coorseq.toCoordinateArray();
        Coordinate[] destArray = new Coordinate[coordinates.length + 1];
        CoordinateXY coord = new CoordinateXY(point);
        if (coorseq.hasZ() && coorseq.hasM()) {
            coord = new CoordinateXYZM(point);
        } else if (coorseq.hasZ()) {
            coord = new Coordinate(point.getX(), point.getY(), Double.isNaN(point.getZ()) ? 0.0 : point.getZ());
        } else if (coorseq.hasM()) {
            coord = new CoordinateXYM(point);
        }
        CoordinateArrays.copyDeep((Coordinate[])coordinates, (int)0, (Coordinate[])destArray, (int)0, (int)coordinates.length);
        destArray[position - 1] = coord;
        return destArray;
    }
}

