/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.algorithm.construct.LargestEmptyCircle;
import org.locationtech.jts.algorithm.construct.MaximumInscribedCircle;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class ST_MaximumInscribedCircleRadius
extends DeterministicScalarFunction {
    public ST_MaximumInscribedCircleRadius() {
        this.addProperty("remarks", "Compute the radius of largest circle that is contained within a (multi)polygon or the largest circle of a set of geometries constrained by obstacles.\n The obstacles may be any combination of point, linear and polygonal geometries.");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Double execute(Geometry geometry) throws SQLException {
        double height;
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return null;
        }
        Envelope env = geometry.getEnvelopeInternal();
        double width = env.getWidth();
        double size = width > (height = env.getHeight()) ? width : height;
        double tolerance = size / 1000.0;
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            MaximumInscribedCircle mic = new MaximumInscribedCircle(geometry, tolerance);
            return mic.getRadiusLine().getLength();
        }
        LargestEmptyCircle lec = new LargestEmptyCircle(geometry, null, tolerance);
        return lec.getRadiusLine().getLength();
    }
}

