/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.GeometricShapeFactory;

public class ST_MakeArcPolygon
extends DeterministicScalarFunction {
    private static final GeometricShapeFactory GSF = new GeometricShapeFactory();

    public ST_MakeArcPolygon() {
        this.addProperty("remarks", "Creates an elliptical arc, as a Polygon centered at the given point with  a distance from the center point, a start angle (in radians) , a angle offset to define its size (in radians). The arc is always created in a counter-clockwise direction. ");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static Polygon execute(Point p, double distance, double startAngle, double angExtent) {
        if (p == null) {
            return null;
        }
        GSF.setCentre(new Coordinate(p.getX(), p.getY()));
        GSF.setSize(distance);
        Polygon geom = GSF.createArcPolygon(startAngle, angExtent);
        geom.setSRID(p.getSRID());
        return geom;
    }
}

