/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.cts.util.UTMUtils;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2gis.utilities.GeographyUtilities;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GridRowSet
implements SimpleRowSource {
    private static final GeometryFactory GF = new GeometryFactory();
    private static int cellI = 0;
    private static int cellJ = 0;
    private int maxI;
    private int maxJ;
    private double deltaX;
    private double deltaY;
    private double minX;
    private double minY;
    private double maxY;
    private int id = 0;
    private final Connection connection;
    private boolean firstRow = true;
    private Envelope envelope;
    private boolean isTable;
    private String tableName;
    private boolean isCenterCell = false;
    private int srid;
    private boolean isRowColumnNumber = false;
    private boolean upperCornerOrder = false;

    public GridRowSet(Connection connection, double deltaX, double deltaY, String tableName) {
        this.connection = connection;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.tableName = tableName;
        this.isTable = true;
    }

    public GridRowSet(Connection connection, double deltaX, double deltaY, Geometry geometry) {
        this.connection = connection;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.srid = geometry.getSRID();
        this.envelope = geometry.getEnvelopeInternal();
        this.isTable = false;
    }

    public Object[] readRow() throws SQLException {
        if (this.firstRow) {
            this.reset();
        }
        if (cellI == this.maxI) {
            ++cellJ;
            cellI = 0;
        }
        if (cellJ >= this.maxJ) {
            cellJ = 0;
            return null;
        }
        if (this.isCenterCell) {
            if (this.upperCornerOrder) {
                return new Object[]{this.getCellPointUpper(), this.id++, cellI, cellJ + 1};
            }
            return new Object[]{this.getCellPoint(), this.id++, cellI, cellJ + 1};
        }
        if (this.upperCornerOrder) {
            return new Object[]{this.getCellPolygonUpper(), this.id++, cellI, cellJ + 1};
        }
        return new Object[]{this.getCellPolygon(), this.id++, cellI, cellJ + 1};
    }

    public void close() {
    }

    public void reset() throws SQLException {
        cellI = 0;
        cellJ = 0;
        this.firstRow = false;
        if (this.isTable) {
            Statement statement = this.connection.createStatement();
            Tuple geomMetadata = GeometryTableUtilities.getFirstColumnMetaData((Connection)this.connection, (TableLocation)TableLocation.parse((String)this.tableName, (DBTypes)DBUtils.getDBType((Connection)this.connection)));
            this.srid = ((GeometryMetaData)geomMetadata.second()).SRID;
            try (ResultSet rs = statement.executeQuery("select ST_Extent(" + (String)geomMetadata.first() + ")  from " + this.tableName);){
                rs.next();
                Geometry geomExtend = (Geometry)rs.getObject(1);
                if (geomExtend == null) {
                    throw new SQLException("The envelope cannot be null.");
                }
                this.envelope = geomExtend.getEnvelopeInternal();
                this.initParameters();
            }
        } else {
            if (this.envelope == null || this.envelope.isNull()) {
                throw new SQLException("The input geometry used to compute the grid cannot be null.");
            }
            this.initParameters();
        }
    }

    private Polygon getCellPolygon() {
        Coordinate[] summits = new Coordinate[5];
        double x1 = this.minX + (double)cellI * this.deltaX;
        double y1 = this.minY + (double)cellJ * this.deltaY;
        double x2 = this.minX + (double)(cellI + 1) * this.deltaX;
        double y2 = this.minY + (double)(cellJ + 1) * this.deltaY;
        summits[0] = new Coordinate(x1, y1);
        summits[1] = new Coordinate(x2, y1);
        summits[2] = new Coordinate(x2, y2);
        summits[3] = new Coordinate(x1, y2);
        summits[4] = new Coordinate(x1, y1);
        LinearRing g = GF.createLinearRing(summits);
        Polygon gg = GF.createPolygon(g, null);
        ++cellI;
        gg.setSRID(this.srid);
        return gg;
    }

    private Polygon getCellPolygonUpper() {
        Coordinate[] summits = new Coordinate[5];
        double x1 = this.minX + (double)cellI * this.deltaX;
        double y1 = this.maxY - (double)cellJ * this.deltaY;
        double x2 = this.minX + (double)(cellI + 1) * this.deltaX;
        double y2 = this.maxY - (double)(cellJ + 1) * this.deltaY;
        summits[0] = new Coordinate(x1, y1);
        summits[1] = new Coordinate(x2, y1);
        summits[2] = new Coordinate(x2, y2);
        summits[3] = new Coordinate(x1, y2);
        summits[4] = new Coordinate(x1, y1);
        LinearRing g = GF.createLinearRing(summits);
        Polygon gg = GF.createPolygon(g, null);
        ++cellI;
        gg.setSRID(this.srid);
        return gg;
    }

    private Point getCellPointUpper() {
        double x1 = this.minX + (double)cellI * this.deltaX + this.deltaX / 2.0;
        double y1 = this.maxY - (double)cellJ * this.deltaY - this.deltaY / 2.0;
        ++cellI;
        Point gg = GF.createPoint(new Coordinate(x1, y1));
        gg.setSRID(this.srid);
        return gg;
    }

    private Point getCellPoint() {
        double x1 = this.minX + (double)cellI * this.deltaX + this.deltaX / 2.0;
        double y1 = this.minY + (double)cellJ * this.deltaY + this.deltaY / 2.0;
        ++cellI;
        Point gg = GF.createPoint(new Coordinate(x1, y1));
        gg.setSRID(this.srid);
        return gg;
    }

    public boolean isCenterCell() {
        return this.isCenterCell;
    }

    public void setCenterCell(boolean isCenterCell) {
        this.isCenterCell = isCenterCell;
    }

    public void setIsRowColumnNumber(boolean isRowColumnNumber) {
        this.isRowColumnNumber = isRowColumnNumber;
    }

    public boolean isRowColumnNumber() {
        return this.isRowColumnNumber;
    }

    private void initParameters() throws SQLException {
        this.minX = this.envelope.getMinX();
        this.minY = this.envelope.getMinY();
        this.maxY = this.envelope.getMaxY();
        if (this.isRowColumnNumber()) {
            if (this.deltaX < 1.0 || this.deltaY < 1.0) {
                throw new SQLException("The number of columns and rows must be greater or equals than 1.");
            }
            this.minX = this.envelope.getMinX();
            this.minY = this.envelope.getMinY();
            this.maxY = this.envelope.getMaxY();
            double dx = this.envelope.getMaxX() - this.minX;
            double dy = this.envelope.getMaxY() - this.minY;
            this.maxI = (int)this.deltaX;
            this.maxJ = (int)this.deltaY;
            this.deltaX = dx / this.deltaX;
            this.deltaY = dy / this.deltaY;
        } else if (this.srid == 4326) {
            if (this.deltaX <= 0.0 || this.deltaY <= 0.0) {
                throw new SQLException("The delta x and y of cell size must be greater than 0.");
            }
            double maxLon = this.envelope.getMaxX();
            double maxLat = this.envelope.getMaxY();
            if (!UTMUtils.isValidLatitude((float)((float)this.minY))) {
                throw new IllegalArgumentException("Invalid min latitude");
            }
            if (!UTMUtils.isValidLatitude((float)((float)maxLat))) {
                throw new IllegalArgumentException("Invalid max latitude");
            }
            if (!UTMUtils.isValidLongitude((float)((float)this.minX))) {
                throw new IllegalArgumentException("Invalid min longitude");
            }
            if (!UTMUtils.isValidLongitude((float)((float)maxLon))) {
                throw new IllegalArgumentException("Invalid max longitude");
            }
            this.deltaY = GeographyUtilities.computeLatitudeDistance((double)this.deltaY);
            this.deltaX = GeographyUtilities.computeLongitudeDistance((double)this.deltaX, (double)maxLat);
            double cellWidth = this.envelope.getWidth();
            double cellHeight = this.envelope.getHeight();
            this.maxI = (int)Math.ceil(cellWidth / this.deltaX);
            this.maxJ = (int)Math.ceil(cellHeight / this.deltaY);
        } else {
            if (this.deltaX <= 0.0 || this.deltaY <= 0.0) {
                throw new SQLException("The delta x and y of cell size must be greater than 0.");
            }
            double cellWidth = this.envelope.getWidth();
            double cellHeight = this.envelope.getHeight();
            this.maxI = (int)Math.ceil(cellWidth / this.deltaX);
            this.maxJ = (int)Math.ceil(cellHeight / this.deltaY);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        SimpleResultSet srs = new SimpleResultSet((SimpleRowSource)this);
        srs.addColumn("THE_GEOM", 1111, "GEOMETRY", 0, 0);
        srs.addColumn("ID", 4, 10, 0);
        srs.addColumn("ID_COL", 4, 10, 0);
        srs.addColumn("ID_ROW", 4, 10, 0);
        return srs;
    }

    public void setUpperOrder(boolean upperOrder) {
        this.upperCornerOrder = upperOrder;
    }
}

