/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class ST_Force3DM
extends DeterministicScalarFunction {
    static final GeometryFactory gf = new GeometryFactory();

    public ST_Force3DM() {
        this.addProperty("remarks", "Forces the geometries into XYM mode.\n If a geometry has no M component, then a M value is tacked on. Z value is removed. Default M value is set to zero.");
    }

    public String getJavaStaticMethod() {
        return "force3DM";
    }

    public static Geometry force3DM(Geometry geom) {
        if (geom == null) {
            return null;
        }
        return ST_Force3DM.forceXYM(geom, 0.0);
    }

    public static Geometry force3DM(Geometry geom, double mValue) {
        if (geom == null) {
            return null;
        }
        return ST_Force3DM.forceXYM(geom, mValue);
    }

    public static Geometry forceXYM(Geometry geom, double mValue) {
        int dimension = 2;
        Geometry g = geom;
        if (geom instanceof Point) {
            CoordinateSequence cs = ((Point)geom).getCoordinateSequence();
            if (cs.getDimension() != dimension || cs.getMeasures() != 1) {
                g = gf.createPoint((CoordinateSequence)ST_Force3DM.convertSequence(cs, mValue));
                g.setSRID(geom.getSRID());
            }
        } else if (geom instanceof LineString) {
            CoordinateSequence cs = ((LineString)geom).getCoordinateSequence();
            if (cs.getDimension() != dimension || cs.getMeasures() != 1) {
                g = gf.createLineString((CoordinateSequence)ST_Force3DM.convertSequence(cs, mValue));
                g.setSRID(geom.getSRID());
            }
        } else if (geom instanceof Polygon) {
            g = ST_Force3DM.convert((Polygon)geom, mValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPoint) {
            g = ST_Force3DM.convert((MultiPoint)geom, mValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiLineString) {
            g = ST_Force3DM.convert((MultiLineString)geom, mValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPolygon) {
            g = ST_Force3DM.convert((MultiPolygon)geom, mValue);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof GeometryCollection) {
            g = ST_Force3DM.convert((GeometryCollection)geom, mValue);
            g.setSRID(geom.getSRID());
        }
        return g;
    }

    public static Point convert(Point p, double mValue) {
        int dimension = 2;
        CoordinateSequence cs = p.getCoordinateSequence();
        if (cs.getDimension() != dimension || cs.getMeasures() != 1) {
            Point g = gf.createPoint((CoordinateSequence)ST_Force3DM.convertSequence(cs, mValue));
            g.setSRID(p.getSRID());
            return g;
        }
        return p;
    }

    public static MultiPoint convert(MultiPoint mp, double mValue) {
        int nb = mp.getNumGeometries();
        Point[] geometries = new Point[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = ST_Force3DM.convert((Point)mp.getGeometryN(i), mValue);
        }
        return gf.createMultiPoint(geometries);
    }

    public static GeometryCollection convert(GeometryCollection gc, double mValue) {
        int nb = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = ST_Force3DM.forceXYM(gc.getGeometryN(i), mValue);
        }
        return gf.createGeometryCollection(geometries);
    }

    public static MultiPolygon convert(MultiPolygon multiPolygon, double mValue) {
        int nb = multiPolygon.getNumGeometries();
        Polygon[] pl = new Polygon[nb];
        for (int i = 0; i < nb; ++i) {
            pl[i] = ST_Force3DM.convert((Polygon)multiPolygon.getGeometryN(i), mValue);
        }
        return gf.createMultiPolygon(pl);
    }

    public static MultiLineString convert(MultiLineString multiLineString, double mValue) {
        int nb = multiLineString.getNumGeometries();
        LineString[] ls = new LineString[nb];
        for (int i = 0; i < nb; ++i) {
            ls[i] = ST_Force3DM.convert((LineString)multiLineString.getGeometryN(i), mValue);
        }
        return gf.createMultiLineString(ls);
    }

    public static Polygon convert(Polygon polygon, double mValue) {
        CoordinateSequence cs = polygon.getExteriorRing().getCoordinateSequence();
        LinearRing shell = gf.createLinearRing((CoordinateSequence)ST_Force3DM.convertSequence(cs, mValue));
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = gf.createLinearRing((CoordinateSequence)ST_Force3DM.convertSequence(polygon.getInteriorRingN(i).getCoordinateSequence(), mValue));
        }
        Polygon p = gf.createPolygon(shell, holes);
        p.setSRID(polygon.getSRID());
        return p;
    }

    public static LineString convert(LineString lineString, double mValue) {
        return gf.createLineString((CoordinateSequence)ST_Force3DM.convertSequence(lineString.getCoordinateSequence(), mValue));
    }

    public static LinearRing convert(LinearRing linearRing, double mValue) {
        return gf.createLinearRing((CoordinateSequence)ST_Force3DM.convertSequence(linearRing.getCoordinateSequence(), mValue));
    }

    private static CoordinateArraySequence convertSequence(CoordinateSequence cs, double mValue) {
        boolean hasM = cs.getMeasures() == 1;
        CoordinateXYM[] coordsXYM = new CoordinateXYM[cs.size()];
        for (int i = 0; i < cs.size(); ++i) {
            Coordinate coordTmp = cs.getCoordinate(i);
            CoordinateXYM coord = new CoordinateXYM(coordTmp);
            if (hasM) {
                coord.setM(coordTmp.getM());
            } else {
                coord.setM(mValue);
            }
            coordsXYM[i] = coord;
        }
        return new CoordinateArraySequence((Coordinate[])coordsXYM, 2, 1);
    }
}

