/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class GeometryCoordinateDimension {
    static final GeometryFactory gf = new GeometryFactory();

    public static Geometry force(Geometry geom, int dimension) {
        Geometry g = geom;
        if (geom instanceof Point) {
            g = gf.createPoint((CoordinateSequence)GeometryCoordinateDimension.convertSequence(((Point)geom).getCoordinateSequence(), dimension));
            g.setSRID(geom.getSRID());
        } else if (geom instanceof LineString) {
            g = gf.createLineString((CoordinateSequence)GeometryCoordinateDimension.convertSequence(((LineString)geom).getCoordinateSequence(), dimension));
            g.setSRID(geom.getSRID());
        } else if (geom instanceof Polygon) {
            g = GeometryCoordinateDimension.convert((Polygon)geom, dimension);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPoint) {
            g = GeometryCoordinateDimension.convert((MultiPoint)geom, dimension);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiLineString) {
            g = GeometryCoordinateDimension.convert((MultiLineString)geom, dimension);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPolygon) {
            g = GeometryCoordinateDimension.convert((MultiPolygon)geom, dimension);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof GeometryCollection) {
            g = GeometryCoordinateDimension.convert((GeometryCollection)geom, dimension);
            g.setSRID(geom.getSRID());
        }
        return g;
    }

    public static MultiPoint convert(MultiPoint mp, int dimension) {
        int nb = mp.getNumGeometries();
        Point[] geometries = new Point[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = (Point)GeometryCoordinateDimension.force(mp.getGeometryN(i), dimension);
        }
        return gf.createMultiPoint(geometries);
    }

    public static GeometryCollection convert(GeometryCollection gc, int dimension) {
        int nb = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = GeometryCoordinateDimension.force(gc.getGeometryN(i), dimension);
        }
        return gf.createGeometryCollection(geometries);
    }

    public static MultiPolygon convert(MultiPolygon multiPolygon, int dimension) {
        int nb = multiPolygon.getNumGeometries();
        Polygon[] pl = new Polygon[nb];
        for (int i = 0; i < nb; ++i) {
            pl[i] = GeometryCoordinateDimension.convert((Polygon)multiPolygon.getGeometryN(i), dimension);
        }
        return gf.createMultiPolygon(pl);
    }

    public static MultiLineString convert(MultiLineString multiLineString, int dimension) {
        int nb = multiLineString.getNumGeometries();
        LineString[] ls = new LineString[nb];
        for (int i = 0; i < nb; ++i) {
            ls[i] = GeometryCoordinateDimension.convert((LineString)multiLineString.getGeometryN(i), dimension);
        }
        return gf.createMultiLineString(ls);
    }

    public static Polygon convert(Polygon polygon, int dimension) {
        LinearRing shell = gf.createLinearRing((CoordinateSequence)GeometryCoordinateDimension.convertSequence(polygon.getExteriorRing().getCoordinateSequence(), dimension));
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = gf.createLinearRing((CoordinateSequence)GeometryCoordinateDimension.convertSequence(polygon.getInteriorRingN(i).getCoordinateSequence(), dimension));
        }
        return gf.createPolygon(shell, holes);
    }

    public static LineString convert(LineString lineString, int dimension) {
        return gf.createLineString((CoordinateSequence)GeometryCoordinateDimension.convertSequence(lineString.getCoordinateSequence(), dimension));
    }

    public static LinearRing convert(LinearRing linearRing, int dimension) {
        return gf.createLinearRing((CoordinateSequence)GeometryCoordinateDimension.convertSequence(linearRing.getCoordinateSequence(), dimension));
    }

    private static CoordinateArraySequence convertSequence(CoordinateSequence cs, int dimension) {
        if (dimension == 4) {
            return GeometryCoordinateDimension.convertXYZMSequence(cs, dimension);
        }
        Coordinate[] coords = new Coordinate[cs.size()];
        block4: for (int i = 0; i < cs.size(); ++i) {
            Coordinate coord = cs.getCoordinate(i);
            switch (dimension) {
                case 2: {
                    coords[i] = new Coordinate(coord.x, coord.y);
                    continue block4;
                }
                case 3: {
                    coord = new Coordinate(coord);
                    double z = coord.z;
                    if (Double.isNaN(z)) {
                        coord.z = 0.0;
                    }
                    coords[i] = coord;
                    continue block4;
                }
            }
        }
        return new CoordinateArraySequence(coords, dimension);
    }

    private static CoordinateArraySequence convertXYZMSequence(CoordinateSequence cs, int dimension) {
        boolean hasM = false;
        if (cs.getMeasures() == 1) {
            hasM = true;
        }
        CoordinateXYZM[] coordsXYZM = new CoordinateXYZM[cs.size()];
        for (int i = 0; i < cs.size(); ++i) {
            Coordinate coordTmp = cs.getCoordinate(i);
            CoordinateXYZM coord = new CoordinateXYZM(coordTmp);
            if (hasM) {
                coord.setM(coordTmp.getM());
                coord.setZ(0.0);
            } else {
                double z = coord.z;
                if (Double.isNaN(z)) {
                    coord.z = 0.0;
                }
            }
            coordsXYZM[i] = coord;
        }
        return new CoordinateArraySequence((Coordinate[])coordsXYZM, dimension);
    }
}

