/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class ST_Collect
extends DeterministicScalarFunction {
    static GeometryFactory GF = new GeometryFactory();

    public ST_Collect() {
        this.addProperty("remarks", "Collects geometries into a geometry collection. \nThe result is either a Multi* or a GeometryCollection, depending on whether the input geometries have the same or different types (homogeneous or heterogeneous). \nThe input geometries are left unchanged within the collection.");
    }

    public String getJavaStaticMethod() {
        return "collect";
    }

    public static Geometry collect(Geometry[] geometries) {
        if (geometries == null) {
            return null;
        }
        return GF.buildGeometry(Arrays.asList(geometries));
    }

    public static Geometry collect(Geometry geomA, Geometry geomB) {
        if (geomA == null && geomB == null) {
            return null;
        }
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        if (geomA != null) {
            geoms.add(geomA);
        }
        if (geomB != null) {
            geoms.add(geomB);
        }
        return GF.buildGeometry(geoms);
    }
}

