/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.overpass;

import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.overpass.OverpassTool;

public class ST_OverpassDownloader
extends AbstractFunction
implements ScalarFunction {
    public ST_OverpassDownloader() {
        this.addProperty("remarks", "Extract OSM data from Overpass api server and save the result into a file.\n\n ST_OverpassDownloader(...\n Supported arguments :\n overpass query as string, path of the file to store the result\n overpass query as string, path of the file to store the result, true to delete the file if exist\n overpass query as string, path of the file to store the result, true to delete the file if exist, network options as 'proxyhost=? proxyport=? endpoint=?");
    }

    public String getJavaStaticMethod() {
        return "execute";
    }

    public static void execute(String overpassQuery, String fileName) throws Exception {
        ST_OverpassDownloader.execute(overpassQuery, fileName, true);
    }

    public static void execute(String overpassQuery, String fileName, boolean deleteFile) throws Exception {
        OverpassTool overpassTool = new OverpassTool();
        overpassTool.downloadFile(overpassQuery, fileName, deleteFile);
    }

    public static void execute(String overpassQuery, String fileName, boolean deleteFile, String options) throws Exception {
        OverpassTool overpassTool = new OverpassTool();
        if (options != null) {
            String[] optionsNet;
            for (String params : optionsNet = options.split("\\s+")) {
                String[] keyValue = params.split("=");
                if (keyValue[0].equalsIgnoreCase("proxyhost")) {
                    overpassTool.setProxyHost(keyValue[1]);
                    continue;
                }
                if (keyValue[0].equalsIgnoreCase("proxyport")) {
                    overpassTool.setProxyPort(Integer.parseInt(keyValue[1]));
                    continue;
                }
                if (!keyValue[0].equalsIgnoreCase("endpoint")) continue;
                overpassTool.setEndPoint(keyValue[1]);
            }
        }
        overpassTool.downloadFile(overpassQuery, fileName, deleteFile);
    }
}

