/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.overpass;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.h2gis.utilities.URIUtilities;

public class OverpassTool {
    private String endPoint = "https://overpass-api.de/api/interpreter?data=";
    private String proxyHost;
    private int proxyPort;

    public HttpURLConnection prepareConnection(String overpassQuery) throws Exception {
        HttpURLConnection connection;
        Matcher timeoutMatcher = Pattern.compile("\\[timeout:(\\d+)\\]").matcher(overpassQuery);
        int timeout = timeoutMatcher.find() ? (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(timeoutMatcher.group(1))) : (int)TimeUnit.MINUTES.toMillis(3L);
        URL queryUrl = new URL(this.getEndpoint() + URLEncoder.encode(overpassQuery, StandardCharsets.UTF_8));
        if (this.getProxyHost() != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
            connection = (HttpURLConnection)queryUrl.openConnection(proxy);
        } else {
            connection = (HttpURLConnection)queryUrl.openConnection();
        }
        connection.setRequestProperty("User-Agent", "H2GIS_" + System.currentTimeMillis());
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        return connection;
    }

    public InputStream downloadAsStream(String overpassQuery) throws Exception {
        if (overpassQuery == null || overpassQuery.isEmpty()) {
            throw new IllegalArgumentException("The overpass query cannot be null or empty");
        }
        HttpURLConnection connection = this.prepareConnection("[out:json][timeout:25];\n" + overpassQuery + "\nout geom;");
        connection.connect();
        switch (connection.getResponseCode()) {
            case 400: {
                throw new IOException("Error : Cannot execute the Overpass query " + connection.getURL());
            }
            case 509: {
                throw new IOException("Error: You have downloaded too much data. Please try again later");
            }
        }
        return connection.getInputStream();
    }

    public void downloadFile(String overpassQuery, String outputFile, boolean deleteFile) throws Exception {
        if (overpassQuery == null || overpassQuery.isEmpty()) {
            throw new IllegalArgumentException("The overpass query cannot be null or empty");
        }
        String cleanQuery = StringUtils.deleteWhitespace((String)overpassQuery);
        File file = URIUtilities.fileFromString((String)outputFile);
        this.checkOutputFile(cleanQuery, file);
        if (file.exists()) {
            if (deleteFile) {
                file.delete();
            } else {
                throw new FileNotFoundException("The following file already exists:\n" + outputFile);
            }
        }
        HttpURLConnection connection = this.prepareConnection(overpassQuery);
        connection.connect();
        switch (connection.getResponseCode()) {
            case 400: {
                throw new IOException("Error : Cannot execute the Overpass query " + connection.getURL());
            }
            case 509: {
                throw new IOException("Error: You have downloaded too much data. Please try again later");
            }
        }
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(file);){
            int numBytes;
            byte[] data = new byte[4096];
            while ((numBytes = in.read(data)) != -1) {
                ((OutputStream)out).write(data, 0, numBytes);
            }
        }
    }

    public void checkOutputFile(String overpassQuery, File outputFile) {
        if (outputFile.getName().toLowerCase().endsWith(".csv") && !StringUtils.containsIgnoreCase((CharSequence)overpassQuery, (CharSequence)"out:csv")) {
            throw new IllegalArgumentException("The file extension is not compatible with the one specified in the request. Please use csv");
        }
        if (outputFile.getName().toLowerCase().endsWith(".json") && !StringUtils.containsIgnoreCase((CharSequence)overpassQuery, (CharSequence)"out:json")) {
            throw new IllegalArgumentException("The file extension is not compatible with the one specified in the request. Please use json");
        }
        if (outputFile.getName().toLowerCase().endsWith(".osm") && StringUtils.containsAnyIgnoreCase((CharSequence)overpassQuery, (CharSequence[])new CharSequence[]{"out:json", "out:csv"})) {
            throw new IllegalArgumentException("The file extension is not compatible with the one specified in the request");
        }
    }

    public String getEndpoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }
}

