/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.functions.io.geojson.GeoJsonField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GJGeometryReader {
    private final GeometryFactory GF;
    private String geomType;

    public GJGeometryReader(GeometryFactory GF) {
        this.GF = GF;
    }

    public Geometry parseGeometry(JsonParser jsParser) throws IOException, SQLException {
        jsParser.nextToken();
        jsParser.nextToken();
        jsParser.nextToken();
        String geomType = jsParser.getText();
        if (geomType.equalsIgnoreCase(GeoJsonField.POINT)) {
            return this.parsePoint(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.MULTIPOINT)) {
            return this.parseMultiPoint(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.LINESTRING)) {
            return this.parseLinestring(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.MULTILINESTRING)) {
            return this.parseMultiLinestring(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.POLYGON)) {
            return this.parsePolygon(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.MULTIPOLYGON)) {
            return this.parseMultiPolygon(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.GEOMETRYCOLLECTION)) {
            return this.parseGeometryCollection(jsParser);
        }
        throw new SQLException("Unsupported geometry : " + geomType);
    }

    private Geometry parseGeometry(JsonParser jp, String geometryType) throws IOException, SQLException {
        if (geometryType.equalsIgnoreCase(GeoJsonField.POINT)) {
            return this.parsePoint(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.MULTIPOINT)) {
            return this.parseMultiPoint(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.LINESTRING)) {
            return this.parseLinestring(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.MULTILINESTRING)) {
            return this.parseMultiLinestring(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.POLYGON)) {
            return this.parsePolygon(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.MULTIPOLYGON)) {
            return this.parseMultiPolygon(jp);
        }
        if (geometryType.equalsIgnoreCase(GeoJsonField.GEOMETRYCOLLECTION)) {
            return this.parseGeometryCollection(jp);
        }
        throw new SQLException("Unsupported geometry : " + geometryType);
    }

    public Point parsePoint(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            Point point = this.GF.createPoint(this.parseCoordinate(jp));
            return point;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    public MultiPoint parseMultiPoint(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            return this.GF.createMultiPoint(this.parseCoordinates(jp));
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    public LineString parseLinestring(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            LineString line = this.GF.createLineString(this.parseCoordinates(jp));
            jp.nextToken();
            return line;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    public MultiLineString parseMultiLinestring(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            ArrayList<LineString> lineStrings = new ArrayList<LineString>();
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                lineStrings.add(this.GF.createLineString(this.parseCoordinates(jp)));
                jp.nextToken();
            }
            MultiLineString line = this.GF.createMultiLineString(lineStrings.toArray(new LineString[0]));
            jp.nextToken();
            return line;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    public Polygon parsePolygon(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            jp.nextToken();
            int linesIndex = 0;
            LinearRing linearRing = null;
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                if (linesIndex == 0) {
                    linearRing = this.GF.createLinearRing(this.parseCoordinates(jp));
                } else {
                    holes.add(this.GF.createLinearRing(this.parseCoordinates(jp)));
                }
                jp.nextToken();
                ++linesIndex;
            }
            if (linesIndex > 1) {
                jp.nextToken();
                return this.GF.createPolygon(linearRing, holes.toArray(new LinearRing[0]));
            }
            jp.nextToken();
            return this.GF.createPolygon(linearRing, null);
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    public MultiPolygon parseMultiPolygon(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                jp.nextToken();
                int linesIndex = 0;
                LinearRing linearRing = null;
                ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
                while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    if (linesIndex == 0) {
                        linearRing = this.GF.createLinearRing(this.parseCoordinates(jp));
                    } else {
                        holes.add(this.GF.createLinearRing(this.parseCoordinates(jp)));
                    }
                    jp.nextToken();
                    ++linesIndex;
                }
                if (linesIndex > 1) {
                    jp.nextToken();
                    polygons.add(this.GF.createPolygon(linearRing, holes.toArray(new LinearRing[0])));
                    continue;
                }
                jp.nextToken();
                polygons.add(this.GF.createPolygon(linearRing, null));
            }
            jp.nextToken();
            return this.GF.createMultiPolygon(polygons.toArray(new Polygon[0]));
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    public GeometryCollection parseGeometryCollection(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String geometriesField = jp.getText();
        if (geometriesField.equalsIgnoreCase(GeoJsonField.GEOMETRIES)) {
            jp.nextToken();
            jp.nextToken();
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                jp.nextToken();
                jp.nextToken();
                String geometryType = jp.getText();
                geometries.add(this.parseGeometry(jp, geometryType));
                jp.nextToken();
            }
            jp.nextToken();
            return this.GF.createGeometryCollection(geometries.toArray(new Geometry[0]));
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'geometries', found '" + geometriesField + "'");
    }

    public Coordinate[] parseCoordinates(JsonParser jp) throws IOException {
        jp.nextToken();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
            coords.add(this.parseCoordinate(jp));
        }
        return coords.toArray(new Coordinate[0]);
    }

    public Coordinate parseCoordinate(JsonParser jp) throws IOException {
        Coordinate coord;
        jp.nextToken();
        double x = jp.getDoubleValue();
        jp.nextToken();
        double y = jp.getDoubleValue();
        jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.END_ARRAY) {
            coord = new Coordinate(x, y);
        } else {
            double z = jp.getDoubleValue();
            jp.nextToken();
            coord = new Coordinate(x, y, z);
        }
        jp.nextToken();
        return coord;
    }

    public String getGeomType() {
        return this.geomType;
    }
}

