/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.fgb;

import com.google.common.collect.Lists;
import com.google.flatbuffers.FlatBufferBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.fgb.fileTable.GeometryConversions;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.wololo.flatgeobuf.ColumnMeta;
import org.wololo.flatgeobuf.Constants;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.NodeItem;
import org.wololo.flatgeobuf.PackedRTree;
import org.wololo.flatgeobuf.generated.ColumnType;
import org.wololo.flatgeobuf.generated.Feature;

public class FGBWriteDriver {
    private static final int BYTEBUFFER_CACHE = 1024;
    short packedRTreeNodeSize = (short)16;
    boolean createIndex = true;
    private final Connection connection;

    public FGBWriteDriver(Connection connection) {
        this.connection = connection;
    }

    public short getPackedRTreeNodeSize() {
        return this.packedRTreeNodeSize;
    }

    public void setPackedRTreeNodeSize(short packedRTreeNodeSize) {
        this.packedRTreeNodeSize = packedRTreeNodeSize;
    }

    public boolean isCreateIndex() {
        return this.createIndex;
    }

    public void setCreateIndex(boolean createIndex) {
        this.createIndex = createIndex;
    }

    public String write(ProgressVisitor progress, String tableName, File fileName, boolean deleteFiles) throws IOException, SQLException {
        if (tableName == null) {
            throw new SQLException("The select query or the table name must not be null.");
        }
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        if (matcher.find()) {
            if (tableName.startsWith("(") && tableName.endsWith(")")) {
                if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"fgb")) {
                    Object value;
                    if (deleteFiles) {
                        Files.deleteIfExists(fileName.toPath());
                    } else if (fileName.exists()) {
                        throw new IOException("The fgb file already exist.");
                    }
                    PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
                    JDBCUtilities.attachCancelResultSet((Statement)ps, (ProgressVisitor)progress);
                    ResultSet rs = ps.executeQuery();
                    Tuple spatialFieldNameAndIndex = GeometryTableUtilities.getFirstGeometryColumnNameAndIndex((ResultSet)rs);
                    int srid = 0;
                    int recordCount = 0;
                    rs.last();
                    recordCount = rs.getRow();
                    if (recordCount > 0 && (value = rs.getObject((Integer)spatialFieldNameAndIndex.second())) != null) {
                        Geometry geom = (Geometry)value;
                        srid = geom.getSRID();
                    }
                    rs.beforeFirst();
                    ProgressVisitor copyProgress = progress.subProcess(recordCount);
                    this.doExport(progress, rs, (String)spatialFieldNameAndIndex.first(), "GEOMETRY", srid, recordCount, new FileOutputStream(fileName), null);
                    copyProgress.endOfProgress();
                    return fileName.getAbsolutePath();
                }
                throw new SQLException("Only .fgb extension is supported");
            }
            throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
        }
        if (FileUtilities.isExtensionWellFormated((File)fileName, (String)"fgb")) {
            if (deleteFiles) {
                Files.deleteIfExists(fileName.toPath());
            } else if (fileName.exists()) {
                throw new IOException("The flatgeobuffer file already exist.");
            }
            String filePath = fileName.getName();
            int dotIndex = filePath.lastIndexOf(46);
            String fileNameWithoutExt = filePath.substring(0, dotIndex);
            this.fgbWrite(progress, tableName, new FileOutputStream(fileName), fileNameWithoutExt);
            return fileName.getAbsolutePath();
        }
        throw new SQLException("Only .fgb extension is supported");
    }

    private static void writeString(String value, ByteBuffer bufferManager) throws IOException {
        byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
        bufferManager.putInt(stringBytes.length);
        bufferManager.put(stringBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fgbWrite(ProgressVisitor progress, String tableName, FileOutputStream outputStream, String fileNameWithoutExt) throws IOException, SQLException {
        try {
            DBTypes dbTypes = DBUtils.getDBType((Connection)this.connection);
            TableLocation parse = TableLocation.parse((String)tableName, (DBTypes)dbTypes);
            String outputTable = parse.toString();
            int recordCount = JDBCUtilities.getRowCount((Connection)this.connection, (String)outputTable);
            try (Statement st = this.connection.createStatement();){
                Tuple geomMetadata = GeometryTableUtilities.getFirstColumnMetaData((Connection)this.connection, (TableLocation)parse);
                String geomCol = (String)geomMetadata.first();
                geomMetadata.second();
                ResultSet rs = st.executeQuery(String.format("select * from %s", outputTable));
                this.doExport(progress, rs, geomCol, ((GeometryMetaData)geomMetadata.second()).sfs_geometryType, ((GeometryMetaData)geomMetadata.second()).SRID, recordCount, outputStream, fileNameWithoutExt);
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }

    private String doExport(ProgressVisitor progress, ResultSet rs, String geometryColumn, String geometryType, int srid, int recordCount, FileOutputStream outputStream, String fileName) throws SQLException, IOException {
        FlatBufferBuilder bufferBuilder = new FlatBufferBuilder();
        HeaderMeta header = this.writeHeader(outputStream, fileName, bufferBuilder, recordCount, geometryType, srid, rs.getMetaData());
        long endHeaderPosition = outputStream.getChannel().position();
        int columnCount = header.columns.size();
        ArrayList<PackedRTree.FeatureItem> envelopes = null;
        if (header.featuresCount > 0L && this.createIndex && header.featuresCount < Integer.MAX_VALUE) {
            envelopes = new ArrayList<PackedRTree.FeatureItem>((int)header.featuresCount);
            long indexSize = PackedRTree.calcSize((int)((int)header.featuresCount), (int)this.packedRTreeNodeSize);
            byte[] buffer = new byte[512];
            for (long written = 0L; written < indexSize; written += (long)buffer.length) {
                if ((long)buffer.length > indexSize - written) {
                    buffer = new byte[(int)(indexSize - written)];
                }
                outputStream.write(buffer);
            }
        }
        long featureAddressPointer = 0L;
        ByteBuffer bufferManager = ByteBuffer.allocate(1024);
        bufferManager.order(ByteOrder.LITTLE_ENDIAN);
        ProgressVisitor copyProgress = progress.subProcess(recordCount);
        while (rs.next()) {
            bufferManager.clear();
            while (true) {
                try {
                    block16: for (int i = 0; i < columnCount; ++i) {
                        ColumnMeta column = (ColumnMeta)header.columns.get(i);
                        Object value = rs.getObject(column.name);
                        if (value == null) continue;
                        bufferManager.putShort((short)i);
                        byte type = column.type;
                        switch (type) {
                            case 2: {
                                bufferManager.put((byte)((Boolean)value != false ? 1 : 0));
                                continue block16;
                            }
                            case 0: {
                                bufferManager.put((Byte)value);
                                continue block16;
                            }
                            case 3: {
                                bufferManager.putShort(((Integer)value).shortValue());
                                continue block16;
                            }
                            case 5: {
                                bufferManager.putInt((Integer)value);
                                continue block16;
                            }
                            case 9: {
                                if (value instanceof Float) {
                                    bufferManager.putFloat(((Float)value).floatValue());
                                    continue block16;
                                }
                                bufferManager.putFloat(((Double)value).floatValue());
                                continue block16;
                            }
                            case 10: {
                                if (value instanceof BigDecimal) {
                                    bufferManager.putDouble(((BigDecimal)value).doubleValue());
                                    continue block16;
                                }
                                bufferManager.putDouble((Double)value);
                                continue block16;
                            }
                            case 7: {
                                if (value instanceof BigInteger) {
                                    bufferManager.putLong(((BigInteger)value).longValue());
                                    continue block16;
                                }
                                bufferManager.putLong((Long)value);
                                continue block16;
                            }
                            case 11: {
                                FGBWriteDriver.writeString(value.toString(), bufferManager);
                                continue block16;
                            }
                            case 13: {
                                if (value instanceof ZonedDateTime) {
                                    String iso8601Date = ((ZonedDateTime)value).format(DateTimeFormatter.ISO_INSTANT);
                                    FGBWriteDriver.writeString(iso8601Date, bufferManager);
                                    continue block16;
                                }
                                throw new RuntimeException("Cannot handle type " + value.getClass().getName() + " with " + ColumnType.names[column.type]);
                            }
                            default: {
                                throw new RuntimeException("Cannot handle type " + value.getClass().getName() + " with " + ColumnType.names[column.type]);
                            }
                        }
                    }
                }
                catch (BufferOverflowException ex) {
                    bufferManager = ByteBuffer.allocate(bufferManager.capacity() * 2);
                    bufferManager.order(ByteOrder.LITTLE_ENDIAN);
                    continue;
                }
                break;
            }
            int propertiesOffset = 0;
            if (bufferManager.position() > 0) {
                bufferManager.flip();
                propertiesOffset = Feature.createPropertiesVector((FlatBufferBuilder)bufferBuilder, (ByteBuffer)bufferManager);
                bufferManager.clear();
            }
            int geometryOffset = 0;
            Geometry geom = (Geometry)rs.getObject(geometryColumn);
            if (geom != null) {
                geometryOffset = GeometryConversions.serialize(bufferBuilder, geom, header.geometryType);
            }
            int featureOffset = Feature.createFeature((FlatBufferBuilder)bufferBuilder, (int)geometryOffset, (int)propertiesOffset, (int)0);
            if (envelopes != null) {
                PackedRTree.FeatureItem featureItem = new PackedRTree.FeatureItem();
                Envelope geomEnvelope = geom != null && !geom.isEmpty() ? geom.getEnvelopeInternal() : new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                featureItem.nodeItem = new NodeItem(geomEnvelope.getMinX(), geomEnvelope.getMinY(), geomEnvelope.getMaxX(), geomEnvelope.getMaxY(), featureAddressPointer);
                envelopes.add(featureItem);
            }
            bufferBuilder.finishSizePrefixed(featureOffset);
            byte[] featureData = bufferBuilder.sizedByteArray();
            featureAddressPointer += (long)featureData.length;
            outputStream.write(featureData);
            bufferBuilder.clear();
            copyProgress.endStep();
        }
        if (envelopes != null) {
            NodeItem extend = new NodeItem(0L);
            envelopes.forEach(x -> extend.expand(x.nodeItem));
            PackedRTree.hilbertSort(envelopes, (NodeItem)extend);
            PackedRTree packedRTree = new PackedRTree(Lists.reverse(envelopes), this.packedRTreeNodeSize);
            FileChannel fileChannel = outputStream.getChannel();
            fileChannel.position(endHeaderPosition);
            packedRTree.write((OutputStream)outputStream);
        }
        return "";
    }

    private HeaderMeta writeHeader(FileOutputStream outputStream, String fileName, FlatBufferBuilder bufferBuilder, long rowCount, String geometryType, int srid, ResultSetMetaData metadata) throws SQLException, IOException {
        outputStream.write(Constants.MAGIC_BYTES);
        ArrayList<ColumnMeta> columns = new ArrayList<ColumnMeta>();
        int columnCount = metadata.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String typeName = metadata.getColumnTypeName(i);
            if (metadata.getColumnTypeName(i).toLowerCase().startsWith("geometry")) continue;
            ColumnMeta column = new ColumnMeta();
            column.name = metadata.getColumnName(i);
            column.type = this.columnType(metadata.getColumnType(i), typeName);
            column.width = metadata.getPrecision(i);
            column.scale = metadata.getScale(i);
            column.precision = metadata.getPrecision(i);
            columns.add(column);
        }
        HeaderMeta headerMeta = new HeaderMeta();
        headerMeta.name = fileName;
        headerMeta.featuresCount = rowCount;
        headerMeta.geometryType = this.geometryType(geometryType);
        headerMeta.columns = columns;
        headerMeta.srid = srid;
        headerMeta.indexNodeSize = this.createIndex ? (int)this.packedRTreeNodeSize : 0;
        HeaderMeta.write((HeaderMeta)headerMeta, (OutputStream)outputStream, (FlatBufferBuilder)bufferBuilder);
        bufferBuilder.clear();
        return headerMeta;
    }

    private byte geometryType(String geometryTypeName) throws SQLException {
        switch (geometryTypeName) {
            case "POINT": {
                return 1;
            }
            case "LINESTRING": {
                return 2;
            }
            case "POLYGON": {
                return 3;
            }
            case "MULTIPOINT": {
                return 4;
            }
            case "MULTILINESTRING": {
                return 5;
            }
            case "MULTIPOLYGON": {
                return 6;
            }
            case "GEOMETRYCOLLECTION": {
                return 7;
            }
            case "GEOMETRY": {
                return 0;
            }
        }
        throw new RuntimeException("SQL type not supported : " + geometryTypeName);
    }

    private byte columnType(int sqlTypeId, String sqlType) throws SQLException {
        switch (sqlTypeId) {
            case -7: 
            case 16: {
                return 2;
            }
            case 91: {
                return 13;
            }
            case 2: 
            case 3: 
            case 8: {
                return 10;
            }
            case 6: 
            case 7: {
                return 9;
            }
            case 4: {
                return 5;
            }
            case -5: {
                return 7;
            }
            case -6: 
            case 5: {
                return 3;
            }
            case -15: 
            case 1: 
            case 12: {
                return 11;
            }
        }
        throw new RuntimeException("SQL type not supported : " + sqlType);
    }
}

