/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.word;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.bytecode.BridgeMethodUtils;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.XorNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.TypePlugin;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.LogicCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.java.ValueCompareAndSwapNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.word.Word;
import jdk.graal.compiler.word.WordCastNode;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.impl.WordFactoryOperation;

public class WordOperationPlugin
implements NodePlugin,
TypePlugin,
InlineInvokePlugin {
    protected final WordTypes wordTypes;
    protected final JavaKind wordKind;
    private final BarrierSet barrierSet;
    protected final SnippetReflectionProvider snippetReflection;
    protected final ConstantReflectionProvider constantReflection;

    public WordOperationPlugin(SnippetReflectionProvider snippetReflection, ConstantReflectionProvider constantReflection, WordTypes wordTypes, BarrierSet barrierSet) {
        this.constantReflection = constantReflection;
        this.snippetReflection = snippetReflection;
        this.wordTypes = wordTypes;
        this.wordKind = wordTypes.getWordKind();
        this.barrierSet = barrierSet;
        assert (barrierSet != null);
    }

    @Override
    public boolean canChangeStackKind(GraphBuilderContext b) {
        return true;
    }

    @Override
    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (!this.wordTypes.isWordOperation(method)) {
            return false;
        }
        this.processWordOperation(b, args, this.wordTypes.getWordOperation(method, b.getMethod().getDeclaringClass()));
        return true;
    }

    @Override
    public StampPair interceptType(GraphBuilderTool b, JavaType declaredType, boolean nonNull) {
        Stamp wordStamp = null;
        if (declaredType instanceof ResolvedJavaType) {
            ResolvedJavaType resolved = (ResolvedJavaType)declaredType;
            if (this.wordTypes.isWord((JavaType)resolved)) {
                wordStamp = this.wordTypes.getWordStamp(resolved);
            } else if (resolved.isArray() && this.wordTypes.isWord((JavaType)resolved.getElementalType())) {
                TypeReference trusted = TypeReference.createTrustedWithoutAssumptions(resolved);
                wordStamp = StampFactory.object(trusted, nonNull);
            }
        }
        if (wordStamp != null) {
            return StampPair.createSingle(wordStamp);
        }
        return null;
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
        if (this.wordTypes.isWord(invoke.asNode())) {
            invoke.asNode().setStamp(this.wordTypes.getWordStamp(StampTool.typeOrNull(invoke.asNode())));
        }
    }

    @Override
    public boolean handleLoadField(GraphBuilderContext b, ValueNode receiver, ResolvedJavaField field) {
        StampPair wordStamp = this.interceptType(b, field.getType(), false);
        if (wordStamp != null) {
            LoadFieldNode loadFieldNode = LoadFieldNode.createOverrideStamp(wordStamp, receiver, field);
            b.addPush(field.getJavaKind(), loadFieldNode);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField staticField) {
        return this.handleLoadField(b, null, staticField);
    }

    @Override
    public boolean handleLoadIndexed(GraphBuilderContext b, ValueNode array, ValueNode index, GuardingNode boundsCheck, JavaKind elementKind) {
        ResolvedJavaType arrayType = StampTool.typeOrNull(array);
        if (arrayType != null && this.wordTypes.isWord((JavaType)arrayType.getComponentType())) {
            assert (elementKind == JavaKind.Object) : Assertions.errorMessage(array, index, boundsCheck, elementKind);
            b.addPush(elementKind, this.createLoadIndexedNode(array, index, boundsCheck));
            return true;
        }
        return false;
    }

    protected LoadIndexedNode createLoadIndexedNode(ValueNode array, ValueNode index, GuardingNode boundsCheck) {
        return new LoadIndexedNode(null, array, index, boundsCheck, this.wordKind);
    }

    @Override
    public boolean handleStoreField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field, ValueNode value) {
        if (field.getJavaKind() == JavaKind.Object) {
            boolean isWordValue;
            boolean isWordField = this.wordTypes.isWord(field.getType());
            boolean bl = isWordValue = value.getStackKind() == this.wordKind;
            if (isWordField && !isWordValue) {
                throw WordOperationPlugin.bailout(b, "Cannot store a non-word value into a word field: " + field.format("%H.%n"));
            }
            if (!isWordField && isWordValue) {
                throw WordOperationPlugin.bailout(b, "Cannot store a word value into a non-word field: " + field.format("%H.%n"));
            }
        }
        return false;
    }

    @Override
    public boolean handleStoreStaticField(GraphBuilderContext b, ResolvedJavaField field, ValueNode value) {
        return this.handleStoreField(b, null, field, value);
    }

    @Override
    public boolean handleStoreIndexed(GraphBuilderContext b, ValueNode array, ValueNode index, GuardingNode boundsCheck, GuardingNode storeCheck, JavaKind elementKind, ValueNode value) {
        ResolvedJavaType arrayType = StampTool.typeOrNull(array);
        if (arrayType != null && this.wordTypes.isWord((JavaType)arrayType.getComponentType())) {
            assert (elementKind == JavaKind.Object) : Assertions.errorMessage(array, index, boundsCheck, storeCheck, elementKind, value);
            if (value.getStackKind() != this.wordKind) {
                throw WordOperationPlugin.bailout(b, "Cannot store a non-word value into a word array: " + arrayType.toJavaName(true));
            }
            GraalError.guarantee(storeCheck == null, "Word array stores are primitive stores and therefore do not require a store check");
            b.add(this.createStoreIndexedNode(array, index, boundsCheck, value));
            return true;
        }
        if (elementKind == JavaKind.Object && value.getStackKind() == this.wordKind) {
            throw WordOperationPlugin.bailout(b, "Cannot store a word value into a non-word array: " + arrayType.toJavaName(true));
        }
        return false;
    }

    protected StoreIndexedNode createStoreIndexedNode(ValueNode array, ValueNode index, GuardingNode boundsCheck, ValueNode value) {
        return new StoreIndexedNode(array, index, boundsCheck, null, this.wordKind, value);
    }

    @Override
    public boolean handleCheckCast(GraphBuilderContext b, ValueNode object, ResolvedJavaType type, JavaTypeProfile profile) {
        if (!this.wordTypes.isWord((JavaType)type)) {
            if (object.getStackKind() != JavaKind.Object) {
                throw WordOperationPlugin.bailout(b, "Cannot cast a word value to a non-word type: " + type.toJavaName(true));
            }
            return false;
        }
        if (object.getStackKind() != this.wordKind) {
            throw WordOperationPlugin.bailout(b, "Cannot cast a non-word value to a word type: " + type.toJavaName(true));
        }
        b.push(JavaKind.Object, object);
        return true;
    }

    @Override
    public boolean handleInstanceOf(GraphBuilderContext b, ValueNode object, ResolvedJavaType type, JavaTypeProfile profile) {
        if (this.wordTypes.isWord((JavaType)type)) {
            throw WordOperationPlugin.bailout(b, "Cannot use instanceof for word a type: " + type.toJavaName(true));
        }
        if (object.getStackKind() != JavaKind.Object) {
            throw WordOperationPlugin.bailout(b, "Cannot use instanceof on a word value: " + type.toJavaName(true));
        }
        return false;
    }

    protected void processWordOperation(GraphBuilderContext b, ValueNode[] args, ResolvedJavaMethod wordMethod) throws GraalError {
        Word.Operation operation;
        JavaKind returnKind = wordMethod.getSignature().getReturnKind();
        WordFactoryOperation factoryOperation = BridgeMethodUtils.getAnnotation(WordFactoryOperation.class, wordMethod);
        if (factoryOperation != null) {
            switch (factoryOperation.opcode()) {
                case ZERO: {
                    assert (NumUtil.assertArrayLength(args, 0));
                    b.addPush(returnKind, ConstantNode.forIntegerKind(this.wordKind, 0L));
                    return;
                }
                case FROM_UNSIGNED: {
                    assert (NumUtil.assertArrayLength(args, 1));
                    b.push(returnKind, this.fromUnsigned(b, args[0]));
                    return;
                }
                case FROM_SIGNED: {
                    assert (NumUtil.assertArrayLength(args, 1));
                    b.push(returnKind, this.fromSigned(b, args[0]));
                    return;
                }
            }
        }
        if ((operation = BridgeMethodUtils.getAnnotation(Word.Operation.class, wordMethod)) == null) {
            throw WordOperationPlugin.bailout(b, "Cannot call method on a word value: " + wordMethod.format("%H.%n(%p)"));
        }
        switch (operation.opcode()) {
            case NODE_CLASS: 
            case INTEGER_DIVISION_NODE_CLASS: {
                assert (NumUtil.assertArrayLength(args, 2));
                ValueNode left = args[0];
                ValueNode right = operation.rightOperandIsInt() ? this.toUnsigned(b, args[1], JavaKind.Int) : this.fromSigned(b, args[1]);
                b.addPush(returnKind, WordOperationPlugin.createBinaryNodeInstance(b, operation.node(), left, right, operation.opcode() == Word.Opcode.INTEGER_DIVISION_NODE_CLASS));
                break;
            }
            case COMPARISON: {
                assert (NumUtil.assertArrayLength(args, 2));
                b.push(returnKind, this.comparisonOp(b, operation.condition(), args[0], this.fromSigned(b, args[1])));
                break;
            }
            case IS_NULL: {
                assert (NumUtil.assertArrayLength(args, 1));
                b.push(returnKind, this.comparisonOp(b, Condition.EQ, args[0], ConstantNode.forIntegerKind(this.wordKind, 0L)));
                break;
            }
            case IS_NON_NULL: {
                assert (NumUtil.assertArrayLength(args, 1));
                b.push(returnKind, this.comparisonOp(b, Condition.NE, args[0], ConstantNode.forIntegerKind(this.wordKind, 0L)));
                break;
            }
            case NOT: {
                assert (NumUtil.assertArrayLength(args, 1));
                b.addPush(returnKind, new XorNode(args[0], b.add(ConstantNode.forIntegerKind(this.wordKind, -1L))));
                break;
            }
            case READ_POINTER: 
            case READ_OBJECT: 
            case READ_BARRIERED: {
                LocationIdentity location;
                assert (NumUtil.assertArrayLength(args, 2, 3));
                JavaKind readKind = this.wordTypes.asKind(wordMethod.getSignature().getReturnType(wordMethod.getDeclaringClass()));
                AddressNode address = this.makeAddress(b, args[0], args[1]);
                if (args.length == 2) {
                    location = LocationIdentity.any();
                } else {
                    assert (GraphUtil.assertIsConstant(args[2]));
                    location = this.snippetReflection.asObject(LocationIdentity.class, args[2].asJavaConstant());
                    assert (location != null) : this.snippetReflection.asObject(Object.class, args[2].asJavaConstant());
                }
                b.push(returnKind, this.readOp(b, readKind, address, location, operation.opcode()));
                break;
            }
            case READ_POINTER_VOLATILE: 
            case READ_BARRIERED_VOLATILE: {
                LocationIdentity location;
                assert (NumUtil.assertArrayLength(args, 2, 3));
                JavaKind readKind = this.wordTypes.asKind(wordMethod.getSignature().getReturnType(wordMethod.getDeclaringClass()));
                AddressNode address = this.makeAddress(b, args[0], args[1]);
                if (args.length == 2) {
                    location = LocationIdentity.any();
                } else {
                    assert (GraphUtil.assertIsConstant(args[2]));
                    location = this.snippetReflection.asObject(LocationIdentity.class, args[2].asJavaConstant());
                    assert (location != null) : this.snippetReflection.asObject(Object.class, args[2].asJavaConstant());
                }
                b.push(returnKind, this.readVolatileOp(b, readKind, address, location, operation.opcode()));
                break;
            }
            case READ_HEAP: {
                LocationIdentity location;
                assert (NumUtil.assertArrayLength(args, 3, 4));
                JavaKind readKind = this.wordTypes.asKind(wordMethod.getSignature().getReturnType(wordMethod.getDeclaringClass()));
                AddressNode address = this.makeAddress(b, args[0], args[1]);
                BarrierType barrierType = this.snippetReflection.asObject(BarrierType.class, args[2].asJavaConstant());
                if (args.length == 3) {
                    location = LocationIdentity.any();
                } else {
                    assert (GraphUtil.assertIsConstant(args[3]));
                    location = this.snippetReflection.asObject(LocationIdentity.class, args[3].asJavaConstant());
                }
                b.push(returnKind, WordOperationPlugin.readOp(b, readKind, address, location, barrierType, true));
                break;
            }
            case WRITE_POINTER: 
            case WRITE_OBJECT: 
            case WRITE_BARRIERED: 
            case INITIALIZE: 
            case WRITE_POINTER_SIDE_EFFECT_FREE: 
            case WRITE_POINTER_VOLATILE: {
                LocationIdentity location;
                assert (NumUtil.assertArrayLength(args, 3, 4));
                JavaKind writeKind = this.wordTypes.asKind(wordMethod.getSignature().getParameterType(wordMethod.isStatic() ? 2 : 1, wordMethod.getDeclaringClass()));
                AddressNode address = this.makeAddress(b, args[0], args[1]);
                if (args.length == 3) {
                    location = LocationIdentity.any();
                } else {
                    assert (GraphUtil.assertIsConstant(args[3]));
                    location = this.snippetReflection.asObject(LocationIdentity.class, args[3].asJavaConstant());
                }
                this.writeOp(b, writeKind, address, location, args[2], operation.opcode());
                break;
            }
            case TO_RAW_VALUE: {
                assert (NumUtil.assertArrayLength(args, 1));
                b.push(returnKind, this.toUnsigned(b, args[0], JavaKind.Long));
                break;
            }
            case OBJECT_TO_TRACKED: {
                assert (NumUtil.assertArrayLength(args, 1));
                WordCastNode objectToTracked = b.add(WordCastNode.objectToTrackedPointer(args[0], this.wordKind));
                b.push(returnKind, objectToTracked);
                break;
            }
            case OBJECT_TO_UNTRACKED: {
                assert (NumUtil.assertArrayLength(args, 1));
                WordCastNode objectToUntracked = b.add(WordCastNode.objectToUntrackedPointer(args[0], this.wordKind));
                b.push(returnKind, objectToUntracked);
                break;
            }
            case FROM_ADDRESS: {
                assert (NumUtil.assertArrayLength(args, 1));
                WordCastNode addressToWord = b.add(WordCastNode.addressToWord(args[0], this.wordKind));
                b.push(returnKind, addressToWord);
                break;
            }
            case TO_OBJECT: {
                assert (NumUtil.assertArrayLength(args, 1));
                WordCastNode wordToObject = b.add(WordCastNode.wordToObject(args[0], this.wordKind));
                b.push(returnKind, wordToObject);
                break;
            }
            case TO_TYPED_OBJECT: {
                assert (NumUtil.assertArrayLength(args, 3));
                assert (GraphUtil.assertIsConstant(args[1]));
                assert (GraphUtil.assertIsConstant(args[2]));
                ResolvedJavaType type = this.constantReflection.asJavaType((Constant)args[1].asJavaConstant());
                boolean nonNull = args[2].asJavaConstant().asInt() != 0;
                TypeReference trusted = TypeReference.createTrustedWithoutAssumptions(type);
                ObjectStamp stamp = StampFactory.object(trusted, nonNull);
                WordCastNode wordToObjectTyped = b.add(WordCastNode.wordToTypedObject(args[0], stamp));
                b.push(returnKind, wordToObjectTyped);
                break;
            }
            case TO_OBJECT_NON_NULL: {
                assert (NumUtil.assertArrayLength(args, 1));
                WordCastNode wordToObjectNonNull = b.add(WordCastNode.wordToObjectNonNull(args[0], this.wordKind));
                b.push(returnKind, wordToObjectNonNull);
                break;
            }
            case CAS_POINTER: {
                assert (NumUtil.assertArrayLength(args, 5));
                AddressNode address = this.makeAddress(b, args[0], args[1]);
                JavaKind valueKind = this.wordTypes.asKind(wordMethod.getSignature().getParameterType(1, wordMethod.getDeclaringClass()));
                assert (valueKind.equals((Object)this.wordTypes.asKind(wordMethod.getSignature().getParameterType(2, wordMethod.getDeclaringClass())))) : wordMethod.getSignature();
                assert (GraphUtil.assertIsConstant(args[4])) : Arrays.toString(args);
                LocationIdentity location = this.snippetReflection.asObject(LocationIdentity.class, args[4].asJavaConstant());
                JavaType returnType = wordMethod.getSignature().getReturnType(wordMethod.getDeclaringClass());
                b.addPush(returnKind, this.casOp(valueKind, this.wordTypes.asKind(returnType), address, location, args[2], args[3]));
                break;
            }
            default: {
                throw new GraalError("Unknown opcode: %s", new Object[]{operation.opcode()});
            }
        }
    }

    private static ValueNode createBinaryNodeInstance(GraphBuilderContext b, Class<? extends ValueNode> nodeClass, ValueNode left, ValueNode right, boolean isIntegerDivision) {
        try {
            Object[] objectArray;
            Class[] classArray;
            GuardingNode zeroCheck;
            GuardingNode guardingNode = zeroCheck = isIntegerDivision ? b.maybeEmitExplicitDivisionByZeroCheck(right) : null;
            if (isIntegerDivision) {
                Class[] classArray2 = new Class[3];
                classArray2[0] = ValueNode.class;
                classArray2[1] = ValueNode.class;
                classArray = classArray2;
                classArray2[2] = GuardingNode.class;
            } else {
                Class[] classArray3 = new Class[2];
                classArray3[0] = ValueNode.class;
                classArray = classArray3;
                classArray3[1] = ValueNode.class;
            }
            Class[] parameterTypes = classArray;
            Constructor<? extends ValueNode> cons = nodeClass.getDeclaredConstructor(parameterTypes);
            if (isIntegerDivision) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = left;
                objectArray2[1] = right;
                objectArray = objectArray2;
                objectArray2[2] = zeroCheck;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = left;
                objectArray = objectArray3;
                objectArray3[1] = right;
            }
            Object[] initargs = objectArray;
            return cons.newInstance(initargs);
        }
        catch (Throwable ex) {
            throw new GraalError(ex).addContext(nodeClass.getName());
        }
    }

    private ValueNode comparisonOp(GraphBuilderContext graph, Condition condition, ValueNode left, ValueNode right) {
        CompareNode comparison;
        ValueNode b;
        assert (left.getStackKind() == this.wordKind && right.getStackKind() == this.wordKind) : "Stack kind must match " + String.valueOf(left) + " " + String.valueOf(right);
        Condition.CanonicalizedCondition canonical = condition.canonicalize();
        ValueNode a = canonical.mustMirror() ? right : left;
        ValueNode valueNode = b = canonical.mustMirror() ? left : right;
        if (canonical.getCanonicalCondition() == CanonicalCondition.EQ) {
            comparison = new IntegerEqualsNode(a, b);
        } else if (canonical.getCanonicalCondition() == CanonicalCondition.BT) {
            comparison = new IntegerBelowNode(a, b);
        } else {
            assert (canonical.getCanonicalCondition() == CanonicalCondition.LT) : Assertions.errorMessage(new Object[]{canonical.getCanonicalCondition(), condition, left, right});
            comparison = new IntegerLessThanNode(a, b);
        }
        ConstantNode trueValue = graph.add(ConstantNode.forInt(1));
        ConstantNode falseValue = graph.add(ConstantNode.forInt(0));
        if (canonical.mustNegate()) {
            ConstantNode temp = trueValue;
            trueValue = falseValue;
            falseValue = temp;
        }
        return graph.add(new ConditionalNode(graph.add(comparison), trueValue, falseValue));
    }

    protected ValueNode readOp(GraphBuilderContext b, JavaKind readKind, AddressNode address, LocationIdentity location, Word.Opcode op) {
        assert (op == Word.Opcode.READ_POINTER || op == Word.Opcode.READ_OBJECT || op == Word.Opcode.READ_BARRIERED) : op;
        BarrierType barrier = op == Word.Opcode.READ_BARRIERED && readKind.isObject() ? this.barrierSet.readBarrierType(location, address, null) : BarrierType.NONE;
        boolean compressible = op == Word.Opcode.READ_OBJECT || op == Word.Opcode.READ_BARRIERED;
        return WordOperationPlugin.readOp(b, readKind, address, location, barrier, compressible);
    }

    public static ValueNode readOp(GraphBuilderContext b, JavaKind readKind, AddressNode address, LocationIdentity location, BarrierType barrierType, boolean compressible) {
        JavaReadNode read = b.add(new JavaReadNode(readKind, address, location, barrierType, MemoryOrderMode.PLAIN, compressible));
        return read;
    }

    protected ValueNode readVolatileOp(GraphBuilderContext b, JavaKind readKind, AddressNode address, LocationIdentity location, Word.Opcode op) {
        assert (op == Word.Opcode.READ_POINTER_VOLATILE || op == Word.Opcode.READ_BARRIERED_VOLATILE) : op;
        BarrierType barrier = op == Word.Opcode.READ_BARRIERED_VOLATILE && readKind.isObject() ? this.barrierSet.readBarrierType(location, address, null) : BarrierType.NONE;
        boolean compressible = op == Word.Opcode.READ_BARRIERED_VOLATILE;
        JavaReadNode read = b.add(new JavaReadNode(readKind, address, location, barrier, MemoryOrderMode.VOLATILE, compressible));
        return read;
    }

    protected void writeOp(GraphBuilderContext b, JavaKind writeKind, AddressNode address, LocationIdentity location, ValueNode value, Word.Opcode op) {
        assert (op == Word.Opcode.WRITE_POINTER || op == Word.Opcode.WRITE_POINTER_SIDE_EFFECT_FREE || op == Word.Opcode.WRITE_OBJECT || op == Word.Opcode.WRITE_BARRIERED || op == Word.Opcode.INITIALIZE || op == Word.Opcode.WRITE_POINTER_VOLATILE) : op;
        assert (op != Word.Opcode.INITIALIZE || location.isInit()) : "must use init location for initializing";
        BarrierType barrier = op == Word.Opcode.WRITE_BARRIERED ? BarrierType.UNKNOWN : BarrierType.NONE;
        boolean compressible = op == Word.Opcode.WRITE_OBJECT || op == Word.Opcode.WRITE_BARRIERED;
        boolean hasSideEffect = op != Word.Opcode.WRITE_POINTER_SIDE_EFFECT_FREE;
        MemoryOrderMode memoryOrder = op == Word.Opcode.WRITE_POINTER_VOLATILE ? MemoryOrderMode.VOLATILE : MemoryOrderMode.PLAIN;
        b.add(new JavaWriteNode(writeKind, address, location, value, barrier, compressible, hasSideEffect, memoryOrder));
    }

    protected AbstractCompareAndSwapNode casOp(JavaKind writeKind, JavaKind returnKind, AddressNode address, LocationIdentity location, ValueNode expectedValue, ValueNode newValue) {
        boolean isLogic;
        boolean bl = isLogic = returnKind == JavaKind.Boolean;
        assert (isLogic || writeKind == returnKind) : String.valueOf(writeKind) + " != " + String.valueOf(returnKind);
        AbstractCompareAndSwapNode cas = isLogic ? new LogicCompareAndSwapNode(address, expectedValue, newValue, location, BarrierType.NONE, MemoryOrderMode.VOLATILE) : new ValueCompareAndSwapNode(address, expectedValue, newValue, location, BarrierType.NONE, MemoryOrderMode.VOLATILE);
        return cas;
    }

    public AddressNode makeAddress(GraphBuilderContext b, ValueNode base, ValueNode offset) {
        return b.add(new OffsetAddressNode(base, this.fromSigned(b, offset)));
    }

    public ValueNode fromUnsigned(GraphBuilderContext b, ValueNode value) {
        return this.convert(b, value, this.wordKind, true);
    }

    public ValueNode fromSigned(GraphBuilderContext b, ValueNode value) {
        return this.convert(b, value, this.wordKind, false);
    }

    public ValueNode toUnsigned(GraphBuilderContext b, ValueNode value, JavaKind toKind) {
        return this.convert(b, value, toKind, true);
    }

    public ValueNode convert(GraphBuilderContext b, ValueNode value, JavaKind toKind, boolean unsigned) {
        if (value.getStackKind() == toKind) {
            return value;
        }
        if (toKind == JavaKind.Int) {
            assert (value.getStackKind() == JavaKind.Long) : Assertions.errorMessage(value, toKind, unsigned);
            return b.add(new NarrowNode(value, 32));
        }
        assert (toKind == JavaKind.Long) : Assertions.errorMessage(value, toKind, unsigned);
        assert (value.getStackKind() == JavaKind.Int) : Assertions.errorMessage(value, toKind, unsigned);
        if (unsigned) {
            return b.add(new ZeroExtendNode(value, 64));
        }
        return b.add(new SignExtendNode(value, 64));
    }

    private static BailoutException bailout(GraphBuilderContext b, String msg) {
        throw b.bailout(msg + "\nat " + String.valueOf(b.getCode().asStackTraceElement(b.bci())));
    }
}

