/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.word;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.type.NarrowOopStamp;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class WordCastNode
extends FixedWithNextNode
implements LIRLowerable,
Canonicalizable {
    public static final NodeClass<WordCastNode> TYPE = NodeClass.create(WordCastNode.class);
    @Node.Input
    ValueNode input;
    private final boolean trackedPointer;

    public static WordCastNode wordToObject(ValueNode input, JavaKind wordKind) {
        assert (input.getStackKind() == wordKind) : Assertions.errorMessageContext("input", input, "inputKind", input.getStackKind());
        return new WordCastNode(WordCastNode.objectStampFor(input), input);
    }

    public static WordCastNode wordToObjectNonNull(ValueNode input, JavaKind wordKind) {
        assert (input.getStackKind() == wordKind) : Assertions.errorMessageContext("input", input, "inputKind", input.getStackKind());
        return new WordCastNode(StampFactory.objectNonNull(), input);
    }

    public static WordCastNode wordToNarrowObject(ValueNode input, NarrowOopStamp stamp) {
        return new WordCastNode(stamp, input);
    }

    public static WordCastNode wordToTypedObject(ValueNode input, Stamp stamp) {
        return new WordCastNode(stamp, input);
    }

    public static WordCastNode addressToWord(ValueNode input, JavaKind wordKind) {
        Stamp stamp = input.stamp(NodeView.DEFAULT);
        assert (stamp instanceof AbstractPointerStamp) : stamp;
        return new WordCastNode(StampFactory.forKind(wordKind), input);
    }

    public static WordCastNode objectToTrackedPointer(ValueNode input, JavaKind wordKind) {
        Stamp stamp = input.stamp(NodeView.DEFAULT);
        assert (stamp instanceof ObjectStamp) : stamp;
        return new WordCastNode(StampFactory.forKind(wordKind), input);
    }

    public static WordCastNode objectToUntrackedPointer(ValueNode input, JavaKind wordKind) {
        Stamp stamp = input.stamp(NodeView.DEFAULT);
        assert (stamp instanceof ObjectStamp) : stamp;
        return new WordCastNode(StampFactory.forKind(wordKind), input, false);
    }

    public static WordCastNode narrowOopToUntrackedWord(ValueNode input, JavaKind wordKind) {
        Stamp stamp = input.stamp(NodeView.DEFAULT);
        assert (stamp instanceof NarrowOopStamp) : stamp;
        return new WordCastNode(StampFactory.forKind(wordKind), input, false);
    }

    private WordCastNode(Stamp stamp, ValueNode input) {
        this(stamp, input, true);
    }

    protected WordCastNode(Stamp stamp, ValueNode input, boolean trackedPointer) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.input = input;
        this.trackedPointer = trackedPointer;
    }

    public ValueNode getInput() {
        return this.input;
    }

    private static boolean isZeroConstant(ValueNode value) {
        JavaConstant constant = value.asJavaConstant();
        return constant.getJavaKind().isNumericInteger() && constant.asLong() == 0L;
    }

    private static Stamp objectStampFor(ValueNode input) {
        Stamp inputStamp = input.stamp(NodeView.DEFAULT);
        if (inputStamp instanceof AbstractPointerStamp) {
            AbstractPointerStamp pointerStamp = (AbstractPointerStamp)inputStamp;
            if (pointerStamp.alwaysNull()) {
                return StampFactory.alwaysNull();
            }
            if (pointerStamp.nonNull()) {
                return StampFactory.objectNonNull();
            }
        } else {
            if (inputStamp instanceof IntegerStamp && !((IntegerStamp)inputStamp).contains(0L)) {
                return StampFactory.objectNonNull();
            }
            if (input.isConstant() && WordCastNode.isZeroConstant(input)) {
                return StampFactory.alwaysNull();
            }
        }
        return StampFactory.object();
    }

    @Override
    public boolean inferStamp() {
        AbstractPointerStamp objectStamp;
        if (this.stamp instanceof AbstractPointerStamp && !(objectStamp = (AbstractPointerStamp)this.stamp).alwaysNull() && !objectStamp.nonNull()) {
            Stamp newStamp = this.stamp;
            Stamp inputStamp = this.input.stamp(NodeView.DEFAULT);
            if (inputStamp instanceof AbstractPointerStamp) {
                AbstractPointerStamp pointerStamp = (AbstractPointerStamp)inputStamp;
                if (pointerStamp.alwaysNull()) {
                    newStamp = objectStamp.asAlwaysNull();
                } else if (pointerStamp.nonNull()) {
                    newStamp = objectStamp.asNonNull();
                }
            } else if (inputStamp instanceof IntegerStamp && !((IntegerStamp)inputStamp).contains(0L)) {
                newStamp = objectStamp.asNonNull();
            } else if (this.input.isConstant() && WordCastNode.isZeroConstant(this.input)) {
                newStamp = objectStamp.asAlwaysNull();
            }
            return this.updateStamp(newStamp);
        }
        return false;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return this.input;
        }
        assert (!this.stamp.isCompatible(this.input.stamp(NodeView.DEFAULT)));
        if (this.input.isJavaConstant()) {
            if (this.input.asJavaConstant().isNull()) {
                return ConstantNode.forIntegerStamp(this.stamp, 0L);
            }
            if (WordCastNode.isZeroConstant(this.input)) {
                return ConstantNode.forConstant(this.stamp, (Constant)((AbstractPointerStamp)this.stamp).nullConstant(), tool.getMetaAccess());
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        Value value = generator.operand(this.input);
        LIRKind resultKind = generator.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        assert (resultKind.getPlatformKind().getSizeInBytes() == value.getPlatformKind().getSizeInBytes()) : Assertions.errorMessageContext("resultKind", (Object)resultKind, "valueKind", value);
        if (this.trackedPointer && LIRKind.isValue(resultKind) && !LIRKind.isValue(value)) {
            resultKind = value.getValueKind().changeType(resultKind.getPlatformKind());
        }
        if (((Object)((Object)resultKind)).equals(value.getValueKind()) && !(value instanceof ConstantValue)) {
            generator.setResult(this, value);
        } else {
            Variable result = generator.getLIRGeneratorTool().newVariable(resultKind);
            if (this.stamp.equals(StampFactory.object())) {
                generator.getLIRGeneratorTool().emitConvertZeroToNull(result, value);
            } else if (!(this.trackedPointer || ((AbstractPointerStamp)this.input.stamp(NodeView.DEFAULT)).nonNull() || this.input.stamp(NodeView.DEFAULT) instanceof NarrowOopStamp)) {
                generator.getLIRGeneratorTool().emitConvertNullToZero((AllocatableValue)result, (AllocatableValue)value);
            } else {
                result = generator.getLIRGeneratorTool().emitMove(resultKind, value);
            }
            generator.setResult(this, (Value)result);
        }
    }
}

