/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.Iterator;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.virtual.phases.ea.EffectsBlockState;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.word.LocationIdentity;

public class ReadEliminationBlockState
extends EffectsBlockState<ReadEliminationBlockState> {
    final EconomicMap<CacheEntry<?>, ValueNode> readCache;

    public ReadEliminationBlockState() {
        this.readCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
    }

    public ReadEliminationBlockState(ReadEliminationBlockState other) {
        super(other);
        this.readCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT, other.readCache);
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.readCache);
    }

    @Override
    public boolean equivalentTo(ReadEliminationBlockState other) {
        return ReadEliminationBlockState.isSubMapOf(this.readCache, other.readCache);
    }

    public void addCacheEntry(CacheEntry<?> identifier, ValueNode value) {
        this.readCache.put(identifier, (Object)value);
    }

    public ValueNode getCacheEntry(CacheEntry<?> identifier) {
        return (ValueNode)this.readCache.get(identifier);
    }

    public void killReadCache(Node kill, LocationIdentity identity, ValueNode index, ValueNode array) {
        if (identity.isAny()) {
            Iterator iterator = this.readCache.getKeys().iterator();
            while (iterator.hasNext()) {
                CacheEntry entry = (CacheEntry)iterator.next();
                if (!entry.getIdentity().isMutable()) continue;
                iterator.remove();
            }
            return;
        }
        Iterator iterator = this.readCache.getKeys().iterator();
        while (iterator.hasNext()) {
            CacheEntry entry = (CacheEntry)iterator.next();
            if (!entry.conflicts(identity, index, array)) continue;
            iterator.remove();
        }
    }

    public EconomicMap<CacheEntry<?>, ValueNode> getReadCache() {
        return this.readCache;
    }

    public static abstract class CacheEntry<T> {
        public final ValueNode object;
        public final T identity;

        protected CacheEntry(ValueNode object, T identity) {
            this.object = object;
            this.identity = identity;
        }

        public abstract CacheEntry<T> duplicateWithObject(ValueNode var1);

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheEntry)) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            return this.identity.equals(other.identity) && this.object == other.object;
        }

        public int hashCode() {
            int result = 31 + (this.identity == null ? 0 : this.identity.hashCode());
            return 31 * result + (this.object == null ? 0 : System.identityHashCode(this.object));
        }

        public String toString() {
            return String.valueOf(this.object) + ":" + String.valueOf(this.identity);
        }

        public abstract boolean conflicts(LocationIdentity var1, ValueNode var2, ValueNode var3);

        public abstract LocationIdentity getIdentity();
    }

    public static final class UnsafeLoadCacheEntry
    extends CacheEntry<ValueNode> {
        private final LocationIdentity locationIdentity;
        private final JavaKind kind;

        public UnsafeLoadCacheEntry(ValueNode object, ValueNode location, LocationIdentity locationIdentity, JavaKind kind) {
            super(object, location);
            assert (locationIdentity != null);
            this.locationIdentity = locationIdentity;
            this.kind = kind;
        }

        @Override
        public CacheEntry<ValueNode> duplicateWithObject(ValueNode newObject) {
            return new UnsafeLoadCacheEntry(newObject, (ValueNode)this.identity, this.locationIdentity, this.kind);
        }

        @Override
        public boolean conflicts(LocationIdentity other, ValueNode index, ValueNode array) {
            return this.locationIdentity.equals(other);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.locationIdentity.hashCode();
            result = 31 * result + this.kind.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof UnsafeLoadCacheEntry) {
                UnsafeLoadCacheEntry other = (UnsafeLoadCacheEntry)obj;
                return super.equals(other) && this.locationIdentity.equals(other.locationIdentity) && this.kind == other.kind;
            }
            return false;
        }

        @Override
        public LocationIdentity getIdentity() {
            return this.locationIdentity;
        }

        @Override
        public String toString() {
            return "UNSAFE:" + super.toString() + " location:" + String.valueOf(this.locationIdentity) + " (" + String.valueOf(this.kind) + ")";
        }
    }

    public static final class LoadCacheEntry
    extends CacheEntry<LocationIdentity> {
        public LoadCacheEntry(ValueNode object, LocationIdentity identity) {
            super(object, identity);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof LoadCacheEntry) {
                return super.equals(obj);
            }
            return false;
        }

        @Override
        public CacheEntry<LocationIdentity> duplicateWithObject(ValueNode newObject) {
            return new LoadCacheEntry(newObject, (LocationIdentity)this.identity);
        }

        @Override
        public boolean conflicts(LocationIdentity other, ValueNode index, ValueNode array) {
            return ((LocationIdentity)this.identity).equals(other);
        }

        @Override
        public LocationIdentity getIdentity() {
            return (LocationIdentity)this.identity;
        }
    }
}

