/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MultiMemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.virtual.phases.ea.EffectsClosure;
import jdk.graal.compiler.virtual.phases.ea.GraphEffectList;
import jdk.graal.compiler.virtual.phases.ea.ObjectState;
import jdk.graal.compiler.virtual.phases.ea.PEReadEliminationBlockState;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapeClosure;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.word.LocationIdentity;

public final class PEReadEliminationClosure
extends PartialEscapeClosure<PEReadEliminationBlockState> {
    private static final EnumMap<JavaKind, LocationIdentity> UNBOX_LOCATIONS = new EnumMap(JavaKind.class);

    public PEReadEliminationClosure(StructuredGraph.ScheduleResult schedule, CoreProviders providers) {
        super(schedule, providers);
    }

    @Override
    protected PEReadEliminationBlockState getInitialState() {
        return new PEReadEliminationBlockState(this.tool.getOptions(), this.tool.getDebug());
    }

    @Override
    protected boolean processNode(Node node, PEReadEliminationBlockState state, GraphEffectList effects, FixedWithNextNode lastFixedNode) {
        if (super.processNode(node, state, effects, lastFixedNode)) {
            return true;
        }
        if (this.currentMode != EffectsClosure.EffectsClosureMode.REGULAR_VIRTUALIZATION) {
            return false;
        }
        boolean deleted = false;
        if (node instanceof LoadFieldNode) {
            deleted = this.processLoadField((LoadFieldNode)node, state, effects);
        } else if (node instanceof StoreFieldNode) {
            deleted = this.processStoreField((StoreFieldNode)node, state, effects);
        } else if (node instanceof LoadIndexedNode) {
            deleted = this.processLoadIndexed((LoadIndexedNode)node, state, effects);
        } else if (node instanceof StoreIndexedNode) {
            deleted = this.processStoreIndexed((StoreIndexedNode)node, state, effects);
        } else if (node instanceof ArrayLengthNode) {
            deleted = this.processArrayLength((ArrayLengthNode)node, state, effects);
        } else if (node instanceof UnboxNode) {
            deleted = this.processUnbox((UnboxNode)node, state, effects);
        } else if (node instanceof RawLoadNode) {
            deleted = this.processUnsafeLoad((RawLoadNode)node, state, effects);
        } else if (node instanceof RawStoreNode) {
            deleted = this.processUnsafeStore((RawStoreNode)node, state, effects);
        } else if (MemoryKill.isSingleMemoryKill(node)) {
            COUNTER_MEMORYCHECKPOINT.increment(node.getDebug());
            LocationIdentity identity = ((SingleMemoryKill)((Object)node)).getKilledLocationIdentity();
            PEReadEliminationClosure.processIdentity(state, identity);
        } else if (MemoryKill.isMultiMemoryKill(node)) {
            COUNTER_MEMORYCHECKPOINT.increment(node.getDebug());
            for (LocationIdentity identity : ((MultiMemoryKill)((Object)node)).getKilledLocationIdentities()) {
                PEReadEliminationClosure.processIdentity(state, identity);
            }
        }
        if (deleted) {
            effects.addLog(this.cfg.graph.getOptimizationLog(), optimizationLog -> optimizationLog.withProperty("deletedNodeClass", node.getNodeClass().shortName()).report(this.getClass(), "ReadElimination", node));
        }
        return deleted;
    }

    private boolean processStore(FixedNode store, ValueNode object, LocationIdentity identity, int index, JavaKind accessKind, boolean overflowAccess, ValueNode value, PEReadEliminationBlockState state, GraphEffectList effects) {
        ValueNode unproxiedObject = GraphUtil.unproxify(object);
        ValueNode cachedValue = state.getReadCache(object, identity, index, accessKind, this);
        ValueNode finalValue = this.getScalarAlias(value);
        boolean result = false;
        if (GraphUtil.unproxify(finalValue) == GraphUtil.unproxify(cachedValue)) {
            effects.deleteNode(store);
            result = true;
        }
        state.killReadCache(identity, index);
        state.addReadCache(unproxiedObject, identity, index, accessKind, overflowAccess, finalValue, this);
        return result;
    }

    private boolean processLoad(FixedNode load, ValueNode object, LocationIdentity identity, int index, JavaKind kind, PEReadEliminationBlockState state, GraphEffectList effects) {
        ValueNode unproxiedObject = GraphUtil.unproxify(object);
        ValueNode cachedValue = state.getReadCache(unproxiedObject, identity, index, kind, this);
        if (cachedValue != null) {
            effects.replaceAtUsages(load, cachedValue, load);
            this.addScalarAlias(load, cachedValue);
            return true;
        }
        state.addReadCache(unproxiedObject, identity, index, kind, false, load, this);
        return false;
    }

    private static boolean isOverflowAccess(JavaKind accessKind, JavaKind declaredKind) {
        if (accessKind == declaredKind) {
            return false;
        }
        if (accessKind == JavaKind.Object) {
            switch (declaredKind) {
                case Object: 
                case Double: 
                case Long: {
                    return false;
                }
            }
            return true;
        }
        assert (accessKind.isPrimitive()) : "Illegal access kind";
        return declaredKind.isPrimitive() ? accessKind.getBitCount() > declaredKind.getBitCount() : true;
    }

    private boolean processUnsafeLoad(RawLoadNode load, PEReadEliminationBlockState state, GraphEffectList effects) {
        ResolvedJavaType type;
        if (load.ordersMemoryAccesses()) {
            state.killReadCache();
            return false;
        }
        if (load.offset().isConstant() && (type = StampTool.typeOrNull(load.object())) != null && type.isArray()) {
            JavaKind accessKind = load.accessKind();
            JavaKind componentKind = type.getComponentType().getJavaKind();
            long offset = load.offset().asJavaConstant().asLong();
            int index = VirtualArrayNode.entryIndexForOffset(this.tool.getMetaAccess(), offset, accessKind, type.getComponentType(), Integer.MAX_VALUE);
            if (index >= 0) {
                ValueNode object = GraphUtil.unproxify(load.object());
                LocationIdentity location = NamedLocationIdentity.getArrayLocation(componentKind);
                ValueNode cachedValue = state.getReadCache(object, location, index, accessKind, this);
                assert (cachedValue == null || load.stamp(NodeView.DEFAULT).isCompatible(cachedValue.stamp(NodeView.DEFAULT))) : "The RawLoadNode's stamp is not compatible with the cached value.";
                if (cachedValue != null) {
                    effects.replaceAtUsages(load, cachedValue, load);
                    this.addScalarAlias(load, cachedValue);
                    return true;
                }
                state.addReadCache(object, location, index, accessKind, PEReadEliminationClosure.isOverflowAccess(accessKind, componentKind), load, this);
            }
        }
        return false;
    }

    private boolean processUnsafeStore(RawStoreNode store, PEReadEliminationBlockState state, GraphEffectList effects) {
        if (store.ordersMemoryAccesses()) {
            state.killReadCache();
            return false;
        }
        ResolvedJavaType type = StampTool.typeOrNull(store.object());
        if (type != null && type.isArray()) {
            JavaKind accessKind = store.accessKind();
            JavaKind componentKind = type.getComponentType().getJavaKind();
            LocationIdentity location = NamedLocationIdentity.getArrayLocation(componentKind);
            if (store.offset().isConstant()) {
                int index;
                long offset = store.offset().asJavaConstant().asLong();
                boolean overflowAccess = PEReadEliminationClosure.isOverflowAccess(accessKind, componentKind);
                int n = index = overflowAccess ? -1 : VirtualArrayNode.entryIndexForOffset(this.tool.getMetaAccess(), offset, accessKind, type.getComponentType(), Integer.MAX_VALUE);
                if (index != -1) {
                    return this.processStore(store, store.object(), location, index, accessKind, overflowAccess, store.value(), state, effects);
                }
                state.killReadCache(location, index);
            } else {
                PEReadEliminationClosure.processIdentity(state, location);
            }
        } else {
            state.killReadCache();
        }
        return false;
    }

    private boolean processArrayLength(ArrayLengthNode length, PEReadEliminationBlockState state, GraphEffectList effects) {
        return this.processLoad(length, length.array(), NamedLocationIdentity.ARRAY_LENGTH_LOCATION, -1, JavaKind.Int, state, effects);
    }

    private boolean processStoreField(StoreFieldNode store, PEReadEliminationBlockState state, GraphEffectList effects) {
        if (store.ordersMemoryAccesses()) {
            state.killReadCache();
            return false;
        }
        JavaKind kind = store.field().getJavaKind();
        return this.processStore(store, store.object(), new FieldLocationIdentity(store.field()), -1, kind, false, store.value(), state, effects);
    }

    private boolean processLoadField(LoadFieldNode load, PEReadEliminationBlockState state, GraphEffectList effects) {
        if (load.ordersMemoryAccesses()) {
            state.killReadCache();
            return false;
        }
        return this.processLoad(load, load.object(), new FieldLocationIdentity(load.field()), -1, load.field().getJavaKind(), state, effects);
    }

    private boolean processStoreIndexed(StoreIndexedNode store, PEReadEliminationBlockState state, GraphEffectList effects) {
        int index = store.index().isConstant() ? ((JavaConstant)store.index().asConstant()).asInt() : -1;
        JavaKind elementKind = store.elementKind();
        LocationIdentity arrayLocation = NamedLocationIdentity.getArrayLocation(elementKind);
        if (index != -1) {
            return this.processStore(store, store.array(), arrayLocation, index, elementKind, false, store.value(), state, effects);
        }
        state.killReadCache(arrayLocation, -1);
        return false;
    }

    private boolean processLoadIndexed(LoadIndexedNode load, PEReadEliminationBlockState state, GraphEffectList effects) {
        if (load.index().isConstant()) {
            int index = ((JavaConstant)load.index().asConstant()).asInt();
            JavaKind elementKind = load.elementKind();
            LocationIdentity arrayLocation = NamedLocationIdentity.getArrayLocation(elementKind);
            return this.processLoad(load, load.array(), arrayLocation, index, elementKind, state, effects);
        }
        return false;
    }

    private boolean processUnbox(UnboxNode unbox, PEReadEliminationBlockState state, GraphEffectList effects) {
        return this.processLoad(unbox, unbox.getValue(), UNBOX_LOCATIONS.get(unbox.getBoxingKind()), -1, unbox.getBoxingKind(), state, effects);
    }

    private static void processIdentity(PEReadEliminationBlockState state, LocationIdentity identity) {
        if (identity.isAny()) {
            state.killReadCache();
        } else {
            state.killReadCache(identity, -1);
        }
    }

    @Override
    protected void processInitialLoopState(CFGLoop<HIRBlock> loop, PEReadEliminationBlockState initialState) {
        super.processInitialLoopState(loop, initialState);
        if (!initialState.getReadCache().isEmpty()) {
            EconomicMap firstValueSet = null;
            for (PhiNode phi : ((LoopBeginNode)loop.getHeader().getBeginNode()).phis()) {
                ValueNode firstValue = phi.valueAt(0);
                if (firstValue == null || !phi.getStackKind().isObject()) continue;
                ValueNode unproxified = GraphUtil.unproxify(firstValue);
                if (firstValueSet == null) {
                    firstValueSet = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
                }
                Pair pair = Pair.create((Object)unproxified, (Object)firstValueSet.get((Object)unproxified));
                firstValueSet.put((Object)unproxified, (Object)pair);
            }
            if (firstValueSet != null) {
                PEReadEliminationBlockState.ReadCacheEntry[] entries = new PEReadEliminationBlockState.ReadCacheEntry[initialState.getReadCache().size()];
                int z = 0;
                for (PEReadEliminationBlockState.ReadCacheEntry entry : initialState.getReadCache().getKeys()) {
                    entries[z++] = entry;
                }
                for (PEReadEliminationBlockState.ReadCacheEntry entry : entries) {
                    ValueNode object = entry.object;
                    if (object == null) continue;
                    for (Pair pair = (Pair)firstValueSet.get((Object)object); pair != null; pair = (Pair)pair.getRight()) {
                        initialState.addReadCache((ValueNode)pair.getLeft(), entry.identity, entry.index, entry.kind, entry.overflowAccess, (ValueNode)initialState.getReadCache().get((Object)entry), this);
                    }
                }
            }
        }
    }

    @Override
    protected void processLoopExit(LoopExitNode exitNode, PEReadEliminationBlockState initialState, PEReadEliminationBlockState exitState, GraphEffectList effects) {
        super.processLoopExit(exitNode, initialState, exitState, effects);
        if (exitNode.graph().isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            MapCursor entry = exitState.getReadCache().getEntries();
            while (entry.advance()) {
                if (initialState.getReadCache().get((Object)((PEReadEliminationBlockState.ReadCacheEntry)entry.getKey())) == entry.getValue()) continue;
                ValueNode value = exitState.getReadCache(((PEReadEliminationBlockState.ReadCacheEntry)entry.getKey()).object, ((PEReadEliminationBlockState.ReadCacheEntry)entry.getKey()).identity, ((PEReadEliminationBlockState.ReadCacheEntry)entry.getKey()).index, ((PEReadEliminationBlockState.ReadCacheEntry)entry.getKey()).kind, this);
                assert (value != null) : "Got null from read cache, entry's value:" + String.valueOf(entry.getValue());
                if (value instanceof ProxyNode && ((ProxyNode)value).proxyPoint() == exitNode) continue;
                ValueProxyNode proxy = new ValueProxyNode(value, exitNode);
                effects.addFloatingNode(proxy, "readCacheProxy");
                exitState.getReadCache().put((Object)((PEReadEliminationBlockState.ReadCacheEntry)entry.getKey()), (Object)proxy);
            }
        }
    }

    @Override
    protected PEReadEliminationBlockState cloneState(PEReadEliminationBlockState other) {
        return new PEReadEliminationBlockState(other);
    }

    @Override
    protected PartialEscapeClosure.MergeProcessor createMergeProcessor(HIRBlock merge) {
        return new ReadEliminationMergeProcessor(merge);
    }

    @Override
    protected void processKilledLoopLocations(CFGLoop<HIRBlock> loop, PEReadEliminationBlockState initialState, PEReadEliminationBlockState mergedStates) {
        assert (initialState != null);
        assert (mergedStates != null);
        if (initialState.readCache.size() > 0) {
            EffectsClosure.LoopKillCache loopKilledLocations = (EffectsClosure.LoopKillCache)this.loopLocationKillCache.get(loop);
            if (loopKilledLocations == null) {
                loopKilledLocations = new EffectsClosure.LoopKillCache(1);
                this.loopLocationKillCache.put(loop, (Object)loopKilledLocations);
            } else {
                AbstractBeginNode beginNode = loop.getHeader().getBeginNode();
                OptionValues options = beginNode.getOptions();
                if (loopKilledLocations.visits() > GraalOptions.ReadEliminationMaxLoopVisits.getValue(options)) {
                    loopKilledLocations.setKillsAll();
                } else {
                    EconomicSet forwardEndLiveLocations = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
                    for (PEReadEliminationBlockState.ReadCacheEntry entry : initialState.readCache.getKeys()) {
                        forwardEndLiveLocations.add((Object)entry.identity);
                    }
                    for (PEReadEliminationBlockState.ReadCacheEntry entry : mergedStates.readCache.getKeys()) {
                        forwardEndLiveLocations.remove((Object)entry.identity);
                    }
                    for (LocationIdentity location : forwardEndLiveLocations) {
                        loopKilledLocations.rememberLoopKilledLocation(location);
                    }
                    if (this.debug.isLogEnabled()) {
                        this.debug.log("[Early Read Elimination] Setting loop killed locations of loop at node %s with %s", (Object)beginNode, (Object)forwardEndLiveLocations);
                    }
                }
                loopKilledLocations.visited();
            }
        }
    }

    @Override
    protected PEReadEliminationBlockState stripKilledLoopLocations(CFGLoop<HIRBlock> loop, PEReadEliminationBlockState originalInitialState) {
        PEReadEliminationBlockState initialState = super.stripKilledLoopLocations(loop, originalInitialState);
        EffectsClosure.LoopKillCache loopKilledLocations = (EffectsClosure.LoopKillCache)this.loopLocationKillCache.get(loop);
        if (loopKilledLocations != null && loopKilledLocations.loopKillsLocations()) {
            Iterator it = initialState.readCache.getKeys().iterator();
            while (it.hasNext()) {
                PEReadEliminationBlockState.ReadCacheEntry entry = (PEReadEliminationBlockState.ReadCacheEntry)it.next();
                if (!loopKilledLocations.containsLocation(entry.identity)) continue;
                it.remove();
            }
        }
        return initialState;
    }

    static {
        for (JavaKind kind : JavaKind.values()) {
            UNBOX_LOCATIONS.put(kind, NamedLocationIdentity.immutable("PEA unbox " + kind.getJavaName()));
        }
    }

    private class ReadEliminationMergeProcessor
    extends PartialEscapeClosure.MergeProcessor {
        ReadEliminationMergeProcessor(HIRBlock mergeBlock) {
            super(mergeBlock);
        }

        protected void merge(List<PEReadEliminationBlockState> states) {
            super.merge(states);
            this.mergeReadCache(states);
        }

        private void mergeReadCache(List<PEReadEliminationBlockState> states) {
            MapCursor cursor = states.get((int)0).readCache.getEntries();
            while (cursor.advance()) {
                PEReadEliminationBlockState.ReadCacheEntry key = (PEReadEliminationBlockState.ReadCacheEntry)cursor.getKey();
                ValueNode value = (ValueNode)cursor.getValue();
                boolean phi = false;
                for (int i = 1; i < states.size(); ++i) {
                    ValueNode otherValue = (ValueNode)states.get((int)i).readCache.get((Object)key);
                    if (otherValue == null || !value.stamp(NodeView.DEFAULT).isCompatible(otherValue.stamp(NodeView.DEFAULT))) {
                        value = null;
                        phi = false;
                        break;
                    }
                    if (phi || otherValue == value) continue;
                    phi = true;
                }
                if (phi) {
                    PhiNode phiNode = this.getPhi(key, value.stamp(NodeView.DEFAULT).unrestricted());
                    this.mergeEffects.addFloatingNode(phiNode, "mergeReadCache");
                    for (int i = 0; i < states.size(); ++i) {
                        ValueNode v = states.get(i).getReadCache(key.object, key.identity, key.index, key.kind, PEReadEliminationClosure.this);
                        assert (phiNode.stamp(NodeView.DEFAULT).isCompatible(v.stamp(NodeView.DEFAULT))) : "Cannot create read elimination phi for inputs with incompatible stamps.";
                        this.setPhiInput(phiNode, i, v);
                    }
                    ((PEReadEliminationBlockState)this.newState).readCache.put((Object)key, (Object)phiNode);
                    continue;
                }
                if (value == null) continue;
                ((PEReadEliminationBlockState)this.newState).readCache.put((Object)key, (Object)value);
            }
            for (PhiNode phi : this.getPhis()) {
                if (phi.getStackKind() != JavaKind.Object) continue;
                for (PEReadEliminationBlockState.ReadCacheEntry entry : states.get((int)0).readCache.getKeys()) {
                    if (entry.object != this.getPhiValueAt(phi, 0)) continue;
                    this.mergeReadCachePhi(phi, entry.identity, entry.index, entry.kind, entry.overflowAccess, states);
                }
            }
        }

        private void mergeReadCachePhi(PhiNode phi, LocationIdentity identity, int index, JavaKind kind, boolean overflowAccess, List<PEReadEliminationBlockState> states) {
            ValueNode[] values = new ValueNode[states.size()];
            values[0] = states.get(0).getReadCache(this.getPhiValueAt(phi, 0), identity, index, kind, PEReadEliminationClosure.this);
            if (values[0] != null) {
                for (int i = 1; i < states.size(); ++i) {
                    ObjectState obj = PEReadEliminationClosure.this.getObjectState(states.get(i), this.getPhiValueAt(phi, i));
                    if (obj != null && obj.isVirtual()) {
                        return;
                    }
                    ValueNode value = states.get(i).getReadCache(this.getPhiValueAt(phi, i), identity, index, kind, PEReadEliminationClosure.this);
                    if (value == null || !values[i - 1].stamp(NodeView.DEFAULT).isCompatible(value.stamp(NodeView.DEFAULT))) {
                        return;
                    }
                    values[i] = value;
                }
                PhiNode phiNode = this.getPhi(new PEReadEliminationBlockState.ReadCacheEntry(identity, phi, index, kind, overflowAccess), values[0].stamp(NodeView.DEFAULT).unrestricted());
                this.mergeEffects.addFloatingNode(phiNode, "mergeReadCachePhi");
                for (int i = 0; i < values.length; ++i) {
                    this.setPhiInput(phiNode, i, values[i]);
                }
                ((PEReadEliminationBlockState)this.newState).readCache.put((Object)new PEReadEliminationBlockState.ReadCacheEntry(identity, phi, index, kind, overflowAccess), (Object)phiNode);
            }
        }
    }
}

