/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.virtual.phases.ea.ObjectState;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapeBlockState;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapeClosure;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.word.LocationIdentity;

public final class PEReadEliminationBlockState
extends PartialEscapeBlockState<PEReadEliminationBlockState> {
    final EconomicMap<ReadCacheEntry, ValueNode> readCache;

    public PEReadEliminationBlockState(OptionValues options, DebugContext debug) {
        super(options, debug);
        this.readCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
    }

    public PEReadEliminationBlockState(PEReadEliminationBlockState other) {
        super(other);
        this.readCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT, other.readCache);
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.readCache);
    }

    private static JavaKind stampToJavaKind(Stamp stamp) {
        if (stamp instanceof IntegerStamp) {
            switch (((IntegerStamp)stamp).getBits()) {
                case 1: {
                    return JavaKind.Boolean;
                }
                case 8: {
                    return JavaKind.Byte;
                }
                case 16: {
                    return ((IntegerStamp)stamp).isPositive() ? JavaKind.Char : JavaKind.Short;
                }
                case 32: {
                    return JavaKind.Int;
                }
                case 64: {
                    return JavaKind.Long;
                }
            }
            throw new IllegalArgumentException("unexpected IntegerStamp " + String.valueOf(stamp));
        }
        return stamp.getStackKind();
    }

    @Override
    protected void objectMaterialized(VirtualObjectNode virtual, AllocatedObjectNode representation, List<ValueNode> values) {
        if (virtual instanceof VirtualInstanceNode) {
            VirtualInstanceNode instance = (VirtualInstanceNode)virtual;
            for (int i = 0; i < instance.entryCount(); ++i) {
                JavaKind declaredKind = instance.field(i).getJavaKind();
                if (declaredKind != PEReadEliminationBlockState.stampToJavaKind(values.get(i).stamp(NodeView.DEFAULT))) continue;
                this.readCache.put((Object)new ReadCacheEntry(new FieldLocationIdentity(instance.field(i)), representation, -1, declaredKind, false), (Object)values.get(i));
            }
        }
    }

    @Override
    public boolean equivalentTo(PEReadEliminationBlockState other) {
        if (!PEReadEliminationBlockState.isSubMapOf(this.readCache, other.readCache)) {
            return false;
        }
        return super.equivalentTo(other);
    }

    public void addReadCache(ValueNode object, LocationIdentity identity, int index, JavaKind kind, boolean overflowAccess, ValueNode value, PartialEscapeClosure<?> closure) {
        ValueNode cacheObject;
        ObjectState obj = closure.getObjectState(this, object);
        if (obj != null) {
            assert (!obj.isVirtual());
            cacheObject = obj.getMaterializedValue();
        } else {
            cacheObject = object;
        }
        this.readCache.put((Object)new ReadCacheEntry(identity, cacheObject, index, kind, overflowAccess), (Object)value);
    }

    public ValueNode getReadCache(ValueNode object, LocationIdentity identity, int index, JavaKind kind, PartialEscapeClosure<?> closure) {
        ValueNode cacheObject;
        ObjectState obj = closure.getObjectState(this, object);
        if (obj != null) {
            assert (!obj.isVirtual()) : object;
            cacheObject = obj.getMaterializedValue();
        } else {
            cacheObject = object;
        }
        ValueNode cacheValue = (ValueNode)this.readCache.get((Object)new ReadCacheEntry(identity, cacheObject, index, kind, false));
        obj = closure.getObjectState(this, cacheValue);
        if (obj != null) {
            assert (!obj.isVirtual());
            cacheValue = obj.getMaterializedValue();
        } else {
            cacheValue = closure.getScalarAlias(cacheValue);
        }
        return cacheValue;
    }

    public void killReadCache() {
        this.readCache.clear();
    }

    public void killReadCache(LocationIdentity identity, int index) {
        Iterator iter = this.readCache.getKeys().iterator();
        while (iter.hasNext()) {
            ReadCacheEntry entry = (ReadCacheEntry)iter.next();
            if (!entry.identity.equals(identity) || index != -1 && entry.index != -1 && index != entry.index && !entry.overflowAccess) continue;
            iter.remove();
        }
    }

    public EconomicMap<ReadCacheEntry, ValueNode> getReadCache() {
        return this.readCache;
    }

    static final class ReadCacheEntry {
        public final LocationIdentity identity;
        public final ValueNode object;
        public final int index;
        public final JavaKind kind;
        public final boolean overflowAccess;

        ReadCacheEntry(LocationIdentity identity, ValueNode object, int index, JavaKind kind, boolean overflowAccess) {
            this.identity = identity;
            this.object = object;
            this.index = index;
            this.kind = kind;
            this.overflowAccess = overflowAccess;
        }

        public int hashCode() {
            int result = 31 + (this.identity == null ? 0 : this.identity.hashCode());
            result = 31 * result + (this.object == null ? 0 : System.identityHashCode(this.object));
            result = 31 * result + this.kind.ordinal();
            return result * 31 + this.index;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReadCacheEntry)) {
                return false;
            }
            ReadCacheEntry other = (ReadCacheEntry)obj;
            return this.identity.equals(other.identity) && this.object == other.object && this.index == other.index && this.kind == other.kind;
        }

        public String toString() {
            return this.index == -1 ? String.valueOf(this.object) + ":" + String.valueOf(this.kind) + "<" + String.valueOf(this.identity) + ">" : String.valueOf(this.object) + "[" + this.index + "]:" + String.valueOf(this.kind) + "<" + String.valueOf(this.identity) + ">";
        }
    }
}

