/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.Optional;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;
import jdk.graal.compiler.phases.common.util.LoopUtility;
import jdk.graal.compiler.phases.graph.ReentrantBlockIterator;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import org.graalvm.collections.EconomicSet;

public abstract class EffectsPhase<CoreProvidersT extends CoreProviders>
extends BasePhase<CoreProvidersT> {
    private final int maxIterations;
    protected final CanonicalizerPhase canonicalizer;
    private final boolean unscheduled;
    private final SchedulePhase.SchedulingStrategy strategy;

    protected EffectsPhase(int maxIterations, CanonicalizerPhase canonicalizer) {
        this(maxIterations, canonicalizer, false, SchedulePhase.SchedulingStrategy.EARLIEST);
    }

    protected EffectsPhase(int maxIterations, CanonicalizerPhase canonicalizer, boolean unscheduled, SchedulePhase.SchedulingStrategy strategy) {
        this.strategy = strategy;
        this.maxIterations = maxIterations;
        this.canonicalizer = canonicalizer;
        this.unscheduled = unscheduled;
    }

    protected EffectsPhase(int maxIterations, CanonicalizerPhase canonicalizer, boolean unscheduled) {
        this(maxIterations, canonicalizer, unscheduled, unscheduled ? null : SchedulePhase.SchedulingStrategy.EARLIEST);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return this.canonicalizer.notApplicableTo(graphState);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProvidersT context) {
        this.runAnalysis(graph, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runAnalysis(StructuredGraph graph, CoreProvidersT context) {
        LoopUtility.removeObsoleteProxies(graph, context, this.canonicalizer);
        assert (this.unscheduled || this.strategy != null);
        boolean changed = false;
        DebugContext debug = graph.getDebug();
        int iteration = 0;
        while (iteration < this.maxIterations) {
            CompilationAlarm.checkProgress(graph);
            try (DebugContext.Scope s = debug.scope(debug.areScopesEnabled() ? "iteration " + iteration : null);){
                ControlFlowGraph cfg;
                StructuredGraph.ScheduleResult schedule;
                if (this.unscheduled) {
                    schedule = null;
                    cfg = ControlFlowGraph.newBuilder(graph).connectBlocks(true).computeLoops(true).computeFrequency(true).build();
                } else {
                    new SchedulePhase(this.strategy).apply(graph, context, false);
                    schedule = graph.getLastSchedule();
                    cfg = schedule.getCFG();
                }
                boolean postTriggered = false;
                try {
                    DebugContext.Scope scheduleScope = debug.scope((Object)"EffectsPhaseWithSchedule", schedule);
                    try {
                        Closure<?> closure = this.createEffectsClosure(context, schedule, cfg, graph.getOptions());
                        ReentrantBlockIterator.apply(closure, cfg.getStartBlock());
                        if (closure.needsApplyEffects()) {
                            EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
                            try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
                                closure.applyEffects();
                                if (debug.isDumpEnabled(3)) {
                                    debug.dump(3, (Object)graph, "%s iteration", this.getName());
                                }
                                new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
                            }
                            LoopUtility.removeObsoleteProxies(graph, context, this.canonicalizer);
                            Graph.Mark before = graph.getMark();
                            this.postIteration(graph, context, listener.getNodes());
                            boolean bl = postTriggered = !before.isCurrent();
                        }
                        if (!closure.hasChanged() && !postTriggered) {
                            if (scheduleScope == null) return changed;
                            scheduleScope.close();
                            return changed;
                        }
                        changed = true;
                        if (scheduleScope != null) {
                            scheduleScope.close();
                        }
                    }
                    catch (Throwable throwable) {
                        if (scheduleScope == null) throw throwable;
                        try {
                            scheduleScope.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable t) {
                    throw debug.handle(t);
                }
            }
            ++iteration;
        }
        return changed;
    }

    protected void postIteration(StructuredGraph graph, CoreProvidersT context, EconomicSet<Node> changedNodes) {
        if (this.canonicalizer != null) {
            this.canonicalizer.applyIncremental(graph, (CoreProviders)context, (Iterable<? extends Node>)changedNodes);
        }
    }

    protected abstract Closure<?> createEffectsClosure(CoreProvidersT var1, StructuredGraph.ScheduleResult var2, ControlFlowGraph var3, OptionValues var4);

    public static abstract class Closure<T>
    extends ReentrantBlockIterator.BlockIteratorClosure<T> {
        public abstract boolean hasChanged();

        public abstract boolean needsApplyEffects();

        public abstract void applyEffects();
    }
}

