/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.json;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.util.json.JsonBuilder;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class JsonWriter
implements AutoCloseable {
    private final Writer writer;
    private int indentation = 0;

    public JsonWriter(Path path, OpenOption ... options) throws IOException {
        this(Files.newBufferedWriter(path, StandardCharsets.UTF_8, options));
    }

    public JsonWriter(Writer writer) {
        this.writer = writer;
    }

    public JsonBuilder.ObjectBuilder objectBuilder() throws IOException {
        return JsonBuilder.object(this);
    }

    public JsonBuilder.ArrayBuilder arrayBuilder() throws IOException {
        return JsonBuilder.array(this);
    }

    public JsonBuilder.ValueBuilder valueBuilder() {
        return JsonBuilder.value(this);
    }

    public JsonWriter append(char c) throws IOException {
        this.writer.write(c);
        return this;
    }

    public JsonWriter append(String s) throws IOException {
        this.writer.write(s);
        return this;
    }

    public JsonWriter appendObjectStart() throws IOException {
        return this.append('{');
    }

    public JsonWriter appendObjectEnd() throws IOException {
        return this.append('}');
    }

    public JsonWriter appendArrayStart() throws IOException {
        return this.append('[');
    }

    public JsonWriter appendArrayEnd() throws IOException {
        return this.append(']');
    }

    public JsonWriter appendSeparator() throws IOException {
        return this.append(',');
    }

    public JsonWriter appendFieldSeparator() throws IOException {
        return this.append(':');
    }

    public JsonWriter appendKeyValue(String key, Object value) throws IOException {
        return this.quote(key).appendFieldSeparator().printValue(value);
    }

    public JsonWriter print(Object value) throws IOException {
        if (value instanceof Map) {
            Map map = (Map)value;
            this.printMap(map);
        } else if (value instanceof EconomicMap) {
            EconomicMap economicMap = (EconomicMap)value;
            this.printMap(economicMap);
        } else if (value instanceof Iterator) {
            Iterator it = (Iterator)value;
            this.printIterator(it);
        } else if (value instanceof List) {
            List list = (List)value;
            this.printIterator(list.iterator());
        } else {
            this.printValue(value);
        }
        return this;
    }

    private void printMap(Map<?, ?> map) throws IOException {
        if (map.isEmpty()) {
            this.append("{}");
            return;
        }
        this.appendObjectStart();
        boolean separator = false;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (separator) {
                this.appendSeparator();
            }
            this.quote(entry.getKey().toString()).appendFieldSeparator();
            this.print(entry.getValue());
            separator = true;
        }
        this.appendObjectEnd();
    }

    private void printMap(EconomicMap<?, ?> map) throws IOException {
        if (map.isEmpty()) {
            this.append("{}");
            return;
        }
        this.appendObjectStart();
        boolean separator = false;
        MapCursor cursor = map.getEntries();
        while (cursor.advance()) {
            if (separator) {
                this.appendSeparator();
            }
            this.quote(cursor.getKey().toString()).appendFieldSeparator();
            this.print(cursor.getValue());
            separator = true;
        }
        this.appendObjectEnd();
    }

    private void printIterator(Iterator<?> iter) throws IOException {
        if (!iter.hasNext()) {
            this.append("[]");
            return;
        }
        this.appendArrayStart();
        boolean separator = false;
        while (iter.hasNext()) {
            Object item = iter.next();
            if (separator) {
                this.appendSeparator();
            }
            this.print(item);
            separator = true;
        }
        this.appendArrayEnd();
    }

    public JsonWriter printValue(Object o) throws IOException {
        if (o == null) {
            return this.append("null");
        }
        if (o instanceof Boolean || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
            return this.append(o.toString());
        }
        if (o instanceof Float) {
            Float f = (Float)o;
            if (f.isNaN() || f.isInfinite()) {
                return this.quote(f.toString());
            }
            return this.append(f.toString());
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            if (d.isNaN() || d.isInfinite()) {
                return this.quote(d.toString());
            }
            return this.append(d.toString());
        }
        return this.quote(o.toString());
    }

    public JsonWriter quote(String s) throws IOException {
        this.writer.write(JsonWriter.quoteString(s));
        return this;
    }

    private static void escapeSequence(StringBuilder sb, char c) {
        sb.append('\\');
        sb.append(c);
    }

    private static String quoteString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(2 + s.length() + 8);
        sb.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\\') {
                JsonWriter.escapeSequence(sb, c);
                continue;
            }
            if (c == '\b') {
                JsonWriter.escapeSequence(sb, 'b');
                continue;
            }
            if (c == '\f') {
                JsonWriter.escapeSequence(sb, 'f');
                continue;
            }
            if (c == '\n') {
                JsonWriter.escapeSequence(sb, 'n');
                continue;
            }
            if (c == '\r') {
                JsonWriter.escapeSequence(sb, 'r');
                continue;
            }
            if (c == '\t') {
                JsonWriter.escapeSequence(sb, 't');
                continue;
            }
            if (c <= '\u001f') {
                sb.append(String.format("\\u%04x", c));
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    public JsonWriter newline() throws IOException {
        StringBuilder builder = new StringBuilder(1 + 2 * this.indentation);
        builder.append("\n");
        for (int i = 0; i < this.indentation; ++i) {
            builder.append("  ");
        }
        this.writer.write(builder.toString());
        return this;
    }

    public JsonWriter indent() {
        ++this.indentation;
        return this;
    }

    public JsonWriter unindent() {
        assert (this.indentation > 0) : "Json indentation underflowed";
        --this.indentation;
        return this;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

