/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import jdk.graal.compiler.util.json.JsonWriter;

public interface JsonPrinter<T> {
    public void print(T var1, JsonWriter var2) throws IOException;

    public static <T> void printCollection(JsonWriter writer, Collection<T> collection, Comparator<T> comparator, JsonPrinter<T> elementPrinter) throws IOException {
        if (collection.isEmpty()) {
            writer.append("[]");
            return;
        }
        Collection<T> ordered = collection;
        if (comparator != null) {
            ordered = new ArrayList<T>(collection);
            ((List)ordered).sort(comparator);
        }
        writer.appendArrayStart();
        boolean separator = false;
        for (T t : ordered) {
            if (separator) {
                writer.appendSeparator();
            }
            elementPrinter.print(t, writer);
            separator = true;
        }
        writer.appendArrayEnd();
    }
}

