/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;

public final class JsonParser {
    private final Reader source;
    private int pos;
    private int line = 0;
    private int beginningOfLine = 0;
    private int next;
    private final CharBuffer buffer = CharBuffer.allocate(8192).limit(0);
    private static final int EOF = -1;
    private static final int STATE_EMPTY = 0;
    private static final int STATE_ELEMENT_PARSED = 1;
    private static final int STATE_COMMA_PARSED = 2;

    public JsonParser(String source) throws IOException {
        this(new StringReader(source));
    }

    public JsonParser(Reader source) throws IOException {
        this.source = source;
        this.next();
        this.pos = 0;
    }

    public int getSourceLength() {
        try {
            this.source.reset();
            int length = 0;
            while (this.next() != -1) {
                ++length;
            }
            this.source.reset();
            this.source.skip(this.pos);
            return length;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not compute size of source", e);
        }
    }

    public Object parse() throws IOException {
        Object value = this.parseLiteral();
        this.skipWhiteSpace();
        if (this.next != -1) {
            throw this.expectedError(this.pos, "eof", JsonParser.toString(this.peek()));
        }
        return value;
    }

    public EconomicMap<String, Object> parseAllowedKeys(List<String> allowedKeys) throws IOException {
        EconomicMap result = EconomicMap.create();
        if (allowedKeys.isEmpty()) {
            this.next = -1;
            return result;
        }
        this.skipWhiteSpace();
        int state = 0;
        int c = this.peek();
        if (c == -1) {
            throw this.expectedError(this.pos, "json literal", "eof");
        }
        if (c != 123) {
            throw this.expectedError(this.pos, "{", JsonParser.toString(c));
        }
        this.next();
        block5: while (this.next != -1) {
            this.skipWhiteSpace();
            c = this.peek();
            switch (c) {
                case 34: {
                    if (state == 1) {
                        throw this.expectedError(this.pos, ", or }", JsonParser.toString(c));
                    }
                    String id = this.parseString();
                    this.expectColon();
                    Object value = this.parseLiteral();
                    if (allowedKeys.contains(id)) {
                        result.put((Object)id, value);
                    }
                    if (result.size() == allowedKeys.size()) {
                        this.next = -1;
                        return result;
                    }
                    state = 1;
                    continue block5;
                }
                case 44: {
                    if (state != 1) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    state = 2;
                    this.next();
                    continue block5;
                }
                case 125: {
                    if (state == 2) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    this.next();
                    return result;
                }
            }
            throw this.expectedError(this.pos, ", or }", JsonParser.toString(c));
        }
        throw this.expectedError(this.pos, ", or }", "eof");
    }

    public static EconomicMap<String, Object> parseDict(Reader input) throws IOException {
        JsonParser parser = new JsonParser(input);
        return (EconomicMap)parser.parse();
    }

    public static EconomicMap<String, Object> parseDict(String input) throws IOException {
        JsonParser parser = new JsonParser(input);
        return (EconomicMap)parser.parse();
    }

    private Object parseLiteral() throws IOException {
        this.skipWhiteSpace();
        int c = this.peek();
        if (c == -1) {
            throw this.expectedError(this.pos, "json literal", "eof");
        }
        switch (c) {
            case 123: {
                return this.parseObject();
            }
            case 91: {
                return this.parseArray();
            }
            case 34: {
                return this.parseString();
            }
            case 102: {
                return this.parseKeyword("false", Boolean.FALSE);
            }
            case 116: {
                return this.parseKeyword("true", Boolean.TRUE);
            }
            case 110: {
                return this.parseKeyword("null", null);
            }
        }
        if (JsonParser.isDigit(c) || c == 45) {
            return this.parseNumber();
        }
        if (c == 46) {
            throw this.numberError(this.pos);
        }
        throw this.expectedError(this.pos, "json literal", JsonParser.toString(c));
    }

    private Object parseObject() throws IOException {
        EconomicMap result = EconomicMap.create();
        int state = 0;
        int p = this.peek();
        assert (p == 123) : "Must be } but was " + p;
        this.next();
        block5: while (this.next != -1) {
            this.skipWhiteSpace();
            int c = this.peek();
            switch (c) {
                case 34: {
                    if (state == 1) {
                        throw this.expectedError(this.pos, ", or }", JsonParser.toString(c));
                    }
                    String id = this.parseString();
                    this.expectColon();
                    Object value = this.parseLiteral();
                    EconomicMap object = result;
                    object.put((Object)id, value);
                    state = 1;
                    continue block5;
                }
                case 44: {
                    if (state != 1) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    state = 2;
                    this.next();
                    continue block5;
                }
                case 125: {
                    if (state == 2) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    this.next();
                    return result;
                }
            }
            throw this.expectedError(this.pos, ", or }", JsonParser.toString(c));
        }
        throw this.expectedError(this.pos, ", or }", "eof");
    }

    private void expectColon() throws IOException {
        this.skipWhiteSpace();
        int n = this.next();
        if (n != 58) {
            throw this.expectedError(this.pos - 1, ":", JsonParser.toString(n));
        }
    }

    private Object parseArray() throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        int state = 0;
        int p = this.peek();
        assert (p == 91) : "Must be [ but was " + p;
        this.next();
        block4: while (this.next != -1) {
            this.skipWhiteSpace();
            int c = this.peek();
            switch (c) {
                case 44: {
                    if (state != 1) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    state = 2;
                    this.next();
                    continue block4;
                }
                case 93: {
                    if (state == 2) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    this.next();
                    return result;
                }
            }
            if (state == 1) {
                throw this.expectedError(this.pos, ", or ]", JsonParser.toString(c));
            }
            result.add(this.parseLiteral());
            state = 1;
        }
        throw this.expectedError(this.pos, ", or ]", "eof");
    }

    private String parseString() throws IOException {
        this.next();
        StringBuilder sb = new StringBuilder();
        while (this.next != -1) {
            int c = this.next();
            if (c <= 31) {
                throw this.syntaxError(this.pos, "String contains control character: " + c);
            }
            if (c == 92) {
                sb.append(this.parseEscapeSequence());
                continue;
            }
            if (c == 34) {
                return sb.toString();
            }
            sb.append((char)c);
        }
        throw this.error("Missing close quote", this.pos);
    }

    private char parseEscapeSequence() throws IOException {
        int c = this.next();
        return switch (c) {
            case 34 -> '\"';
            case 92 -> '\\';
            case 47 -> '/';
            case 98 -> '\b';
            case 102 -> '\f';
            case 110 -> '\n';
            case 114 -> '\r';
            case 116 -> '\t';
            case 117 -> this.parseUnicodeEscape();
            default -> throw this.error("Invalid escape character", this.pos - 1);
        };
    }

    private char parseUnicodeEscape() throws IOException {
        return (char)(this.parseHexDigit() << 12 | this.parseHexDigit() << 8 | this.parseHexDigit() << 4 | this.parseHexDigit());
    }

    private int parseHexDigit() throws IOException {
        int c = this.next();
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c + 10 - 65;
        }
        if (c >= 97 && c <= 102) {
            return c + 10 - 97;
        }
        throw this.error("Invalid hex digit", this.pos - 1);
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private void skipDigits(StringBuilder sb) throws IOException {
        int c;
        while (this.next != -1 && JsonParser.isDigit(c = this.peek())) {
            this.next();
            sb.append((char)c);
        }
    }

    private Number parseNumber() throws IOException {
        boolean isFloating = false;
        int start = this.pos;
        StringBuilder sb = new StringBuilder();
        int c = this.next();
        sb.append((char)c);
        if (c == 45) {
            c = this.next();
            sb.append((char)c);
        }
        if (!JsonParser.isDigit(c)) {
            throw this.numberError(start);
        }
        if (c != 48) {
            this.skipDigits(sb);
        }
        if (this.peek() == 46) {
            isFloating = true;
            int ch = this.next();
            sb.append((char)ch);
            ch = this.next();
            sb.append((char)ch);
            if (!JsonParser.isDigit(ch)) {
                throw this.numberError(this.pos - 1);
            }
            this.skipDigits(sb);
        }
        if ((c = this.peek()) == 101 || c == 69) {
            this.next();
            sb.append((char)c);
            c = this.next();
            sb.append((char)c);
            if (c == 45 || c == 43) {
                c = this.next();
                sb.append((char)c);
            }
            if (!JsonParser.isDigit(c)) {
                throw this.numberError(this.pos - 1);
            }
            this.skipDigits(sb);
        }
        String literalValue = sb.toString();
        if (isFloating) {
            return Double.parseDouble(literalValue);
        }
        long l = Long.parseLong(literalValue);
        if ((long)((int)l) == l) {
            return (int)l;
        }
        return l;
    }

    private Object parseKeyword(String keyword, Object value) throws IOException {
        for (int i = 0; i < keyword.length(); ++i) {
            if (this.next() == keyword.charAt(i)) continue;
            throw this.expectedError(this.pos, "json literal", "ident");
        }
        return value;
    }

    private int peek() {
        return this.next;
    }

    private int next() throws IOException {
        int cur = this.next;
        if (this.buffer.isEmpty()) {
            this.buffer.clear();
            if (this.source.read(this.buffer) == -1) {
                this.next = -1;
                return cur;
            }
            this.buffer.flip();
        }
        this.next = this.buffer.get();
        ++this.pos;
        return cur;
    }

    private void skipWhiteSpace() throws IOException {
        block5: while (this.next != -1) {
            switch (this.peek()) {
                case 10: {
                    ++this.line;
                    this.beginningOfLine = this.pos + 1;
                    this.next();
                    continue block5;
                }
                case 13: {
                    this.beginningOfLine = this.pos + 1;
                    this.next();
                    continue block5;
                }
                case 9: 
                case 32: {
                    this.next();
                    continue block5;
                }
            }
            return;
        }
    }

    private static String toString(int c) {
        return c == -1 ? "eof" : String.valueOf((char)c);
    }

    private JsonParserException error(String message, int position) {
        int columnNum = position - this.beginningOfLine;
        String formatted = JsonParser.format(message, this.line, columnNum);
        return new JsonParserException(formatted);
    }

    private static String format(String message, int line, int column) {
        return "line " + line + " column " + column + " " + message;
    }

    private JsonParserException numberError(int start) {
        return this.error("Invalid JSON number format", start);
    }

    private JsonParserException expectedError(int start, String expected, String found) {
        return this.error("Expected " + expected + " but found " + found, start);
    }

    private JsonParserException syntaxError(int start, String reason) {
        return this.error("Invalid JSON: " + reason, start);
    }
}

