/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.json;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.util.json.JsonPrettyWriter;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;

public final class JsonFormatter {
    private JsonFormatter() {
    }

    public static <T> String formatJson(EconomicMap<String, T> map) {
        return JsonFormatter.formatObject(map, false);
    }

    public static <T> String formatJson(List<T> list) {
        return JsonFormatter.formatObject(list, false);
    }

    public static <T> String formatJsonPretty(EconomicMap<String, T> map) {
        return JsonFormatter.formatObject(map, true);
    }

    public static <T> String formatJsonPretty(List<T> list) {
        return JsonFormatter.formatObject(list, true);
    }

    private static String formatObject(Object object, boolean prettyPrint) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = prettyPrint ? new JsonPrettyWriter(stringWriter) : new JsonWriter(stringWriter);){
            jsonWriter.print(object);
        }
        catch (IOException e) {
            throw GraalError.shouldNotReachHere(e);
        }
        return stringWriter.toString();
    }
}

