/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.json;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import jdk.graal.compiler.util.json.JsonWriter;

public final class JsonBuilder {
    private final JsonWriter writer;
    private ExclusiveBuilder currentBuilder = null;

    private JsonBuilder(JsonWriter writer) {
        this.writer = writer;
    }

    static ObjectBuilder object(JsonWriter writer) throws IOException {
        return JsonBuilder.value(writer).object();
    }

    static ArrayBuilder array(JsonWriter writer) throws IOException {
        return JsonBuilder.value(writer).array();
    }

    static ValueBuilder value(JsonWriter writer) {
        return new JsonBuilder(writer).new ValueBuilder(null);
    }

    private void transferAccess(ExclusiveBuilder from, ExclusiveBuilder to) {
        assert (this.currentBuilder == from && from != to) : "Attempting to transfer JSON writer ownership from non-active instance";
        this.currentBuilder = to;
    }

    private abstract class ExclusiveBuilder {
        private final ExclusiveBuilder parent;
        private boolean closed = false;

        private ExclusiveBuilder(ExclusiveBuilder parent) {
            this.parent = parent;
            JsonBuilder.this.transferAccess(parent, this);
        }

        protected final void checkAccess() {
            if (this.closed) {
                throw new IllegalStateException("%s instance is already closed".formatted(this.getClass()));
            }
            if (this != JsonBuilder.this.currentBuilder) {
                throw new ConcurrentModificationException("%s instance is not currently responsible for printing".formatted(this.getClass()));
            }
        }

        protected void finish() throws IOException {
            this.checkAccess();
            JsonBuilder.this.transferAccess(this, this.parent);
            this.closed = true;
            if (this.parent instanceof ValueBuilder) {
                this.parent.finish();
            }
        }
    }

    public final class ValueBuilder
    extends ExclusiveBuilder {
        boolean wroteSomething;

        private ValueBuilder(ExclusiveBuilder parent) {
            super(parent);
            this.wroteSomething = false;
        }

        public ObjectBuilder object() throws IOException {
            this.performSingleWrite();
            return new ObjectBuilder(this);
        }

        public ArrayBuilder array() throws IOException {
            this.performSingleWrite();
            return new ArrayBuilder(this);
        }

        public void value(Object value) throws IOException {
            this.checkAccess();
            this.performSingleWrite();
            JsonBuilder.this.writer.print(value);
            this.finish();
        }

        private void performSingleWrite() {
            if (this.wroteSomething) {
                throw new IllegalStateException("%s instance attempted to write a second value".formatted(this.getClass()));
            }
            this.wroteSomething = true;
        }

        @Override
        protected void finish() throws IOException {
            if (!this.wroteSomething) {
                throw new IllegalStateException("%s instance was closed before writing anything".formatted(this.getClass()));
            }
            super.finish();
        }
    }

    public final class ObjectBuilder
    extends ExclusiveBuilder
    implements AutoCloseable {
        private boolean isFirst;

        ObjectBuilder(ExclusiveBuilder parent) throws IOException {
            super(parent);
            this.isFirst = true;
            JsonBuilder.this.writer.appendObjectStart();
        }

        public ObjectBuilder append(String key, Object value) throws IOException {
            this.append(key).value(value);
            return this;
        }

        public ValueBuilder append(String key) throws IOException {
            this.checkAccess();
            if (!this.isFirst) {
                JsonBuilder.this.writer.appendSeparator();
            } else {
                this.isFirst = false;
            }
            JsonBuilder.this.writer.quote(key).appendFieldSeparator();
            return new ValueBuilder(this);
        }

        @Override
        public void finish() throws IOException {
            JsonBuilder.this.writer.appendObjectEnd();
            super.finish();
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }
    }

    public final class ArrayBuilder
    extends ExclusiveBuilder
    implements AutoCloseable {
        private boolean isFirst;

        ArrayBuilder(ExclusiveBuilder parent) throws IOException {
            super(parent);
            this.isFirst = true;
            JsonBuilder.this.writer.appendArrayStart();
        }

        public ArrayBuilder append(Object value) throws IOException {
            this.nextEntry().value(value);
            return this;
        }

        public ValueBuilder nextEntry() throws IOException {
            this.checkAccess();
            if (!this.isFirst) {
                JsonBuilder.this.writer.appendSeparator();
            } else {
                this.isFirst = false;
            }
            return new ValueBuilder(this);
        }

        @Override
        protected void finish() throws IOException {
            JsonBuilder.this.writer.appendArrayEnd();
            super.finish();
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }
    }
}

