/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.args;

import java.io.PrintWriter;
import jdk.graal.compiler.util.args.Command;
import jdk.graal.compiler.util.args.CommandParsingException;
import jdk.graal.compiler.util.args.HelpRequestedException;
import jdk.graal.compiler.util.args.UnknownArgumentException;

public class Program
extends Command {
    public Program(String name, String description) {
        super(name, description);
    }

    public final void parseAndValidate(String[] args, boolean errorIsFatal) {
        try {
            int parsed = this.parse(args, 0);
            if (parsed < args.length) {
                throw new CommandParsingException(new UnknownArgumentException(args[parsed]), this);
            }
        }
        catch (CommandParsingException e) {
            System.err.println(e.getMessage());
            if (errorIsFatal) {
                this.printHelpAndExit(e.getCommand(), 1);
            }
        }
        catch (HelpRequestedException e) {
            this.printHelpAndExit(e.getCommand(), 0);
        }
    }

    public void printHelpAndExit(Command c, int exitCode) {
        try (PrintWriter writer = new PrintWriter(System.out);){
            this.printHelp(c, writer);
        }
        System.exit(exitCode);
    }

    private void printUsage(Command c, PrintWriter writer) {
        if (c != this) {
            writer.append(this.getName());
            writer.append(' ');
        }
        c.printUsage(writer);
    }

    public void printHelp(Command c, PrintWriter writer) {
        writer.println();
        writer.println("USAGE:");
        writer.append("  ");
        this.printUsage(c, writer);
        writer.println();
        writer.println();
        c.printHelp(writer);
    }
}

