/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.args;

import java.io.PrintWriter;
import java.util.List;
import jdk.graal.compiler.util.args.InvalidArgumentException;
import jdk.graal.compiler.util.args.ListValue;

public abstract class OptionValue<T> {
    protected T value = null;
    protected final T defaultValue;
    private final String name;
    private final boolean required;
    private final String description;
    static final String INDENT = "  ";

    public OptionValue(String name, String help) {
        this.name = name;
        this.description = help;
        this.required = true;
        this.defaultValue = null;
    }

    public OptionValue(String name, T defaultValue, String help) {
        this.name = name;
        this.description = help;
        this.required = false;
        this.defaultValue = defaultValue;
    }

    public T getValue() {
        return this.isSet() ? this.value : this.defaultValue;
    }

    public boolean isSet() {
        return this.value != null;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void clear() {
        this.value = null;
    }

    public abstract boolean parseValue(String var1) throws InvalidArgumentException;

    public OptionValue<List<T>> repeated() {
        if (this.defaultValue != null) {
            return new ListValue<T>(this.name, List.of(this.defaultValue), this.description, this);
        }
        return new ListValue(this.name, this.description, this);
    }

    public String getUsage() {
        Object usage = String.format("<%s>", this.name);
        if (this.defaultValue != null) {
            usage = (String)usage + String.format(" (default: \"%s\")", this.defaultValue);
        }
        return usage;
    }

    private static void printIndentedLine(PrintWriter writer, String line, int indentLevel) {
        for (int i = 0; i <= indentLevel; ++i) {
            writer.append(INDENT);
        }
        writer.println(line);
    }

    static void printIndented(PrintWriter writer, String string, int indentLevel) {
        string.lines().forEach(line -> OptionValue.printIndentedLine(writer, line, indentLevel));
    }

    public void printHelp(PrintWriter writer, int indentLevel) {
        OptionValue.printIndented(writer, this.getDescription(), indentLevel);
    }
}

