/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.args;

import java.io.PrintWriter;
import jdk.graal.compiler.util.args.InvalidArgumentException;
import jdk.graal.compiler.util.args.OptionValue;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class MultiChoiceValue<T>
extends OptionValue<T> {
    private final EconomicMap<String, T> choices = EconomicMap.create();
    private final EconomicMap<String, String> choiceHelp = EconomicMap.create();
    private String defaultChoice = null;

    public MultiChoiceValue(String name, String help) {
        super(name, help);
    }

    public MultiChoiceValue(String name, T defaultValue, String help) {
        super(name, defaultValue, help);
    }

    @Override
    public boolean parseValue(String arg) throws InvalidArgumentException {
        if (arg == null) {
            throw new InvalidArgumentException(this.getName(), "no value provided");
        }
        this.value = this.choices.get((Object)arg);
        if (this.value == null) {
            throw new InvalidArgumentException(this.getName(), String.format("no choice named '%s'", arg));
        }
        return true;
    }

    public MultiChoiceValue<T> addChoice(String name, T choiceValue, String help) {
        this.choices.put((Object)name, choiceValue);
        this.choiceHelp.put((Object)name, (Object)help);
        if (choiceValue.equals(this.defaultValue)) {
            this.defaultChoice = name;
        }
        return this;
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        String sep = "";
        for (String choice : this.choices.getKeys()) {
            sb.append(sep);
            sb.append(choice);
            sep = ",";
        }
        sb.append('}');
        if (this.defaultChoice != null) {
            sb.append(String.format(" (default: %s)", this.defaultChoice));
        }
        return sb.toString();
    }

    @Override
    public void printHelp(PrintWriter writer, int indentLevel) {
        super.printHelp(writer, indentLevel);
        MapCursor it = this.choiceHelp.getEntries();
        while (it.advance()) {
            String help = String.format("%s: %s", it.getKey(), it.getValue());
            OptionValue.printIndented(writer, help, indentLevel + 1);
        }
    }
}

