/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.args;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.util.args.InvalidArgumentException;
import jdk.graal.compiler.util.args.OptionValue;

public class ListValue<T>
extends OptionValue<List<T>> {
    private final OptionValue<T> inner;

    public ListValue(String name, String help, OptionValue<T> inner) {
        super(name, help);
        this.inner = inner;
    }

    public ListValue(String name, List<T> defaultValue, String help, OptionValue<T> inner) {
        super(name, defaultValue, help);
        this.inner = inner;
    }

    @Override
    public boolean parseValue(String arg) {
        if (arg == null) {
            return false;
        }
        try {
            this.inner.parseValue(arg);
        }
        catch (InvalidArgumentException e) {
            return false;
        }
        if (this.value == null) {
            this.value = new ArrayList();
        }
        ((List)this.value).add(this.inner.value);
        return true;
    }

    @Override
    public String getUsage() {
        return String.format("[%s ...]", this.getName());
    }
}

