/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.args;

import jdk.graal.compiler.util.args.InvalidArgumentException;
import jdk.graal.compiler.util.args.OptionValue;

public class IntegerValue
extends OptionValue<Integer> {
    public IntegerValue(String name, String help) {
        super(name, help);
    }

    public IntegerValue(String name, Integer defaultValue, String help) {
        super(name, defaultValue, help);
    }

    @Override
    public boolean parseValue(String arg) throws InvalidArgumentException {
        if (arg == null) {
            throw new InvalidArgumentException(this.getName(), "no value provided");
        }
        try {
            this.value = Integer.valueOf(arg);
            return true;
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(this.getName(), String.format("invalid double value: \"%s\"", arg));
        }
    }
}

