/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.args;

import java.io.PrintWriter;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.util.args.Command;
import jdk.graal.compiler.util.args.CommandParsingException;
import jdk.graal.compiler.util.args.HelpRequestedException;
import jdk.graal.compiler.util.args.InvalidArgumentException;
import jdk.graal.compiler.util.args.OptionValue;
import org.graalvm.collections.EconomicMap;

public class CommandGroup<C extends Command>
extends OptionValue<C> {
    private final EconomicMap<String, C> subCommands = EconomicMap.create();

    public CommandGroup(String name, String help) {
        super(name, help);
    }

    public int parse(String[] args, int offset) throws InvalidArgumentException, HelpRequestedException, CommandParsingException {
        String arg = args[offset];
        this.value = this.subCommands.get((Object)arg);
        if (this.value == null) {
            throw new InvalidArgumentException(this.getName(), String.format("no subcommand named '%s'", arg));
        }
        return ((Command)this.value).parse(args, offset + 1);
    }

    @Override
    public final boolean parseValue(String arg) throws InvalidArgumentException {
        throw GraalError.unimplementedOverride();
    }

    public C addCommand(C command) {
        this.subCommands.put((Object)((Command)command).getName(), command);
        return command;
    }

    public C getSelectedCommand() {
        return (C)((Command)this.getValue());
    }

    @Override
    public void printHelp(PrintWriter writer, int indentLevel) {
        if (this.value != null) {
            ((Command)this.value).printHelp(writer, indentLevel);
            return;
        }
        boolean separate = false;
        for (Command command : this.subCommands.getValues()) {
            if (separate) {
                writer.println();
            }
            OptionValue.printIndented(writer, command.getName(), indentLevel + 1);
            OptionValue.printIndented(writer, command.getDescription(), indentLevel + 2);
            separate = true;
        }
    }
}

