/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.args;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.util.args.CommandGroup;
import jdk.graal.compiler.util.args.CommandParsingException;
import jdk.graal.compiler.util.args.HelpRequestedException;
import jdk.graal.compiler.util.args.InvalidArgumentException;
import jdk.graal.compiler.util.args.ListValue;
import jdk.graal.compiler.util.args.MissingArgumentException;
import jdk.graal.compiler.util.args.OptionValue;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class Command {
    public static final String SEPARATOR = "--";
    public static final char EQUAL_SIGN = '=';
    public static final String HELP = "--help";
    private final EconomicMap<String, OptionValue<?>> named = EconomicMap.create();
    private final List<OptionValue<?>> positional = new ArrayList();
    private final String name;
    private final String description;

    public Command(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public <T> OptionValue<T> addPositional(OptionValue<T> argument) {
        this.positional.add(argument);
        return argument;
    }

    public <T> OptionValue<T> addNamed(String optionName, OptionValue<T> argument) {
        this.named.put((Object)optionName, argument);
        return argument;
    }

    public <C extends Command> CommandGroup<C> addCommandGroup(CommandGroup<C> group) {
        this.addPositional(group);
        return group;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    private boolean parseEqualsValue(String arg, int equalSignIndex) throws InvalidArgumentException {
        String optionName = arg.substring(0, equalSignIndex);
        String valueString = arg.substring(equalSignIndex + 1);
        OptionValue value = (OptionValue)this.named.get((Object)optionName);
        if (value == null) {
            return false;
        }
        return value.parseValue(valueString);
    }

    public int parse(String[] args, int offset) throws CommandParsingException, HelpRequestedException {
        int nextPositionalArg = 0;
        int index = offset;
        ListValue currentListValue = null;
        try {
            while (index < args.length) {
                ListValue listValue;
                String arg = args[index];
                if (arg.contentEquals(HELP)) {
                    throw new HelpRequestedException(this);
                }
                if (arg.contentEquals(SEPARATOR)) {
                    ++index;
                    if (currentListValue == null) break;
                    currentListValue = null;
                    continue;
                }
                int equalSignIndex = arg.indexOf(61);
                if (equalSignIndex > -1 && this.parseEqualsValue(arg, equalSignIndex)) {
                    ++index;
                    currentListValue = null;
                    continue;
                }
                OptionValue<?> value = (OptionValue<?>)this.named.get((Object)arg);
                if (value != null) {
                    ++index;
                    currentListValue = null;
                } else if (currentListValue != null) {
                    value = currentListValue;
                } else {
                    if (nextPositionalArg == this.positional.size()) break;
                    value = this.positional.get(nextPositionalArg++);
                }
                if (value instanceof CommandGroup) {
                    CommandGroup commandGroup = (CommandGroup)value;
                    index = commandGroup.parse(args, index);
                    continue;
                }
                String string = arg = index == args.length ? null : args[index];
                if (!value.parseValue(arg)) {
                    if (currentListValue == null) continue;
                    currentListValue = null;
                    continue;
                }
                ++index;
                if (!(value instanceof ListValue)) continue;
                currentListValue = listValue = (ListValue)value;
            }
            this.verifyOptions(nextPositionalArg);
        }
        catch (InvalidArgumentException | MissingArgumentException e) {
            throw new CommandParsingException(e, this);
        }
        return index;
    }

    private void verifyOptions(int nextPositionalArg) throws MissingArgumentException {
        MapCursor cursor = this.named.getEntries();
        while (cursor.advance()) {
            String key = (String)cursor.getKey();
            OptionValue value = (OptionValue)cursor.getValue();
            if (value.isSet() || !value.isRequired()) continue;
            throw new MissingArgumentException(key);
        }
        for (int arg = nextPositionalArg; arg < this.positional.size(); ++arg) {
            OptionValue<?> option = this.positional.get(arg);
            if (!option.isRequired()) continue;
            throw new MissingArgumentException(this.positional.get(arg).getName());
        }
    }

    protected void printOptionUsage(PrintWriter writer) {
        boolean optionalFound = false;
        MapCursor it = this.named.getEntries();
        while (it.advance()) {
            if (((OptionValue)it.getValue()).isRequired()) {
                writer.append(String.format(" %s %s", it.getKey(), ((OptionValue)it.getValue()).getUsage()));
                continue;
            }
            optionalFound = true;
        }
        if (optionalFound) {
            writer.append(" [OPTIONS]");
        }
        for (OptionValue<?> option : this.positional) {
            writer.append(' ');
            if (option.isRequired()) {
                writer.append(option.getUsage());
                continue;
            }
            writer.append(String.format("[%s]", option.getUsage()));
        }
    }

    public void printUsage(PrintWriter writer) {
        writer.append(this.getName());
        this.printOptionUsage(writer);
    }

    public final void printHelp(PrintWriter writer) {
        this.printHelp(writer, 0);
    }

    public void printHelp(PrintWriter writer, int indentLevel) {
        boolean separate = false;
        if (!this.positional.isEmpty()) {
            writer.println("ARGS:");
            for (OptionValue<?> arg : this.positional) {
                if (separate) {
                    writer.println();
                }
                OptionValue.printIndented(writer, arg.getUsage(), indentLevel);
                arg.printHelp(writer, indentLevel + 1);
                separate = true;
            }
        }
        if (!this.named.isEmpty()) {
            if (separate) {
                writer.println();
                separate = false;
            }
            writer.println("OPTIONS:");
            MapCursor cursor = this.named.getEntries();
            while (cursor.advance()) {
                if (separate) {
                    writer.println();
                }
                String key = (String)cursor.getKey();
                OptionValue value = (OptionValue)cursor.getValue();
                OptionValue.printIndented(writer, String.format("%s %s", key, value.getUsage()), indentLevel);
                value.printHelp(writer, indentLevel + 1);
                separate = true;
            }
        }
    }
}

