/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util.args;

import java.util.Locale;
import jdk.graal.compiler.util.args.InvalidArgumentException;
import jdk.graal.compiler.util.args.OptionValue;

public class BooleanValue
extends OptionValue<Boolean> {
    public BooleanValue(String name, String help) {
        super(name, help);
    }

    public BooleanValue(String name, boolean defaultValue, String help) {
        super(name, defaultValue, help);
    }

    @Override
    public boolean parseValue(String arg) throws InvalidArgumentException {
        if (arg == null) {
            throw new InvalidArgumentException(this.getName(), "no value provided");
        }
        switch (arg.toLowerCase(Locale.US)) {
            case "true": {
                this.value = true;
                break;
            }
            case "false": {
                this.value = false;
                break;
            }
            default: {
                throw new InvalidArgumentException(this.getName(), String.format("invalid boolean value: \"%s\"", arg));
            }
        }
        return true;
    }
}

