/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import jdk.graal.compiler.core.common.calc.UnsignedMath;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.graal.compiler.util.TypedDataOutputStream;

public class ObjectCopierOutputStream
extends OutputStream {
    protected static final long HIGH_WORD_SHIFT = 6L;
    protected static final long NUM_HIGH_CODES = 64L;
    protected static final long NUM_LOW_CODES = 192L;
    protected static final long MAX_BYTES = 11L;
    private final TypedDataOutputStream out;
    private final PrintStream debugOut;

    public ObjectCopierOutputStream(OutputStream out, PrintStream debugOut) {
        this.out = new TypedDataOutputStream(out);
        this.debugOut = debugOut;
    }

    @Override
    public void write(int b) throws IOException {
        this.internalWriteByte(b);
        if (this.debugOut != null) {
            this.debugOut.printf(" 0x%02x", b);
        }
    }

    protected void internalWriteByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
        this.debugPrintValue(v);
    }

    public void writeUntypedValue(Object value) throws IOException {
        Class<?> valueClz = value.getClass();
        if (valueClz == Boolean.class) {
            this.out.writeBoolean((Boolean)value);
        } else if (valueClz == Byte.class) {
            this.internalWriteByte(((Byte)value).byteValue());
        } else if (valueClz == Short.class) {
            this.out.writeShort(((Short)value).shortValue());
        } else if (valueClz == Character.class) {
            this.out.writeChar(((Character)value).charValue());
        } else if (valueClz == Integer.class) {
            this.internalWritePackedSigned(((Integer)value).intValue());
        } else if (valueClz == Long.class) {
            this.internalWritePackedSigned((Long)value);
        } else if (valueClz == Float.class) {
            this.out.writeFloat(((Float)value).floatValue());
        } else if (valueClz == Double.class) {
            this.out.writeDouble((Double)value);
        } else if (valueClz == String.class) {
            this.writeStringValue((String)value);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type: Value: %s, Value type: %s", value, valueClz));
        }
        this.debugPrintValue(value);
    }

    protected void debugPrintValue(Object value) {
        if (this.debugOut != null) {
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            Object debugValue = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Character.class}, (Object)object2, n)) {
                case 0 -> {
                    String s = (String)object2;
                    yield ObjectCopier.Encoder.escapeDebugStringValue(s);
                }
                case 1 -> {
                    Character c = (Character)object2;
                    yield (int)c.charValue();
                }
                default -> value;
            };
            this.debugOut.printf(" %s", debugValue);
        }
    }

    protected void writeStringValue(String value) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.internalWritePackedUnsignedInt(bytes.length);
        this.out.write(bytes);
    }

    public void writeTypedPrimitiveArray(Object value) throws IOException {
        int i;
        TypeDescriptor.OfField compClz = value.getClass().componentType();
        int length = Array.getLength(value);
        this.internalWritePackedUnsignedInt(length);
        if (compClz == Boolean.TYPE) {
            this.internalWriteByte(90);
            for (i = 0; i < length; ++i) {
                this.out.writeBoolean(Array.getBoolean(value, i));
            }
        } else if (compClz == Byte.TYPE) {
            this.internalWriteByte(66);
            for (i = 0; i < length; ++i) {
                this.internalWriteByte(Array.getByte(value, i));
            }
        } else if (compClz == Short.TYPE) {
            this.internalWriteByte(83);
            for (i = 0; i < length; ++i) {
                this.out.writeShort(Array.getShort(value, i));
            }
        } else if (compClz == Character.TYPE) {
            this.internalWriteByte(67);
            for (i = 0; i < length; ++i) {
                this.out.writeChar(Array.getChar(value, i));
            }
        } else if (compClz == Integer.TYPE) {
            this.internalWriteByte(73);
            for (i = 0; i < length; ++i) {
                this.internalWritePackedSigned(Array.getInt(value, i));
            }
        } else if (compClz == Long.TYPE) {
            this.internalWriteByte(74);
            for (i = 0; i < length; ++i) {
                this.internalWritePackedSigned(Array.getLong(value, i));
            }
        } else if (compClz == Float.TYPE) {
            this.internalWriteByte(70);
            for (i = 0; i < length; ++i) {
                this.out.writeFloat(Array.getFloat(value, i));
            }
        } else if (compClz == Double.TYPE) {
            this.internalWriteByte(68);
            for (i = 0; i < length; ++i) {
                this.out.writeDouble(Array.getDouble(value, i));
            }
        } else {
            throw new IllegalArgumentException(String.format("Unsupported array: Value: %s, Value type: %s", value, value.getClass()));
        }
        if (this.debugOut != null) {
            for (i = 0; i < length; ++i) {
                this.debugPrintValue(Array.get(value, i));
            }
        }
    }

    private static long encodeSign(long value) {
        return value << 1 ^ value >> 63;
    }

    protected void internalWritePackedSigned(long value) throws IOException {
        this.writePacked(ObjectCopierOutputStream.encodeSign(value));
    }

    public void writePackedUnsignedInt(int value) throws IOException {
        this.internalWritePackedUnsignedInt(value);
        this.debugPrintValue(value);
    }

    protected void internalWritePackedUnsignedInt(int value) throws IOException {
        this.writePacked(value);
    }

    private void writePacked(long value) throws IOException {
        if (UnsignedMath.belowThan(value, 192L)) {
            this.internalWriteByte((int)value);
            return;
        }
        long sum = value;
        int i = 1;
        while (UnsignedMath.aboveOrEqual(sum, 192L) && (long)i < 11L) {
            long u1 = 192L + ((sum -= 192L) & 0x3FL);
            sum >>>= 6;
            this.internalWriteByte((int)u1);
            ++i;
        }
        assert (sum == (sum & 0xFFL)) : "not a byte";
        this.internalWriteByte((int)(sum & 0xFFL));
    }
}

