/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import jdk.graal.compiler.util.TypedDataInputStream;

public class ObjectCopierInputStream
extends InputStream {
    private final TypedDataInputStream in;

    public ObjectCopierInputStream(InputStream in) {
        this.in = new TypedDataInputStream(in);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    protected Object readUntypedValue(int type) throws IOException {
        return switch (type) {
            case 73 -> (int)this.readPackedSignedLong();
            case 74 -> this.readPackedSignedLong();
            case 85 -> this.readStringValue();
            default -> this.in.readUntypedValue(type);
        };
    }

    protected String readStringValue() throws IOException {
        int len = this.readPackedUnsignedInt();
        byte[] bytes = new byte[len];
        this.in.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public Object readTypedPrimitiveArray() throws IOException {
        int len = this.readPackedUnsignedInt();
        int type = this.in.readUnsignedByte();
        Object[] arr = switch (type) {
            case 90 -> new boolean[len];
            case 66 -> (Object[])new byte[len];
            case 83 -> (Object[])new short[len];
            case 67 -> (Object[])new char[len];
            case 73 -> (Object[])new int[len];
            case 74 -> (Object[])new long[len];
            case 70 -> (Object[])new float[len];
            case 68 -> (Object[])new double[len];
            default -> throw new IOException("Unsupported type: " + Integer.toHexString(type));
        };
        for (int i = 0; i < len; ++i) {
            Array.set(arr, i, this.readUntypedValue(type));
        }
        return arr;
    }

    public long readPackedSignedLong() throws IOException {
        return ObjectCopierInputStream.decodeSign(this.readPacked());
    }

    public int readPackedUnsignedInt() throws IOException {
        return Math.toIntExact(this.readPacked());
    }

    private static long decodeSign(long value) {
        return value >>> 1 ^ -(value & 1L);
    }

    private long readPacked() throws IOException {
        int b0 = this.in.readUnsignedByte();
        if ((long)b0 < 192L) {
            return b0;
        }
        assert ((long)b0 >= 192L) : b0;
        long sum = b0;
        long shift = 6L;
        int i = 2;
        while (true) {
            long b = this.in.readUnsignedByte();
            sum += b << (int)shift;
            if (b < 192L || (long)i == 11L) {
                return sum;
            }
            shift += 6L;
            ++i;
        }
    }
}

