/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.FieldIntrospection;
import jdk.graal.compiler.core.common.util.FrequencyEncoder;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.util.ObjectCopierInputStream;
import jdk.graal.compiler.util.ObjectCopierOutputStream;
import jdk.internal.misc.Unsafe;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicMapWrap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.word.LocationIdentity;

public class ObjectCopier {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    final Map<Class<?>, ClassInfo> classInfos = new HashMap();
    final Map<Class<?>, Builtin> builtinClasses = new HashMap();
    final Set<Class<?>> notBuiltins = new HashSet();

    private static short hashIntToShort(int h) {
        return (short)(h ^ h >>> 16);
    }

    protected final void addBuiltin(Builtin builtin) {
        this.addBuiltin(builtin, builtin.clazz);
    }

    final void addBuiltin(Builtin builtin, Class<?> clazz) {
        Builtin conflict = this.getBuiltin(clazz, true);
        GraalError.guarantee(conflict == null, "Conflicting builtins: %s and %s", (Object)conflict, (Object)builtin);
        this.builtinClasses.put(clazz, builtin);
    }

    public ObjectCopier() {
        this.addBuiltin(new ClassBuiltin());
        this.addBuiltin(new EconomicMapBuiltin());
        this.addBuiltin(new EnumBuiltin());
        HashMapBuiltin hashMapBuiltin = new HashMapBuiltin();
        this.addBuiltin(hashMapBuiltin);
        this.addBuiltin(hashMapBuiltin, IdentityHashMap.class);
        StringBuiltin stringBuiltin = new StringBuiltin();
        this.addBuiltin(stringBuiltin);
        this.addBuiltin(stringBuiltin, char[].class);
    }

    public static byte[] encode(Encoder encoder, Object root) {
        encoder.makeId(root, ObjectPath.of("[root:" + root.getClass().getName() + "]"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectCopierOutputStream cos = new ObjectCopierOutputStream(baos, encoder.debugOutput);){
            encoder.encode(cos, root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static Object decode(byte[] encoded, ClassLoader loader) {
        Decoder decoder = new Decoder(loader);
        return ObjectCopier.decode(decoder, encoded);
    }

    public static Object decode(Decoder decoder, byte[] encoded) {
        return decoder.decode(encoded);
    }

    final Builtin getBuiltin(Class<?> clazz) {
        return this.getBuiltin(clazz, false);
    }

    final Builtin getBuiltin(Class<?> clazz, boolean onlyCheck) {
        if (this.notBuiltins.contains(clazz)) {
            return null;
        }
        Builtin b = this.builtinClasses.get(clazz);
        if (b == null) {
            for (Map.Entry<Class<?>, Builtin> e : this.builtinClasses.entrySet()) {
                if (!e.getKey().isAssignableFrom(clazz)) continue;
                b = e.getValue();
                break;
            }
            if (!onlyCheck) {
                if (b == null) {
                    this.notBuiltins.add(clazz);
                } else {
                    this.builtinClasses.put(clazz, b);
                }
            }
        }
        return b;
    }

    public static Object readField(Field field, Object receiver) {
        try {
            return field.get(receiver);
        }
        catch (Error | IllegalAccessException e) {
            throw new GraalError(e, "Error reading %s", field);
        }
    }

    public static Field getField(Class<?> declaredClass, String fieldName) {
        try {
            Field f = declaredClass.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            throw GraalError.shouldNotReachHere(e);
        }
    }

    public static List<Field> getExternalValueFields() throws IOException {
        ArrayList<Field> externalValues = new ArrayList<Field>();
        ObjectCopier.addImmutableCollectionsFields(externalValues);
        ObjectCopier.addStaticFinalObjectFields(LocationIdentity.class, externalValues);
        try (FileSystem fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap());){
            for (String module : List.of("jdk.internal.vm.ci", "jdk.graal.compiler", "com.oracle.graal.graal_enterprise")) {
                Path top = fs.getPath("/modules/" + module, new String[0]);
                Stream<Path> files = Files.find(top, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]);
                try {
                    files.forEach(p -> {
                        String fileName = p.getFileName().toString();
                        if (fileName.endsWith(".class") && !fileName.equals("module-info.class")) {
                            int nameCount = p.getNameCount();
                            String className = p.subpath(2, nameCount).toString().replace('/', '.');
                            className = className.replace('/', '.').substring(0, className.length() - ".class".length());
                            try {
                                Class<?> graalClass = Class.forName(className);
                                ObjectCopier.addStaticFinalObjectFields(graalClass, externalValues);
                            }
                            catch (ClassNotFoundException e) {
                                throw new GraalError(e);
                            }
                        }
                    });
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
        }
        return externalValues;
    }

    public static void addStaticFinalObjectFields(Class<?> declaringClass, List<Field> fields) {
        if (Enum.class.isAssignableFrom(declaringClass)) {
            return;
        }
        for (Field field : declaringClass.getDeclaredFields()) {
            int fieldMask;
            int fieldModifiers = field.getModifiers();
            if ((fieldModifiers & (fieldMask = 24)) != fieldMask || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            fields.add(field);
        }
    }

    private static void addImmutableCollectionsFields(List<Field> fields) {
        Class<?> c = List.of().getClass().getDeclaringClass();
        GraalError.guarantee(c.getName().equals("java.util.ImmutableCollections"), "Incompatible ImmutableCollections class");
        for (Field f : c.getDeclaredFields()) {
            if (!f.getName().startsWith("EMPTY")) continue;
            int modifiers = f.getModifiers();
            GraalError.guarantee(Modifier.isStatic(modifiers), "Expect %s to be static", (Object)f);
            GraalError.guarantee(Modifier.isFinal(modifiers), "Expect %s to be final", (Object)f);
            GraalError.guarantee(!f.getType().isPrimitive(), "Expect %s to be non-primitive", (Object)f);
            f.setAccessible(true);
            fields.add(f);
        }
    }

    public static abstract class Builtin {
        final Class<?> clazz;
        final Set<Class<?>> concreteClasses;

        protected Builtin(Class<?> clazz, Class<?> ... concreteClasses) {
            this.clazz = clazz;
            if (Modifier.isAbstract(clazz.getModifiers())) {
                this.concreteClasses = Set.of(concreteClasses);
            } else {
                ArrayList l = new ArrayList(List.of(concreteClasses));
                l.add(clazz);
                this.concreteClasses = Set.copyOf(l);
            }
        }

        final void checkObject(Object obj) {
            this.checkClass(obj == Class.class ? (Class<?>)obj : obj.getClass());
        }

        final void checkClass(Class<?> c) {
            GraalError.guarantee(c.isEnum() || this.concreteClasses.contains(c), "Unsupported %s type: %s", (Object)this.clazz.getName(), (Object)c.getName());
        }

        protected void makeChildIds(Encoder encoder, Object obj, ObjectPath objectPath) {
        }

        protected abstract void encode(Encoder var1, ObjectCopierOutputStream var2, Object var3) throws IOException;

        protected abstract Object decode(Decoder var1, Class<?> var2, ObjectCopierInputStream var3) throws IOException;

        public String toString() {
            return "builtin:" + this.clazz.getName();
        }
    }

    static final class ClassBuiltin
    extends Builtin {
        ClassBuiltin() {
            super(Class.class, new Class[0]);
        }

        private static String getName(Object obj) {
            return ((Class)obj).getName();
        }

        @Override
        protected void makeChildIds(Encoder encoder, Object obj, ObjectPath objectPath) {
            encoder.makeStringId(ClassBuiltin.getName(obj), objectPath);
        }

        @Override
        protected void encode(Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            String name = ClassBuiltin.getName(obj);
            encoder.writeString(stream, name);
        }

        @Override
        protected Object decode(Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            String encoded;
            return switch (encoded = decoder.readString(stream)) {
                case "boolean" -> Boolean.TYPE;
                case "byte" -> Byte.TYPE;
                case "char" -> Character.TYPE;
                case "short" -> Short.TYPE;
                case "int" -> Integer.TYPE;
                case "float" -> Float.TYPE;
                case "long" -> Long.TYPE;
                case "double" -> Double.TYPE;
                case "void" -> Void.TYPE;
                default -> decoder.loadClass(encoded);
            };
        }
    }

    static final class EconomicMapBuiltin
    extends Builtin {
        EconomicMapBuiltin() {
            super(EconomicMap.class, EconomicMap.create().getClass());
        }

        @Override
        protected void makeChildIds(Encoder encoder, Object obj, ObjectPath objectPath) {
            EconomicMap map = (EconomicMap)obj;
            GraalError.guarantee(map.getEquivalenceStrategy() == Equivalence.DEFAULT, "Only DEFAULT strategy supported: %s", (Object)map.getEquivalenceStrategy());
            encoder.makeMapChildIds(map, objectPath);
        }

        @Override
        protected void encode(Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            encoder.encodeMap(stream, (UnmodifiableEconomicMap)obj);
        }

        @Override
        protected Object decode(Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            if (EconomicMap.class.isAssignableFrom(concreteType)) {
                EconomicMap map = EconomicMap.create();
                decoder.decodeMap(stream, (arg_0, arg_1) -> ((EconomicMap)map).put(arg_0, arg_1));
                return map;
            }
            throw new GraalError("Unexpected concrete Map type: ", concreteType);
        }
    }

    static final class EnumBuiltin
    extends Builtin {
        EnumBuiltin() {
            super(Enum.class, new Class[0]);
        }

        @Override
        protected void encode(Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            Enum con = (Enum)obj;
            stream.writePackedUnsignedInt(con.ordinal());
            stream.writeShort(EnumBuiltin.fingerprint(con));
        }

        private static short fingerprint(Enum<?> con) {
            int h = con.name().hashCode();
            return ObjectCopier.hashIntToShort(h);
        }

        @Override
        protected Object decode(Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            int ord = stream.readPackedUnsignedInt();
            short fingerprint = stream.readShort();
            Enum con = (Enum)concreteType.getEnumConstants()[ord];
            GraalError.guarantee(EnumBuiltin.fingerprint(con) == fingerprint, "Enum constant type mismatch: %s ordinal %d not expected to be %s", (Object)concreteType.getName(), (Object)ord, (Object)con);
            return con;
        }
    }

    static final class HashMapBuiltin
    extends Builtin {
        final Map<Class<?>, Supplier<?>> factories;

        HashMapBuiltin() {
            super(HashMap.class, IdentityHashMap.class, LinkedHashMap.class, SnippetTemplate.LRUCache.class);
            int size = SnippetTemplate.Options.MaxTemplatesPerSnippet.getDefaultValue();
            this.factories = Map.of(HashMap.class, HashMap::new, IdentityHashMap.class, IdentityHashMap::new, LinkedHashMap.class, LinkedHashMap::new, SnippetTemplate.LRUCache.class, () -> new SnippetTemplate.LRUCache(size, size));
        }

        @Override
        protected void makeChildIds(Encoder encoder, Object obj, ObjectPath objectPath) {
            Map map = (Map)obj;
            encoder.makeMapChildIds((EconomicMap<?, ?>)new EconomicMapWrap(map), objectPath);
        }

        @Override
        protected void encode(Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            Map map = (Map)obj;
            encoder.encodeMap(stream, (UnmodifiableEconomicMap<?, ?>)new EconomicMapWrap(map));
        }

        @Override
        protected Object decode(Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            Map map = (Map)this.factories.get(concreteType).get();
            decoder.decodeMap(stream, map::put);
            return map;
        }
    }

    static final class StringBuiltin
    extends Builtin {
        StringBuiltin() {
            super(String.class, char[].class);
        }

        private static String asString(Object obj) {
            return obj instanceof String ? (String)obj : new String((char[])obj);
        }

        @Override
        protected void makeChildIds(Encoder encoder, Object obj, ObjectPath objectPath) {
            encoder.makeStringId(StringBuiltin.asString(obj), objectPath);
        }

        @Override
        protected void encode(Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            encoder.writeString(stream, StringBuiltin.asString(obj));
        }

        @Override
        protected Object decode(Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            String s = decoder.readString(stream);
            if (concreteType == char[].class) {
                return s.toCharArray();
            }
            return s;
        }
    }

    public record ObjectPath(ObjectPath prefix, Object name) {
        static ObjectPath of(String rootName) {
            return new ObjectPath(null, rootName);
        }

        ObjectPath add(String fieldName) {
            return new ObjectPath(this, fieldName);
        }

        ObjectPath add(int index) {
            return new ObjectPath(this, index);
        }

        @Override
        public String toString() {
            ArrayList<Object> components = new ArrayList<Object>();
            ObjectPath p = this;
            while (p != null) {
                Object object = p.name;
                if (object instanceof String) {
                    String s = (String)object;
                    components.add(s);
                } else {
                    components.add("[" + String.valueOf(p.name) + "]");
                }
                p = p.prefix;
            }
            return String.join((CharSequence)".", components.reversed());
        }
    }

    public static class Encoder
    extends ObjectCopier {
        final FrequencyEncoder<Object> objects = FrequencyEncoder.createIdentityEncoder();
        final FrequencyEncoder<String> strings = FrequencyEncoder.createEqualityEncoder();
        final Map<Object, Field> externalValues;
        private final PrintStream debugOutput;

        public Encoder(List<Field> externalValueFields) {
            this(externalValueFields, null);
        }

        public Encoder(List<Field> externalValueFields, PrintStream debugOutput) {
            this(Encoder.gatherExternalValues(externalValueFields), debugOutput);
        }

        public Encoder(Map<Object, Field> externalValues) {
            this(externalValues, null);
        }

        public Encoder(Map<Object, Field> externalValues, PrintStream debugOutput) {
            this.objects.addObject(null);
            this.externalValues = externalValues;
            this.debugOutput = debugOutput;
        }

        public static Map<Object, Field> gatherExternalValues(List<Field> externalValueFields) {
            IdentityHashMap<Object, Field> result = new IdentityHashMap<Object, Field>();
            for (Field f : externalValueFields) {
                Encoder.addExternalValue(result, f);
            }
            return result;
        }

        protected ClassInfo makeClassInfo(Class<?> declaringClass) {
            return ClassInfo.of(declaringClass);
        }

        private static void addExternalValue(Map<Object, Field> externalValues, Field field) {
            GraalError.guarantee(Modifier.isStatic(field.getModifiers()), "Field '%s' is not static. Only a static field can be used as known location for an instance.", (Object)field);
            Object value = Encoder.readField(field, null);
            if (value == null) {
                return;
            }
            Field oldField = externalValues.put(value, field);
            if (oldField != null) {
                Object oldValue = Encoder.readField(oldField, null);
                GraalError.guarantee(oldValue == value, "%s and %s have different values: %s != %s", (Object)field, (Object)oldField, value, oldValue);
            }
        }

        public Map<Object, Field> getExternalValues() {
            return Collections.unmodifiableMap(this.externalValues);
        }

        private void encodeMap(ObjectCopierOutputStream stream, UnmodifiableEconomicMap<?, ?> map) throws IOException {
            stream.internalWritePackedUnsignedInt(map.size());
            UnmodifiableMapCursor cursor = map.getEntries();
            while (cursor.advance()) {
                this.debugf("%n ", new Object[0]);
                Encoder.writeId(stream, this.getId(cursor.getKey()));
                this.debugf(" :", new Object[0]);
                Encoder.writeId(stream, this.getId(cursor.getValue()));
            }
        }

        void makeMapChildIds(EconomicMap<?, ?> map, ObjectPath objectPath) {
            MapCursor cursor = map.getEntries();
            while (cursor.advance()) {
                Object key = cursor.getKey();
                Object keyString = key instanceof String ? "\"" + String.valueOf(key) + "\"" : String.valueOf(key);
                this.makeId(key, objectPath.add("{key:" + (String)keyString + "}"));
                this.makeId(cursor.getValue(), objectPath.add("{" + (String)keyString + "}"));
            }
        }

        public void writeString(ObjectCopierOutputStream stream, String s) throws IOException {
            int id = this.strings.getIndex(s);
            stream.internalWritePackedUnsignedInt(id);
            if (this.debugOutput != null) {
                this.debugf(" %s", Encoder.escapeDebugStringValue(s));
            }
        }

        public void makeStringId(String s, ObjectPath objectPath) {
            GraalError.guarantee(s != null, "Illegal null string: Path %s", (Object)objectPath);
            this.strings.addObject(s);
        }

        static void checkIllegalValue(Class<?> type, Object value, ObjectPath objectPath, String reason) {
            if (type.isInstance(value)) {
                throw new GraalError("Illegal instance of %s: %s%n  Type: %s%n  Value: %s%n  Path: %s", type.getName(), reason, value.getClass().getName(), value, objectPath);
            }
        }

        void makeId(Object obj, ObjectPath objectPath) {
            Field field = this.externalValues.get(obj);
            if (field != null) {
                if (this.objects.addObject(field)) {
                    this.makeStringId(field.getDeclaringClass().getName(), objectPath);
                    this.makeStringId(field.getName(), objectPath);
                }
                return;
            }
            if (!this.objects.addObject(obj)) {
                return;
            }
            Class<?> clazz = obj.getClass();
            Builtin builtin = this.getBuiltin(clazz);
            if (builtin != null) {
                builtin.checkObject(obj);
                this.makeStringId(clazz.getName(), objectPath);
                builtin.makeChildIds(this, obj, objectPath);
                return;
            }
            Encoder.checkIllegalValue(Field.class, obj, objectPath, "Field type is used in object copying implementation");
            Encoder.checkIllegalValue(FieldIntrospection.class, obj, objectPath, "Graal metadata type cannot be copied");
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                if (!componentType.isPrimitive()) {
                    this.strings.addObject(componentType.getName());
                    Object[] objArray = (Object[])obj;
                    int index = 0;
                    for (Object element : objArray) {
                        this.makeId(element, objectPath.add(index));
                        ++index;
                    }
                }
            } else {
                Encoder.checkIllegalValue(LocationIdentity.class, obj, objectPath, "must come from a static field");
                Encoder.checkIllegalValue(HashSet.class, obj, objectPath, "hashes are typically not stable across VM executions");
                this.makeStringId(clazz.getName(), objectPath);
                ClassInfo classInfo = this.makeClassInfo(clazz, objectPath);
                classInfo.fields().forEach((fieldDesc, f) -> {
                    String fieldName = f.getDeclaringClass().getSimpleName() + "#" + f.getName();
                    if (!f.getType().isPrimitive()) {
                        Object fieldValue = Encoder.readField(f, obj);
                        this.makeId(fieldValue, objectPath.add(fieldName));
                    }
                });
            }
        }

        private ClassInfo makeClassInfo(Class<?> clazz, ObjectPath objectPath) {
            try {
                return this.classInfos.computeIfAbsent(clazz, this::makeClassInfo);
            }
            catch (Throwable e) {
                throw new GraalError(e, "Error creating ClassInfo%n  Path: %s", objectPath);
            }
        }

        private void encode(ObjectCopierOutputStream out, Object root) throws IOException {
            String[] encodedStrings = this.strings.encodeAll((String[])new String[this.strings.getLength()]);
            out.internalWritePackedUnsignedInt(encodedStrings.length);
            for (String s : encodedStrings) {
                out.writeStringValue(s);
            }
            Object[] encodedObjects = this.objects.encodeAll((Object[])new Object[this.objects.getLength()]);
            this.debugf("root:", new Object[0]);
            Encoder.writeId(out, this.getId(root));
            this.debugf("%n", new Object[0]);
            for (int id = 1; id < encodedObjects.length; ++id) {
                Object obj = encodedObjects[id];
                Class<?> clazz = obj.getClass();
                Builtin builtin = this.getBuiltin(clazz);
                if (builtin != null) {
                    out.internalWriteByte(60);
                    this.debugf("%d:<", id);
                    this.writeString(out, clazz.getName());
                    this.debugf(" > =", new Object[0]);
                    try {
                        builtin.encode(this, out, obj);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else if (clazz.isArray()) {
                    Class<?> componentType = clazz.getComponentType();
                    if (!componentType.isPrimitive()) {
                        out.internalWriteByte(93);
                        this.debugf("%d:[", id);
                        this.writeString(out, componentType.getName());
                        this.debugf(" ] =", new Object[0]);
                        Object[] objs = (Object[])obj;
                        out.internalWritePackedUnsignedInt(objs.length);
                        for (Object o : objs) {
                            Encoder.writeId(out, this.getId(o));
                        }
                    } else {
                        out.internalWriteByte(91);
                        this.debugf("%d:[ %s ] =", id, componentType.getName());
                        out.writeTypedPrimitiveArray(obj);
                    }
                } else if (clazz == Field.class) {
                    Field field = (Field)obj;
                    out.internalWriteByte(64);
                    this.debugf("%d:@", id);
                    this.writeString(out, field.getDeclaringClass().getName());
                    this.writeString(out, field.getName());
                } else {
                    ClassInfo classInfo = (ClassInfo)this.classInfos.get(clazz);
                    out.internalWriteByte(123);
                    this.debugf("%d:{", id);
                    this.writeString(out, clazz.getName());
                    this.debugf(" }", new Object[0]);
                    out.writeShort(classInfo.fingerprint);
                    for (Map.Entry<String, Field> e : classInfo.fields().entrySet()) {
                        Field f = e.getValue();
                        this.debugf("%n ", new Object[0]);
                        Class<?> fieldType = f.getType();
                        Object fValue = Encoder.readField(f, obj);
                        if (fieldType.isPrimitive()) {
                            out.writeUntypedValue(fValue);
                        } else {
                            Encoder.writeId(out, this.getId(fValue));
                        }
                        this.debugf("\t # %s", f.getName());
                        if (fieldType.isPrimitive()) continue;
                        this.debugf(" (object)", new Object[0]);
                    }
                }
                this.debugf("%n", new Object[0]);
            }
        }

        private static void writeId(ObjectCopierOutputStream out, int id) throws IOException {
            out.writePackedUnsignedInt(id);
        }

        private int getId(Object o) {
            Field field = this.externalValues.get(o);
            if (field != null) {
                return this.objects.getIndex(field);
            }
            return this.objects.getIndex(o);
        }

        private void debugf(String format, Object ... args) {
            if (this.debugOutput != null) {
                this.debugOutput.printf(format, args);
            }
        }

        static String escapeDebugStringValue(String s) {
            return s.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        }
    }

    public static class Decoder
    extends ObjectCopier {
        private final Map<Integer, Object> idToObject = new HashMap<Integer, Object>();
        private final ClassLoader loader;
        List<Deferred> deferred;
        int recordNum = -1;
        int fieldNum = -1;
        String[] strings;

        public Decoder(ClassLoader loader) {
            this.loader = loader;
        }

        public Class<?> loadClass(String className) {
            try {
                return Class.forName(className, false, this.loader);
            }
            catch (ClassNotFoundException e) {
                throw new GraalError(e);
            }
        }

        Object getObject(int id, boolean requireNonNull) {
            Object obj = this.idToObject.get(id);
            GraalError.guarantee(obj != null || id == 0 || !requireNonNull, "Could not resolve object id: %d", (Object)id);
            return obj;
        }

        void decodeMap(ObjectCopierInputStream stream, BiConsumer<Object, Object> putMethod) throws IOException {
            int size = stream.readPackedUnsignedInt();
            for (int i = 0; i < size; ++i) {
                int keyId = Decoder.readId(stream);
                int valueId = Decoder.readId(stream);
                this.resolveId(keyId, k -> this.resolveId(valueId, v -> putMethod.accept(k, v)));
            }
        }

        private void addDecodedObject(int id, Object obj) {
            Object conflict = this.idToObject.put(id, obj);
            GraalError.guarantee(conflict == null, "Objects both have id %d: %s and %s", (Object)id, obj, conflict);
        }

        private static void writeField(Field field, Object receiver, Object value) {
            try {
                field.set(receiver, value);
            }
            catch (IllegalAccessException e) {
                throw new GraalError(e);
            }
        }

        private Object decode(byte[] encoded) {
            int rootId;
            this.deferred = new ArrayList<Deferred>();
            this.recordNum = 0;
            try (ObjectCopierInputStream stream = new ObjectCopierInputStream(new ByteArrayInputStream(encoded));){
                int nstrings = stream.readPackedUnsignedInt();
                this.strings = new String[nstrings];
                for (int i = 0; i < nstrings; ++i) {
                    this.strings[i] = stream.readStringValue();
                }
                rootId = Decoder.readId(stream);
                int id = 1;
                block18: while (true) {
                    this.recordNum = ++id;
                    this.fieldNum = -1;
                    int c = stream.read();
                    if (c == -1) break;
                    switch (c) {
                        case 60: {
                            String className = this.readString(stream);
                            Class<?> clazz = this.loadClass(className);
                            Builtin builtin = this.getBuiltin(clazz);
                            GraalError.guarantee(builtin != null, "No builtin for %s in record %d", (Object)className, (Object)this.recordNum);
                            builtin.checkClass(clazz);
                            this.addDecodedObject(id, builtin.decode(this, clazz, stream));
                            break;
                        }
                        case 91: {
                            Object arr = stream.readTypedPrimitiveArray();
                            this.addDecodedObject(id, arr);
                            break;
                        }
                        case 93: {
                            String componentTypeName = this.readString(stream);
                            Class<?> componentType = this.loadClass(componentTypeName);
                            int length = stream.readPackedUnsignedInt();
                            int[] elements = new int[length];
                            for (int i = 0; i < length; ++i) {
                                elements[i] = Decoder.readId(stream);
                            }
                            Object[] arr = (Object[])Array.newInstance(componentType, elements.length);
                            this.addDecodedObject(id, arr);
                            for (int i = 0; i < elements.length; ++i) {
                                int index = i;
                                this.resolveId(elements[i], o -> {
                                    arr[index] = o;
                                });
                            }
                            continue block18;
                        }
                        case 64: {
                            String className = this.readString(stream);
                            String fieldName = this.readString(stream);
                            Class<?> declaringClass = this.loadClass(className);
                            Field field = Decoder.getField(declaringClass, fieldName);
                            this.addDecodedObject(id, Decoder.readField(field, null));
                            break;
                        }
                        case 123: {
                            String className = this.readString(stream);
                            Class<?> clazz = this.loadClass(className);
                            Object obj = Decoder.allocateInstance(clazz);
                            this.addDecodedObject(id, obj);
                            ClassInfo classInfo = this.classInfos.computeIfAbsent(clazz, ClassInfo::of);
                            short fingerprint = stream.readShort();
                            GraalError.guarantee(fingerprint == classInfo.fingerprint, "Type mismatch on %s", clazz);
                            this.fieldNum = 0;
                            for (Field field : classInfo.fields.values()) {
                                Class<?> type = field.getType();
                                if (type.isPrimitive()) {
                                    char typeCh = type.descriptorString().charAt(0);
                                    Object value = stream.readUntypedValue(typeCh);
                                    Decoder.writeField(field, obj, value);
                                } else {
                                    int value = Decoder.readId(stream);
                                    this.resolveId(value, o -> Decoder.writeField(field, obj, o));
                                }
                                ++this.fieldNum;
                            }
                            continue block18;
                        }
                        default: {
                            throw new GraalError("Invalid char '%c' for kind in record %d", c, this.recordNum);
                        }
                    }
                }
                for (Deferred d : this.deferred) {
                    this.recordNum = d.recordNum();
                    this.fieldNum = d.fieldNum;
                    d.runnable().run();
                }
            }
            catch (Throwable e) {
                throw new GraalError(e, "Error in record %d (field %d)", this.recordNum, this.fieldNum);
            }
            finally {
                this.deferred = null;
                this.recordNum = -1;
                this.fieldNum = -1;
            }
            return this.getObject(rootId, true);
        }

        private static int readId(ObjectCopierInputStream stream) throws IOException {
            return stream.readPackedUnsignedInt();
        }

        void resolveId(int id, Consumer<Object> c) {
            if (id != 0) {
                Object objValue = this.getObject(id, false);
                if (objValue != null) {
                    c.accept(objValue);
                } else {
                    this.deferred.add(new Deferred(() -> c.accept(this.getObject(id, true)), this.recordNum, this.fieldNum));
                }
            } else {
                c.accept(null);
            }
        }

        public String readString(ObjectCopierInputStream stream) throws IOException {
            int id = stream.readPackedUnsignedInt();
            return this.strings[id];
        }

        private static Object allocateInstance(Class<?> clazz) {
            try {
                return UNSAFE.allocateInstance(clazz);
            }
            catch (InstantiationException e) {
                throw new GraalError(e);
            }
        }

        record Deferred(Runnable runnable, int recordNum, int fieldNum) {
        }
    }

    public record ClassInfo(Class<?> clazz, SortedMap<String, Field> fields, short fingerprint) {
        public static ClassInfo of(Class<?> declaringClass) {
            TreeMap<String, Field> fields = new TreeMap<String, Field>();
            Class<?> c = declaringClass;
            while (!c.equals(Object.class)) {
                for (Field f : c.getDeclaredFields()) {
                    Field conflict;
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    f.setAccessible(true);
                    Object fieldDesc = f.getName();
                    if (fields.containsKey(fieldDesc)) {
                        fieldDesc = c.getName() + "." + (String)fieldDesc;
                    }
                    GraalError.guarantee((conflict = fields.put((String)fieldDesc, f)) == null, "Cannot support 2 fields with same name and declaring class: %s and %s", (Object)conflict, (Object)f);
                }
                c = c.getSuperclass();
            }
            int h = fields.size();
            for (Map.Entry entry : fields.entrySet()) {
                h = h * 31 + ((String)entry.getKey()).hashCode();
                h = h * 31 + ((Field)entry.getValue()).getType().getName().hashCode();
            }
            return new ClassInfo(declaringClass, fields, ObjectCopier.hashIntToShort(h));
        }
    }
}

