/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases.inlining;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.truffle.phases.inlining.CallNode;
import jdk.graal.compiler.truffle.phases.inlining.CallTree;
import org.graalvm.collections.Pair;

public interface InliningPolicy {
    default public void afterAddChildren(CallNode callNode) {
    }

    default public void removedNode(CallNode node) {
    }

    default public Object newCallNodeData(CallNode callNode) {
        return null;
    }

    default public void putProperties(CallNode callNode, Map<Object, Object> properties) {
    }

    default public void afterExpand(CallNode callNode) {
    }

    default public void run(CallTree tree) {
    }

    public static boolean acceptForInline(CallNode rootNode, String inlineOnly) {
        if (inlineOnly == null) {
            return true;
        }
        Pair<List<String>, List<String>> value = InliningPolicy.getInlineOnly(inlineOnly);
        if (value != null) {
            String name = rootNode.getName();
            List includes = (List)value.getLeft();
            boolean included = includes.isEmpty();
            if (name != null) {
                for (int i = 0; !included && i < includes.size(); ++i) {
                    if (!name.contains((CharSequence)includes.get(i))) continue;
                    included = true;
                }
            }
            if (!included) {
                return false;
            }
            if (name != null) {
                for (String exclude : (List)value.getRight()) {
                    if (!name.contains(exclude)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Pair<List<String>, List<String>> getInlineOnly(String inlineOnly) {
        String[] items;
        ArrayList<String> includesList = new ArrayList<String>();
        ArrayList<String> excludesList = new ArrayList<String>();
        for (String item : items = inlineOnly.split(",")) {
            if (item.startsWith("~")) {
                excludesList.add(item.substring(1));
                continue;
            }
            includesList.add(item);
        }
        return Pair.create(includesList, excludesList);
    }
}

